/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.item.convert.ItmItemSegmentConvert;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateSimpleTree;
import com.elitesland.yst.supportdomain.item.entity.ItmCateContrParaDO;
import com.elitesland.yst.supportdomain.item.param.ItmItemCateParaSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemSegmentPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemSegmentSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemSegmentInfoRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemSegmentInfoRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.service.ItmItemSegmentInfoService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemCateParaSegmentVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSegmentDetailsVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSegmentInfoPagingVO;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemSegmentInfoServiceImpl
implements ItmItemSegmentInfoService {
    private static final String PRICE_GROUP = "priceGroup";
    private static final String PRICE_GROUP2 = "priceGroup2";
    private static final String PRICE_GROUP3 = "priceGroup3";
    private static final List<String> PRICE_GROUP_LIST = List.of("priceGroup", "priceGroup2", "priceGroup3");
    private static final String ERROR_TEMPLATE = "\u7ba1\u63a7\u53c2\u6570\u7f16\u7801\u4e3a{0},\u81f3\u591a\u53ea\u80fd\u5b58\u5728\u4e00\u6761;";
    private final ItmItemSegmentInfoRepoProc itmItemSegmentInfoRepoProc;
    private final ItmItemCateService itmItemCateService;
    private final UdcService sysUdcService;
    private final ItmItemSegmentInfoRepo itmItemSegmentInfoRepo;
    private final ItmItemCateRepo itmItemCateRepo;

    @Override
    public PagingVO<ItmItemSegmentInfoPagingVO> searchPagingList(ItmItemSegmentPagingParam param) {
        PagingVO<ItmItemSegmentInfoPagingVO> pagingVO = this.itmItemSegmentInfoRepoProc.searchPagingList(param);
        pagingVO.getRecords().forEach(page -> {
            String itemCateCode = page.getItemCateCode();
            ArrayList<String> pathName = new ArrayList<String>();
            this.buildPathName(this.itmItemCateService.findItemCatePath(itemCateCode), pathName);
            String collect = String.join((CharSequence)">", pathName);
            page.setItemCateNames(collect);
        });
        return pagingVO;
    }

    @Override
    public ItmItemSegmentDetailsVO findDetailByItemCateCode(String itemCateCode) {
        Map paramCodeMap = this.sysUdcService.getCodeMap("FIN", "PARAM_CODE");
        Map priceGroupMap = this.sysUdcService.getCodeMap("FIN", "PRICEGROUP");
        Map priceGroup2Map = this.sysUdcService.getCodeMap("FIN", "PRICEGROUP2");
        Map priceGroup3Map = this.sysUdcService.getCodeMap("FIN", "PRICEGROUP3");
        List<ItmItemCateParaSegmentVO> detailByItemCateCode = this.itmItemSegmentInfoRepoProc.findDetailByItemCateCode(itemCateCode);
        detailByItemCateCode.forEach(detail -> {
            String controlParamCode = detail.getControlParamCode();
            detail.setControlParamName((String)paramCodeMap.get(controlParamCode));
            String controlParamValue = detail.getControlParamValue();
            if (PRICE_GROUP.equals(controlParamCode)) {
                detail.setControlParamValueDesc((String)priceGroupMap.get(controlParamValue));
            } else if (PRICE_GROUP2.equals(controlParamCode)) {
                detail.setControlParamValueDesc((String)priceGroup2Map.get(controlParamValue));
            } else if (PRICE_GROUP3.equals(controlParamCode)) {
                detail.setControlParamValueDesc((String)priceGroup3Map.get(controlParamValue));
            }
        });
        ItmItemSegmentDetailsVO result = new ItmItemSegmentDetailsVO();
        result.setItemCateCode(itemCateCode);
        ArrayList<String> pathName = new ArrayList<String>();
        this.buildPathName(this.itmItemCateService.findItemCatePath(itemCateCode), pathName);
        String collect = String.join((CharSequence)">", pathName);
        result.setItemCateNames(collect);
        result.setCateParaVOs(detailByItemCateCode);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateSegment(ItmItemSegmentSaveParam param) {
        String itemCateCode = param.getItemCateCode();
        if (StringUtils.isBlank((CharSequence)itemCateCode)) {
            throw new BusinessException("\u54c1\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.itmItemCateRepo.existsByItemCateCode(itemCateCode)) {
            throw new BusinessException("\u54c1\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        List<ItmItemCateParaSaveParam> cateParaParams = param.getCateParaParams();
        StringBuilder errorInfo = new StringBuilder();
        if (CollectionUtils.isNotEmpty(cateParaParams)) {
            Map<String, Long> contrParamCountMap = cateParaParams.stream().collect(Collectors.groupingBy(ItmItemCateParaSaveParam::getControlParamCode, Collectors.counting()));
            contrParamCountMap.forEach((contrParam, count) -> {
                if (PRICE_GROUP_LIST.contains(contrParam)) {
                    if (count > 1L) {
                        errorInfo.append(MessageFormat.format(ERROR_TEMPLATE, contrParam));
                    }
                } else {
                    throw new BusinessException("\u8be5\u7ba1\u63a7\u53c2\u6570\u7f16\u7801`" + contrParam + "`\u4e0d\u5b58\u5728");
                }
            });
            if (StringUtils.isNotBlank((CharSequence)errorInfo.toString())) {
                throw new BusinessException(errorInfo.toString());
            }
        }
        this.itmItemSegmentInfoRepoProc.hardDeleteSegment(itemCateCode);
        List<ItmCateContrParaDO> itmCateContrParaDOS = ItmItemSegmentConvert.INSTANCE.paramToDo(param.getCateParaParams());
        itmCateContrParaDOS.forEach(contrPara -> contrPara.setItemCateCode(itemCateCode));
        this.itmItemSegmentInfoRepo.saveAll(itmCateContrParaDOS);
    }

    private void buildPathName(List<ItmItemCateSimpleTree> tree, List<String> pathName) {
        if (CollectionUtils.isEmpty(tree)) {
            return;
        }
        tree.forEach(t -> {
            pathName.add(t.getItemCateName());
            this.buildPathName(t.getTreeNodes(), pathName);
        });
    }

    public ItmItemSegmentInfoServiceImpl(ItmItemSegmentInfoRepoProc itmItemSegmentInfoRepoProc, ItmItemCateService itmItemCateService, UdcService sysUdcService, ItmItemSegmentInfoRepo itmItemSegmentInfoRepo, ItmItemCateRepo itmItemCateRepo) {
        this.itmItemSegmentInfoRepoProc = itmItemSegmentInfoRepoProc;
        this.itmItemCateService = itmItemCateService;
        this.sysUdcService = sysUdcService;
        this.itmItemSegmentInfoRepo = itmItemSegmentInfoRepo;
        this.itmItemCateRepo = itmItemCateRepo;
    }
}

