/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.comm.consumer.dto.ComTaxRateRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComTaxRateRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComTaxRateRpcService;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.provider.IdGeneratorProvider;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.core.udc.SysUdcProxyService;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemBaseInfoVO;
import com.elitesland.yst.supportdomain.item.convert.ItmItemAttachmentConvert;
import com.elitesland.yst.supportdomain.item.convert.ItmItemConvert;
import com.elitesland.yst.supportdomain.item.dto.ItmItemDTO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemBusinessDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.param.ItmItemAttachmentSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemBatchDeleteParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemBusinessSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemPubBusiParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemSkuSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemSpuPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemSpuPublishParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemSpuSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemTagSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemUomConvSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmSkuImageSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemBusinessRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemBusinessRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemAttachmentService;
import com.elitesland.yst.supportdomain.item.service.ItmItemBusinessService;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.service.ItmItemCustPropService;
import com.elitesland.yst.supportdomain.item.service.ItmItemPropService;
import com.elitesland.yst.supportdomain.item.service.ItmItemQualifyService;
import com.elitesland.yst.supportdomain.item.service.ItmItemService;
import com.elitesland.yst.supportdomain.item.service.ItmItemTagService;
import com.elitesland.yst.supportdomain.item.service.ItmItemUomConvService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemChangUpdateVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemPubBusiParamVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSkuVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSpuAndSourceVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSpuDetailsVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSpuPagingVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemTagVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemUomConvVO;
import com.elitesland.yst.supportdomain.item.vo.ItmSkuImageVO;
import com.elitesland.yst.supportdomain.org.dto.OrgBuDTO;
import com.elitesland.yst.supportdomain.org.entity.OrgBuDO;
import com.elitesland.yst.supportdomain.org.param.OrgBuDtoParam;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import com.elitesland.yst.supportdomain.pri.convert.PriMainPriceConvert;
import com.elitesland.yst.supportdomain.pri.entity.PriMainPriceRowDO;
import com.elitesland.yst.supportdomain.pri.enums.PriMainPriceUdcEnum;
import com.elitesland.yst.supportdomain.pri.param.PriItemPriceSaveRowParam;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceRowRepo;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceService;
import com.elitesland.yst.supportdomain.pri.vo.PriItemPricePagingVO;
import com.elitesland.yst.supportdomain.util.ComUdcEnum;
import com.elitesland.yst.supportdomain.util.GuaranteeConvUtil;
import com.elitesland.yst.supportdomain.util.ItmItemAttachmenTypeEnum;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemServiceImpl
implements ItmItemService {
    private static final Logger log = LoggerFactory.getLogger(ItmItemServiceImpl.class);
    private static final String SPU_NO = "SPU_NO";
    private static final String SKU_NO = "SKU_NO";
    private static final String SKU_BAR_CODE = "SKU_BAR_CODE";
    private static final String CNY = "CNY";
    private static final String NORMAL = "\u6b63\u5e38";
    private final SysUdcProxyService sysUdcProxyService;
    private final ItmItemAttachmentService itmItemAttachmentService;
    private final ItmItemCateService itmItemCateService;
    private final ItmItemPropService itmItemPropService;
    private final ItmItemTagService itmItemTagService;
    private final ItmItemCustPropService itmItemCustPropService;
    private final ItmItemQualifyService itmItemQualifyService;
    private final PriMainPriceService priMainPriceService;
    private final ItmItemUomConvService itmItemUomConvService;
    private final ItmItemBusinessService itmItemBusinessService;
    private final OrgBuRepo orgBuRepo;
    private final PriMainPriceRowRepo priMainPriceRowRepo;
    private final OrgBuService orgBuService;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final ItmItemRepo itmItemRepo;
    private final ItmItemRepoProc itmItemRepoProc;
    private final ItmItemBusinessRepoProc itmItemBusinessRepoProc;
    private final ItmItemBusinessRepo itmItemBusinessRepo;
    private final UdcService sysUdcService;
    @DubboReference
    private ComTaxRateRpcService comTaxRateRpcService;
    private final IdGeneratorProvider idGeneratorProvider;

    @Override
    @SysCodeProc
    public PagingVO<ItmItemSpuPagingVO> itemSpuPagingSearch(ItmItemSpuPagingParam param) {
        PagingVO<ItmItemSpuPagingVO> result = this.itmItemRepoProc.selectSpuPagingResult(param);
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            OrgBuDtoParam buParam;
            List<OrgBuDTO> orgBuDtos;
            ArrayList<String> buCodes = new ArrayList<String>();
            ArrayList taxRateNos = new ArrayList();
            result.getRecords().forEach(vo -> {
                if (StringUtils.isNotBlank((CharSequence)vo.getItemSource()) && !buCodes.contains(vo.getItemSource())) {
                    buCodes.add(vo.getItemSource());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxRateNo()) && !taxRateNos.contains(vo.getTaxRateNo())) {
                    taxRateNos.add(vo.getTaxRateNo());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxRateNo2()) && !taxRateNos.contains(vo.getTaxRateNo2())) {
                    taxRateNos.add(vo.getTaxRateNo2());
                }
            });
            Map<Object, Object> buMap = Collections.emptyMap();
            if (CollectionUtils.isNotEmpty(buCodes) && CollectionUtils.isNotEmpty(orgBuDtos = this.orgBuService.findBuDtoByParam(buParam = OrgBuDtoParam.builder().buCodes(buCodes).build()))) {
                buMap = orgBuDtos.stream().collect(Collectors.toMap(OrgBuDTO::getBuCode, t -> t));
            }
            Map<Object, Object> taxMap = Collections.emptyMap();
            if (CollectionUtils.isNotEmpty(taxRateNos)) {
                ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
                taxParam.setTaxRateNos(taxRateNos);
                List taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam);
                if (CollectionUtils.isNotEmpty((Collection)taxDtos)) {
                    taxMap = taxDtos.stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, t -> t));
                }
            }
            for (ItmItemSpuPagingVO record : result.getRecords()) {
                ComTaxRateRpcDTO tax;
                OrgBuDTO bu;
                if (StringUtils.isNotBlank((CharSequence)record.getItemCateCode())) {
                    record.setItemCatePath(this.itmItemCateService.findItemCatePath(record.getItemCateCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)record.getItemSource()) && (bu = (OrgBuDTO)buMap.get(record.getItemSource())) != null) {
                    record.setItemSourceName(bu.getBuName());
                }
                if (StringUtils.isNotBlank((CharSequence)record.getTaxRateNo()) && (tax = (ComTaxRateRpcDTO)taxMap.get(record.getTaxRateNo())) != null) {
                    record.setTaxRate(BigDecimal.valueOf(tax.getTaxRateValue()));
                }
                if (!StringUtils.isNotBlank((CharSequence)record.getTaxRateNo2()) || (tax = (ComTaxRateRpcDTO)taxMap.get(record.getTaxRateNo2())) == null) continue;
                record.setTaxRate2(BigDecimal.valueOf(tax.getTaxRateValue()));
            }
        }
        return result;
    }

    @Override
    public ItmItemSpuDetailsVO findSpuDetailsBySpuId(Long id) {
        OrgBuDtoParam buParam;
        List<OrgBuDTO> buDtos;
        ItmItemSpuDetailsVO result = this.itmItemRepoProc.searchSpuDetailVoById(id);
        Map lifeStatusMap = this.sysUdcService.getCodeMap("ITM", "ITEM_LIFE_STATUS");
        if (result == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6307\u5b9a\u6570\u636e");
        }
        boolean isDraft = ItmUdcEnum.ITEM_STATUS_DRAFT.getUdcVal().equals(result.getItemStatus());
        if (!StringUtils.isBlank((CharSequence)result.getItemCateCode())) {
            result.setItemCatePath(this.itmItemCateService.findItemCatePath(result.getItemCateCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)result.getItemSource()) && CollectionUtils.isNotEmpty(buDtos = this.orgBuService.findBuDtoByParam(buParam = OrgBuDtoParam.builder().buCodes(Collections.singletonList(result.getItemSource())).build()))) {
            result.setItemSourceName(buDtos.get(0).getBuName());
        }
        ArrayList<String> taxRateNos = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)result.getTaxRateNo())) {
            taxRateNos.add(result.getTaxRateNo());
        }
        if (StringUtils.isNotBlank((CharSequence)result.getTaxRateNo2())) {
            taxRateNos.add(result.getTaxRateNo2());
        }
        if (CollectionUtils.isNotEmpty(taxRateNos)) {
            ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
            taxParam.setTaxRateNos(taxRateNos);
            List taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam);
            if (CollectionUtils.isNotEmpty((Collection)taxDtos)) {
                ComTaxRateRpcDTO tax;
                Map<String, ComTaxRateRpcDTO> taxMap = taxDtos.stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, t -> t));
                if (StringUtils.isNotBlank((CharSequence)result.getTaxRateNo()) && (tax = taxMap.get(result.getTaxRateNo())) != null) {
                    result.setTaxRate(BigDecimal.valueOf(tax.getTaxRateValue()));
                    result.setTaxRateDesc(tax.getTaxRateDesc());
                }
                if (StringUtils.isNotBlank((CharSequence)result.getTaxRateNo2()) && (tax = taxMap.get(result.getTaxRateNo2())) != null) {
                    result.setTaxRate2(BigDecimal.valueOf(tax.getTaxRateValue()));
                    result.setTaxRate2Desc(tax.getTaxRateDesc());
                }
            }
        }
        List<ItmItemSkuVO> skuVos = this.itmItemRepoProc.findSkuVosBySpuId(result.getSpuId());
        this.sysUdcProxyService.translate(skuVos);
        if (!CollectionUtils.isEmpty(skuVos)) {
            List<Long> itemIds = skuVos.stream().map(ItmItemSkuVO::getId).collect(Collectors.toList());
            List<String> itemCodes = skuVos.stream().map(ItmItemSkuVO::getItemCode).collect(Collectors.toList());
            Map<Long, ItmSkuImageVO> skuImageMap = this.itmItemAttachmentService.findSkuImgByItemIds(itemIds).stream().collect(Collectors.toMap(ItmSkuImageVO::getItemId, t -> t));
            Map<String, PriItemPricePagingVO> skuPriceMap = this.priMainPriceService.priMainPriceQuery(itemCodes, !isDraft).stream().collect(Collectors.toMap(PriItemPricePagingVO::getItemCode, t -> t));
            Map<Long, List<ItmItemTagVO>> skuTagMap = this.itmItemTagService.findVoByItemIds(itemIds).stream().collect(Collectors.groupingBy(ItmItemTagVO::getItemId));
            Map<Long, List<ItmItemUomConvVO>> uomConvMap = this.itmItemUomConvService.getItmItemUomConvByItemIds(itemIds).stream().collect(Collectors.groupingBy(ItmItemUomConvVO::getItemId));
            skuVos.forEach(sku -> {
                if (StringUtils.isBlank((CharSequence)sku.getItemStatus2())) {
                    sku.setItemStatus2(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_ENABLE.getValDesc());
                } else {
                    String itemLifeStatusName = Arrays.stream(sku.getItemStatus2().split(";")).map(lifeStatusMap::get).collect(Collectors.joining(";"));
                    sku.setItemStatus2(itemLifeStatusName);
                }
                Long itemId = sku.getId();
                String itemCode = sku.getItemCode();
                if (skuImageMap.containsKey(itemId)) {
                    sku.setImgCode(((ItmSkuImageVO)skuImageMap.get(itemId)).getFileCode());
                    sku.setImgName(((ItmSkuImageVO)skuImageMap.get(itemId)).getFileName());
                }
                if (skuPriceMap.containsKey(itemCode)) {
                    ItmItemConvert.INSTANCE.updateSkuVoFromPricePagingVo((PriItemPricePagingVO)skuPriceMap.get(itemCode), (ItmItemSkuVO)sku);
                }
                if (skuTagMap.containsKey(itemId)) {
                    sku.setItemTags((List)skuTagMap.get(itemId));
                }
                if (uomConvMap.containsKey(itemId)) {
                    sku.setItemUomConvVos((List)uomConvMap.get(itemId));
                }
            });
            result.setItemSkuVos(skuVos);
        }
        result.setSpuImages(this.itmItemAttachmentService.findAttachmentByItemIdAndFileType(id, ItmItemAttachmenTypeEnum.IMG.name()));
        result.setSpuVideos(this.itmItemAttachmentService.findAttachmentByItemIdAndFileType(id, ItmItemAttachmenTypeEnum.VIDEO.name()));
        result.setItemPropVos(this.itmItemPropService.findVosByItemId(id));
        result.setItemQualifyVos(this.itmItemQualifyService.findVosBySpuId(id));
        result.setItemCustPropVos(this.itmItemCustPropService.findVosByItemId(id));
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateSpu(ItmItemSpuSaveParam param) {
        if (CollectionUtils.isEmpty(param.getItemSkuSaveParams())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "SKU\u4fe1\u606f\u81f3\u5c11\u8981\u6709\u4e00\u6761");
        }
        List<ItmItemSkuSaveParam> skuSaveParams = param.getItemSkuSaveParams();
        Long spuId = param.getSpuId();
        if (spuId == null) {
            spuId = this.itmSpuInsert(param, skuSaveParams);
        } else {
            this.itmSpuUpdate(param, skuSaveParams);
        }
        List<ItmItemAttachmentSaveParam> itmAttachmentSaveParams = this.mergeAttachSaveParams(param.getSpuImages(), param.getSpuVideos());
        this.itmItemAttachmentService.itemAttachmentsHardSave(spuId, itmAttachmentSaveParams);
        this.itmItemPropService.itemPropsHardSave(spuId, param.getItemPropSaveParams());
        this.itmItemQualifyService.itemQualifyHardSave(spuId, param.getItemQualifySaveParams());
        this.itmItemCustPropService.itemCustPropHardSave(spuId, param.getItemCustPropSaveParams());
        return spuId;
    }

    private Long itmSpuInsert(ItmItemSpuSaveParam param, List<ItmItemSkuSaveParam> skuSaveParams) {
        if (this.itmItemRepo.existsBySpuNameAndSuppCodeAndItemCateCode(param.getSpuName(), param.getSuppCode(), param.getItemCateCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c'\u5546\u54c1\u540d\u79f0'\uff0c'\u54c1\u7c7b'\uff0c'\u4f9b\u5e94\u5546'\u7684\u5546\u54c1");
        }
        List<ItmItemDO> itmItemDos = ItmItemConvert.INSTANCE.skuSaveParamToDo(skuSaveParams);
        Long spuId = this.idGeneratorProvider.nextId();
        String spuCode = this.sysNumberGeneratorWrapper.generate(SPU_NO);
        if (this.itmItemRepo.existsBySpuCode(spuCode)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7684 SPU \u7f16\u53f7\uff1a" + spuCode + " \u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u914d\u7f6e\u662f\u5426\u6b63\u786e");
        }
        boolean singleSku = itmItemDos.size() == 1;
        Optional<OrgBuDO> byBuCode = this.orgBuRepo.findByBuCode(param.getItemSource());
        for (ItmItemDO item : itmItemDos) {
            ItmItemConvert.INSTANCE.updateDoFromSpuSaveParam(param, item);
            item.setSpuId(spuId);
            item.setSpuCode(spuCode);
            item.setItemStatus(ItmUdcEnum.ITEM_STATUS_DRAFT.getUdcVal());
            item.setGuaranteeDays(GuaranteeConvUtil.convertToDays(item.getGuaranteePeriod(), item.getGuaranteePeriodUnit()));
            if (singleSku) {
                item.setItemCode(spuCode);
            } else {
                String skuCode = this.sysNumberGeneratorWrapper.generate(SKU_NO, spuCode);
                if (this.itmItemRepo.existsByItemCode(skuCode)) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7684 SKU \u7f16\u53f7\uff1a" + skuCode + " \u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u914d\u7f6e\u662f\u5426\u6b63\u786e");
                }
                item.setItemCode(skuCode);
            }
            if (StringUtils.isBlank((CharSequence)item.getBarCode())) {
                item.setBarCode(this.sysNumberGeneratorWrapper.generate(SKU_BAR_CODE));
            }
            if (!byBuCode.isPresent()) continue;
            Long ouId = byBuCode.get().getOuId();
            item.setSecOuId(ouId);
            GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
        }
        this.itmItemRepo.saveAll(itmItemDos);
        ArrayList<ItmSkuImageSaveParam> skuImageSaveParams = new ArrayList<ItmSkuImageSaveParam>();
        ArrayList<PriItemPriceSaveRowParam> skuPriceSaveParams = new ArrayList<PriItemPriceSaveRowParam>();
        ArrayList<ItmItemTagSaveParam> itemTagSaveParams = new ArrayList<ItmItemTagSaveParam>();
        ArrayList<ItmItemUomConvSaveParam> uomConvSaveParams = new ArrayList<ItmItemUomConvSaveParam>();
        for (int i = 0; i < itmItemDos.size(); ++i) {
            List<ItmItemUomConvSaveParam> convSaveParams;
            List<ItmItemTagSaveParam> tagSaveParams;
            ItmItemSkuSaveParam skuSaveParam = skuSaveParams.get(i);
            ItmItemDO item = itmItemDos.get(i);
            ItmSkuImageSaveParam skuImage = ItmItemAttachmentConvert.INSTANCE.skuSaveParamToSkuImageSaveParam(skuSaveParam);
            skuImage.setItemId(item.getId());
            skuImage.setFileType(ItmItemAttachmenTypeEnum.IMG.name());
            skuImageSaveParams.add(skuImage);
            if (skuSaveParam.getPrice1() != null || skuSaveParam.getPrice2() != null || skuSaveParam.getPrice3() != null || skuSaveParam.getPrice4() != null || skuSaveParam.getPrice5() != null || skuSaveParam.getPrice6() != null || skuSaveParam.getPrice7() != null || skuSaveParam.getPrice8() != null) {
                PriItemPriceSaveRowParam skuPrice = PriMainPriceConvert.INSTANCE.skuSaveParamToPriceSaveParam(skuSaveParam);
                skuPrice.setItemId(item.getId());
                skuPrice.setItemCode(item.getItemCode());
                skuPrice.setUom(item.getUom());
                skuPrice.setBuCode(item.getItemSource());
                if (skuPrice.getCurrCode() == null) {
                    skuPrice.setCurrCode(CNY);
                }
                skuPriceSaveParams.add(skuPrice);
            }
            if (!CollectionUtils.isEmpty(tagSaveParams = skuSaveParam.getItemSaveTags())) {
                tagSaveParams.forEach(t -> t.setItemId(item.getId()));
                itemTagSaveParams.addAll(tagSaveParams);
            }
            if (CollectionUtils.isEmpty(convSaveParams = skuSaveParam.getItemUomConvSaveParams())) continue;
            convSaveParams.forEach(t -> t.setItemId(item.getId()));
            uomConvSaveParams.addAll(convSaveParams);
        }
        this.itmItemAttachmentService.skuImgHardSave(null, skuImageSaveParams);
        if (CollectionUtils.isNotEmpty(skuPriceSaveParams)) {
            this.priMainPriceService.priMainPriceSave(skuPriceSaveParams, null, ComUdcEnum.COM_INACTIVE.getUdcVal());
        }
        this.itmItemTagService.itemTagHardSave(null, itemTagSaveParams);
        this.itmItemUomConvService.itemUomConvHardSave(null, uomConvSaveParams);
        return spuId;
    }

    private void itmSpuUpdate(ItmItemSpuSaveParam param, List<ItmItemSkuSaveParam> skuSaveParams) {
        List<ItmItemUomConvSaveParam> convSaveParams;
        List<ItmItemTagSaveParam> tagSaveParams;
        PriItemPriceSaveRowParam skuPrice;
        ItmSkuImageSaveParam skuImage;
        if (this.itmItemRepo.existsBySpuNameAndSuppCodeAndItemCateCodeAndSpuIdNot(param.getSpuName(), param.getSuppCode(), param.getItemCateCode(), param.getSpuId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c'\u5546\u54c1\u540d\u79f0'\uff0c'\u54c1\u7c7b'\uff0c'\u4f9b\u5e94\u5546'\u7684\u5546\u54c1");
        }
        List<ItmItemDO> itmItemDos = this.itmItemRepo.findBySpuId(param.getSpuId());
        if (CollectionUtils.isEmpty(itmItemDos)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "SPU\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        boolean isChange = ItmUdcEnum.ITEM_STATUS_ENABLE.getUdcVal().equals(itmItemDos.get(0).getItemStatus());
        List existsIds = itmItemDos.stream().map(BaseModel::getId).collect(Collectors.toList());
        List updateSkuParams = skuSaveParams.stream().filter(skuSaveParam -> existsIds.contains(skuSaveParam.getId())).collect(Collectors.toList());
        List updateIds = updateSkuParams.stream().map(ItmItemSkuSaveParam::getId).collect(Collectors.toList());
        List insertSkuParams = skuSaveParams.stream().filter(skuSaveParam -> !updateIds.contains(skuSaveParam.getId())).peek(skuSaveParam -> skuSaveParam.setId(null)).collect(Collectors.toList());
        List deleteDos = itmItemDos.stream().filter(item -> !updateIds.contains(item.getId())).collect(Collectors.toList());
        ArrayList<ItmSkuImageSaveParam> skuImageSaveParams = new ArrayList<ItmSkuImageSaveParam>();
        ArrayList<PriItemPriceSaveRowParam> skuPriceSaveParams = new ArrayList<PriItemPriceSaveRowParam>();
        ArrayList<ItmItemTagSaveParam> itemTagSaveParams = new ArrayList<ItmItemTagSaveParam>();
        ArrayList<ItmItemUomConvSaveParam> uomConvSaveParams = new ArrayList<ItmItemUomConvSaveParam>();
        if (!CollectionUtils.isEmpty(updateSkuParams)) {
            Map<Long, ItmItemDO> updateDoMap = itmItemDos.stream().filter(item -> updateIds.contains(item.getId())).collect(Collectors.toMap(BaseModel::getId, t -> t));
            List updateDos = updateSkuParams.stream().map(skuSaveParam -> {
                ItmItemDO updateDo = (ItmItemDO)updateDoMap.get(skuSaveParam.getId());
                ItmItemConvert.INSTANCE.updateDoFromSpuSaveParam(param, updateDo);
                updateDo.setGuaranteeDays(GuaranteeConvUtil.convertToDays(updateDo.getGuaranteePeriod(), updateDo.getGuaranteePeriodUnit()));
                ItmItemConvert.INSTANCE.updateDoFromSkuSaveParam((ItmItemSkuSaveParam)skuSaveParam, updateDo);
                return updateDo;
            }).collect(Collectors.toList());
            this.itmItemRepo.saveAll(updateDos);
            for (ItmItemSkuSaveParam updateSkuParam : updateSkuParams) {
                skuImage = ItmItemAttachmentConvert.INSTANCE.skuSaveParamToSkuImageSaveParam(updateSkuParam);
                skuImage.setItemId(updateSkuParam.getId());
                skuImage.setFileType(ItmItemAttachmenTypeEnum.IMG.name());
                skuImageSaveParams.add(skuImage);
                if (!(isChange || updateSkuParam.getPrice1() == null && updateSkuParam.getPrice2() == null && updateSkuParam.getPrice3() == null && updateSkuParam.getPrice4() == null && updateSkuParam.getPrice5() == null && updateSkuParam.getPrice6() == null && updateSkuParam.getPrice7() == null && updateSkuParam.getPrice8() == null)) {
                    skuPrice = PriMainPriceConvert.INSTANCE.skuSaveParamToPriceSaveParam(updateSkuParam);
                    skuPrice.setItemId(updateSkuParam.getId());
                    skuPrice.setBuCode(param.getItemSource());
                    if (skuPrice.getCurrCode() == null) {
                        skuPrice.setCurrCode(CNY);
                    }
                    skuPriceSaveParams.add(skuPrice);
                }
                if (!CollectionUtils.isEmpty(tagSaveParams = updateSkuParam.getItemSaveTags())) {
                    tagSaveParams.forEach(t -> t.setItemId(updateSkuParam.getId()));
                    itemTagSaveParams.addAll(tagSaveParams);
                }
                if (CollectionUtils.isEmpty(convSaveParams = updateSkuParam.getItemUomConvSaveParams())) continue;
                convSaveParams.forEach(t -> t.setItemId(updateSkuParam.getId()));
                uomConvSaveParams.addAll(convSaveParams);
            }
        }
        if (!CollectionUtils.isEmpty(insertSkuParams)) {
            List insertDos = insertSkuParams.stream().map(insertSkuParam -> {
                ItmItemDO insertDo = ItmItemConvert.INSTANCE.skuSaveParamToDo((ItmItemSkuSaveParam)insertSkuParam);
                ItmItemConvert.INSTANCE.updateDoFromSpuSaveParam(param, insertDo);
                insertDo.setGuaranteeDays(GuaranteeConvUtil.convertToDays(param.getGuaranteePeriod(), param.getGuaranteePeriodUnit()));
                String skuCode = this.sysNumberGeneratorWrapper.generate(SKU_NO, param.getSpuCode());
                if (this.itmItemRepo.existsByItemCode(skuCode)) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7684 SKU \u7f16\u53f7\uff1a" + skuCode + " \u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u914d\u7f6e\u662f\u5426\u6b63\u786e");
                }
                insertDo.setItemCode(skuCode);
                if (StringUtils.isBlank((CharSequence)insertSkuParam.getBarCode())) {
                    insertDo.setBarCode(this.sysNumberGeneratorWrapper.generate(SKU_BAR_CODE));
                }
                if (isChange) {
                    insertDo.setItemStatus(ItmUdcEnum.ITEM_STATUS_ENABLE.getUdcVal());
                }
                return insertDo;
            }).collect(Collectors.toList());
            this.itmItemRepo.saveAll(insertDos);
            for (int i = 0; i < insertDos.size(); ++i) {
                ItmItemSkuSaveParam insertSkuParam2 = (ItmItemSkuSaveParam)insertSkuParams.get(i);
                ItmItemDO item2 = (ItmItemDO)insertDos.get(i);
                skuImage = ItmItemAttachmentConvert.INSTANCE.skuSaveParamToSkuImageSaveParam(insertSkuParam2);
                skuImage.setItemId(item2.getId());
                skuImage.setFileType(ItmItemAttachmenTypeEnum.IMG.name());
                skuImageSaveParams.add(skuImage);
                if (insertSkuParam2.getPrice1() != null || insertSkuParam2.getPrice2() != null || insertSkuParam2.getPrice3() != null || insertSkuParam2.getPrice4() != null || insertSkuParam2.getPrice5() != null || insertSkuParam2.getPrice6() != null || insertSkuParam2.getPrice7() != null || insertSkuParam2.getPrice8() != null) {
                    skuPrice = PriMainPriceConvert.INSTANCE.skuSaveParamToPriceSaveParam(insertSkuParam2);
                    skuPrice.setItemId(item2.getId());
                    skuPrice.setItemCode(item2.getItemCode());
                    skuPrice.setUom(item2.getUom());
                    skuPrice.setBuCode(item2.getItemSource());
                    if (skuPrice.getCurrCode() == null) {
                        skuPrice.setCurrCode(CNY);
                    }
                    skuPriceSaveParams.add(skuPrice);
                }
                if (!CollectionUtils.isEmpty(tagSaveParams = insertSkuParam2.getItemSaveTags())) {
                    tagSaveParams.forEach(t -> t.setItemId(item2.getId()));
                    itemTagSaveParams.addAll(tagSaveParams);
                }
                if (CollectionUtils.isEmpty(convSaveParams = insertSkuParam2.getItemUomConvSaveParams())) continue;
                convSaveParams.forEach(t -> t.setItemId(item2.getId()));
                uomConvSaveParams.addAll(convSaveParams);
            }
        }
        if (!CollectionUtils.isEmpty(deleteDos) && !isChange) {
            this.itmItemRepo.deleteInBatch(deleteDos);
        }
        if (CollectionUtils.isNotEmpty(skuPriceSaveParams)) {
            if (isChange) {
                LocalDate now = LocalDate.now();
                LocalDateTime validFrom = LocalDateTime.of(now, LocalTime.MIN);
                LocalDateTime validTo = LocalDateTime.of(now.plusYears(30L), LocalTime.MIN);
                skuPriceSaveParams.forEach(t -> {
                    t.setValidFrom(validFrom);
                    t.setValidTo(validTo);
                });
                this.priMainPriceService.priMainPriceSave(skuPriceSaveParams, Collections.emptyList(), ComUdcEnum.COM_ACTIVE.getUdcVal());
            } else {
                List<String> itemCodes = itmItemDos.stream().map(ItmItemDO::getItemCode).collect(Collectors.toList());
                this.priMainPriceService.priMainPriceSave(skuPriceSaveParams, itemCodes, ComUdcEnum.COM_INACTIVE.getUdcVal());
            }
        }
        List<Long> itemIds = itmItemDos.stream().map(BaseModel::getId).collect(Collectors.toList());
        this.itmItemAttachmentService.skuImgHardSave(itemIds, skuImageSaveParams);
        this.itmItemTagService.itemTagHardSave(itemIds, itemTagSaveParams);
        this.itmItemUomConvService.itemUomConvHardSave(itemIds, uomConvSaveParams);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itmSpuUpdateApply(ItmItemSpuSaveParam param, List<ItmItemSkuSaveParam> skuSaveParams, ItmItemBaseInfoVO itmItemBaseInfo) {
        ItmSkuImageSaveParam skuImage;
        if (this.itmItemRepo.existsBySpuNameAndSuppCodeAndItemCateCodeAndSpuIdNot(param.getSpuName(), param.getSuppCode(), param.getItemCateCode(), param.getSpuId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c'\u5546\u54c1\u540d\u79f0'\uff0c'\u54c1\u7c7b'\uff0c'\u4f9b\u5e94\u5546'\u7684\u5546\u54c1");
        }
        List<ItmItemDO> itmItemDos = this.itmItemRepo.findBySpuId(param.getSpuId());
        boolean isChange = ItmUdcEnum.ITEM_STATUS_ENABLE.getUdcVal().equals(itmItemDos.get(0).getItemStatus());
        if (CollectionUtils.isEmpty(itmItemDos)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "SPU\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        List existsIds = itmItemDos.stream().map(BaseModel::getId).collect(Collectors.toList());
        List updateSkuParams = skuSaveParams.stream().filter(skuSaveParam -> existsIds.contains(skuSaveParam.getId())).collect(Collectors.toList());
        List updateIds = updateSkuParams.stream().map(ItmItemSkuSaveParam::getId).collect(Collectors.toList());
        List insertSkuParams = skuSaveParams.stream().filter(skuSaveParam -> !updateIds.contains(skuSaveParam.getId())).peek(skuSaveParam -> skuSaveParam.setId(null)).collect(Collectors.toList());
        List deleteDos = itmItemDos.stream().filter(item -> !updateIds.contains(item.getId())).collect(Collectors.toList());
        ArrayList<ItmSkuImageSaveParam> skuImageSaveParams = new ArrayList<ItmSkuImageSaveParam>();
        ArrayList<ItmItemTagSaveParam> itemTagSaveParams = new ArrayList<ItmItemTagSaveParam>();
        ArrayList<ItmItemUomConvSaveParam> uomConvSaveParams = new ArrayList<ItmItemUomConvSaveParam>();
        if (!CollectionUtils.isEmpty(updateSkuParams)) {
            Map<Long, ItmItemDO> updateDoMap = itmItemDos.stream().filter(item -> updateIds.contains(item.getId())).collect(Collectors.toMap(BaseModel::getId, t -> t));
            List<String> itemCodes = updateSkuParams.stream().map(ItmItemSkuSaveParam::getItemCode).collect(Collectors.toList());
            Map itemStatusMap = this.itmItemRepoProc.findSpuInfoByItemCode(itemCodes).stream().collect(HashMap::new, (m, v) -> m.put(v.getItemCode(), StringUtils.isNotBlank((CharSequence)v.getItemStatus2()) ? v.getItemStatus2() : ItmUdcEnum.ITM_ITEM_LIFE_STATUS_ENABLE.getUdcVal()), HashMap::putAll);
            List updateDos = updateSkuParams.stream().map(skuSaveParam -> {
                ItmItemDO updateDo = (ItmItemDO)updateDoMap.get(skuSaveParam.getId());
                ItmItemConvert.INSTANCE.updateDoFromSpuSaveParam(param, updateDo);
                updateDo.setGuaranteeDays(GuaranteeConvUtil.convertToDays(updateDo.getGuaranteePeriod(), updateDo.getGuaranteePeriodUnit()));
                ItmItemConvert.INSTANCE.updateDoFromSkuSaveParam((ItmItemSkuSaveParam)skuSaveParam, updateDo);
                updateDo.setItemStatus2((String)itemStatusMap.get(updateDo.getItemCode()));
                return updateDo;
            }).collect(Collectors.toList());
            this.itmItemRepo.saveAll(updateDos);
            for (ItmItemSkuSaveParam updateSkuParam : updateSkuParams) {
                List<ItmItemUomConvSaveParam> convSaveParams;
                skuImage = ItmItemAttachmentConvert.INSTANCE.skuSaveParamToSkuImageSaveParam(updateSkuParam);
                skuImage.setItemId(updateSkuParam.getId());
                skuImage.setFileType(ItmItemAttachmenTypeEnum.IMG.name());
                skuImageSaveParams.add(skuImage);
                List<ItmItemTagSaveParam> tagSaveParams = updateSkuParam.getItemSaveTags();
                if (!CollectionUtils.isEmpty(tagSaveParams)) {
                    tagSaveParams.forEach(t -> t.setItemId(updateSkuParam.getId()));
                    itemTagSaveParams.addAll(tagSaveParams);
                }
                if (CollectionUtils.isEmpty(convSaveParams = updateSkuParam.getItemUomConvSaveParams())) continue;
                convSaveParams.forEach(t -> t.setItemId(updateSkuParam.getId()));
                uomConvSaveParams.addAll(convSaveParams);
            }
        }
        LocalDate nowDate = LocalDate.now();
        ArrayList<PriMainPriceRowDO> priceRowDos = new ArrayList<PriMainPriceRowDO>();
        if (!CollectionUtils.isEmpty(insertSkuParams)) {
            List insertDos = insertSkuParams.stream().map(insertSkuParam -> {
                ItmItemDO insertDo = ItmItemConvert.INSTANCE.skuSaveParamToDo((ItmItemSkuSaveParam)insertSkuParam);
                insertDo.setOuId(itmItemBaseInfo.getOuId());
                insertDo.setOuName(itmItemBaseInfo.getOuName());
                insertDo.setBuId(itmItemBaseInfo.getBuId());
                insertDo.setSecOuId(itmItemBaseInfo.getSecOuId());
                ItmItemConvert.INSTANCE.updateDoFromSpuSaveParam(param, insertDo);
                insertDo.setGuaranteeDays(GuaranteeConvUtil.convertToDays(param.getGuaranteePeriod(), param.getGuaranteePeriodUnit()));
                if (StringUtils.isBlank((CharSequence)insertSkuParam.getBarCode())) {
                    insertDo.setBarCode(this.sysNumberGeneratorWrapper.generate(SKU_BAR_CODE));
                }
                if (isChange) {
                    insertDo.setItemStatus(ItmUdcEnum.ITEM_STATUS_ENABLE.getUdcVal());
                }
                return insertDo;
            }).collect(Collectors.toList());
            this.itmItemRepo.saveAll(insertDos);
            for (int i = 0; i < insertDos.size(); ++i) {
                List<ItmItemUomConvSaveParam> convSaveParams;
                ItmItemSkuSaveParam insertSkuParam2 = (ItmItemSkuSaveParam)insertSkuParams.get(i);
                ItmItemDO item2 = (ItmItemDO)insertDos.get(i);
                skuImage = ItmItemAttachmentConvert.INSTANCE.skuSaveParamToSkuImageSaveParam(insertSkuParam2);
                skuImage.setItemId(item2.getId());
                skuImage.setFileType(ItmItemAttachmenTypeEnum.IMG.name());
                skuImageSaveParams.add(skuImage);
                PriMainPriceRowDO priceRowDO = new PriMainPriceRowDO();
                priceRowDO.setItemId(item2.getId());
                priceRowDO.setItemCode(item2.getItemCode());
                priceRowDO.setBuCode(param.getItemSource());
                priceRowDO.setPrice1(insertSkuParam2.getPrice1());
                priceRowDO.setPrice2(insertSkuParam2.getPrice2());
                priceRowDO.setPrice3(insertSkuParam2.getPrice3());
                priceRowDO.setPrice4(insertSkuParam2.getPrice4());
                priceRowDO.setPrice5(insertSkuParam2.getPrice5());
                priceRowDO.setPrice8(insertSkuParam2.getPrice8());
                priceRowDO.setUom(item2.getUom());
                priceRowDO.setValidFrom(LocalDateTime.of(nowDate, LocalTime.MIN));
                priceRowDO.setValidTo(LocalDateTime.of(nowDate.plusYears(30L), LocalTime.MIN));
                priceRowDO.setPriceType(PriMainPriceUdcEnum.PRI_PRICE_TYPE_ITEM_PRICE.getUdcVal());
                priceRowDO.setInstallFlag(false);
                priceRowDO.setPriceStatus(ComUdcEnum.COM_ACTIVE.getUdcVal());
                priceRowDO.setDeleteFlag(0);
                priceRowDO.setCreateTime(itmItemBaseInfo.getCreateTime());
                priceRowDO.setCreateUserId(itmItemBaseInfo.getCreateUserId());
                priceRowDO.setCreator(itmItemBaseInfo.getCreator());
                priceRowDO.setUpdater(itmItemBaseInfo.getUpdater());
                priceRowDO.setModifyTime(itmItemBaseInfo.getModifyTime());
                priceRowDO.setModifyUserId(itmItemBaseInfo.getModifyUserId());
                priceRowDO.setSecOuId(itmItemBaseInfo.getSecOuId());
                priceRowDos.add(priceRowDO);
                List<ItmItemTagSaveParam> tagSaveParams = insertSkuParam2.getItemSaveTags();
                if (!CollectionUtils.isEmpty(tagSaveParams)) {
                    tagSaveParams.forEach(t -> t.setItemId(item2.getId()));
                    itemTagSaveParams.addAll(tagSaveParams);
                }
                if (CollectionUtils.isEmpty(convSaveParams = insertSkuParam2.getItemUomConvSaveParams())) continue;
                convSaveParams.forEach(t -> t.setItemId(item2.getId()));
                uomConvSaveParams.addAll(convSaveParams);
            }
        }
        if (!CollectionUtils.isEmpty(deleteDos) && !isChange) {
            this.itmItemRepo.deleteInBatch(deleteDos);
        }
        List<Long> itemIds = itmItemDos.stream().map(BaseModel::getId).collect(Collectors.toList());
        this.itmItemAttachmentService.skuImgHardSave(itemIds, skuImageSaveParams);
        this.itmItemTagService.itemTagHardSave(itemIds, itemTagSaveParams);
        this.itmItemUomConvService.itemUomConvHardSave(itemIds, uomConvSaveParams);
        this.priMainPriceRowRepo.saveAll(priceRowDos);
        Long spuId = param.getSpuId();
        List<ItmItemAttachmentSaveParam> itmAttachmentSaveParams = this.mergeAttachSaveParams(param.getSpuImages(), param.getSpuVideos());
        this.itmItemAttachmentService.itemAttachmentsHardSave(spuId, itmAttachmentSaveParams);
        this.itmItemPropService.itemPropsHardSave(spuId, param.getItemPropSaveParams());
        this.itmItemQualifyService.itemQualifyHardSave(spuId, param.getItemQualifySaveParams());
        this.itmItemCustPropService.itemCustPropHardSave(spuId, param.getItemCustPropSaveParams());
    }

    private List<ItmItemAttachmentSaveParam> mergeAttachSaveParams(List<ItmItemAttachmentSaveParam> spuImages, List<ItmItemAttachmentSaveParam> spuVideos) {
        if (CollectionUtils.isNotEmpty(spuImages) && CollectionUtils.isNotEmpty(spuVideos)) {
            spuImages.forEach(t -> t.setFileType(ItmItemAttachmenTypeEnum.IMG.name()));
            spuVideos.forEach(t -> t.setFileType(ItmItemAttachmenTypeEnum.VIDEO.name()));
            spuImages.addAll(spuVideos);
            return spuImages;
        }
        if (CollectionUtils.isNotEmpty(spuImages)) {
            spuImages.forEach(t -> t.setFileType(ItmItemAttachmenTypeEnum.IMG.name()));
            return spuImages;
        }
        if (CollectionUtils.isNotEmpty(spuVideos)) {
            spuVideos.forEach(t -> t.setFileType(ItmItemAttachmenTypeEnum.VIDEO.name()));
            return spuVideos;
        }
        return Collections.emptyList();
    }

    @Override
    public void batchSpuPublish(ItmItemSpuPublishParam param) {
        if (CollectionUtils.isEmpty(param.getSpuIds())) {
            return;
        }
        List<Long> spuIds = param.getSpuIds().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(spuIds)) {
            return;
        }
        if (this.itmItemRepo.existsBySpuIdInAndItemStatusNot(spuIds, ItmUdcEnum.ITEM_STATUS_ENABLE.getUdcVal())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u6709\u542f\u7528\u72b6\u6001\u7684\u5546\u54c1\u624d\u80fd\u53d1\u5e03");
        }
        List<Long> longs = this.itmItemRepoProc.checkIsThreeItem(spuIds);
        if (CollectionUtils.isNotEmpty(longs)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7b2c\u4e09\u65b9\u5165\u9a7b\u5546\u54c1\u4e0d\u80fd\u53d1\u5e03\u81f3\u7ecf\u8425\u76ee\u5f55");
        }
        List<ItmItemBusinessSaveParam> itmItemBusinessSaveParams = this.itmItemRepoProc.findItemBusinessSaveParamBySpuIds(spuIds);
        this.itmItemBusinessService.itmItemBusinessSave(itmItemBusinessSaveParams, true);
    }

    @Override
    public List<ItmItemDTO> findAllItemDto(String itemType) {
        return this.itmItemRepoProc.findAllItemDto(itemType);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void softDeleteByParam(ItmItemBatchDeleteParam param) {
        if (CollectionUtils.isEmpty(param.getSpuIds())) {
            return;
        }
        List<Long> spuIds = param.getSpuIds();
        List<ItmItemDTO> dtos = this.itmItemRepoProc.findItemDtoBySpuIds(spuIds);
        dtos.forEach(dto -> {
            if (!ItmUdcEnum.ITEM_STATUS_DRAFT.getUdcVal().equals(dto.getItemStatus())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u8349\u7a3f\u72b6\u6001\u7684\u5546\u54c1");
            }
        });
        List<String> itemCodes = dtos.stream().map(ItmItemDTO::getItemCode).collect(Collectors.toList());
        this.itmItemRepoProc.softDeleteBySpuId(spuIds);
        this.priMainPriceService.priMainPriceDelete(itemCodes);
    }

    @Override
    public List<ItmItemChangUpdateVO> findItmItemChangInfo(List<String> itemCodes) {
        return this.itmItemRepoProc.findItmItemChangInfo(itemCodes);
    }

    @Override
    public List<ItmItemDTO> findItemDtoByItemCodes(List<String> itemCodes) {
        return this.itmItemRepoProc.findItemDtoByItemCode(itemCodes);
    }

    @Override
    public void batchPublishBusinessParam(ItmItemPubBusiParam param) {
        log.debug("\u6279\u91cf\u53d1\u5e03\u7ecf\u8425\u53c2\u6570---\u53c2\u6570\uff1a{}", (Object)param);
        List<String> spuCodes = param.getSpuCodes();
        if (CollectionUtils.isEmpty(spuCodes)) {
            throw new BusinessException("\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u5546\u54c1");
        }
        List<ItmItemPubBusiParamVO> pubItemAttributesBySpuCodes = this.itmItemRepoProc.getPubItemAttributesBySpuCodes(spuCodes);
        List errorList = pubItemAttributesBySpuCodes.stream().filter(item -> item.getReleaseFlag() == false).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(errorList)) {
            String errorStr = errorList.stream().map(ItmItemPubBusiParamVO::getSpuCode).collect(Collectors.joining("\u3001"));
            throw new BusinessException("\u5546\u54c1:" + errorStr + ",\u9700\u8981\u53d1\u5e03\u624d\u80fd\u53d1\u5e03\u6821\u9a8c\u53c2\u6570");
        }
        Map<String, ItmItemPubBusiParamVO> pubItemAttributesMap = pubItemAttributesBySpuCodes.stream().collect(Collectors.groupingBy(pub -> pub.getSpuCode() + "-" + pub.getItemSource())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, value -> (ItmItemPubBusiParamVO)((List)value.getValue()).get(0)));
        List<ItmItemSpuAndSourceVO> spuCodeAndItemSourceList = pubItemAttributesBySpuCodes.stream().map(pub -> {
            ItmItemSpuAndSourceVO vo = new ItmItemSpuAndSourceVO();
            vo.setSpuCode(pub.getSpuCode());
            vo.setItemSource(pub.getItemSource());
            return vo;
        }).collect(Collectors.toList());
        Map<String, List<ItmItemBusinessDO>> businessDOMap = this.itmItemBusinessRepoProc.getBusinessDoBySpuCodeAndItemSource(spuCodeAndItemSourceList).stream().collect(Collectors.groupingBy(pub -> pub.getSpuCode() + "-" + pub.getItemSource()));
        List<String> businessParams = param.getBusinessParams();
        Class<ItmItemBusinessDO> itmItemBusinessDOClass = ItmItemBusinessDO.class;
        Class<ItmItemPubBusiParamVO> itmItemPubBusiParamVOClass = ItmItemPubBusiParamVO.class;
        ArrayList<ItmItemBusinessDO> result = new ArrayList<ItmItemBusinessDO>();
        for (Map.Entry<String, List<ItmItemBusinessDO>> entry : businessDOMap.entrySet()) {
            String key = entry.getKey();
            List<ItmItemBusinessDO> values = entry.getValue();
            ItmItemPubBusiParamVO itmItemPubBusiParamVO = pubItemAttributesMap.get(key);
            for (ItmItemBusinessDO value2 : values) {
                for (String businessParam : businessParams) {
                    try {
                        PropertyDescriptor businessProperty = new PropertyDescriptor(businessParam, itmItemBusinessDOClass);
                        PropertyDescriptor itemProperty = new PropertyDescriptor(businessParam, itmItemPubBusiParamVOClass);
                        Method itemPropertyReadMethod = itemProperty.getReadMethod();
                        Method businessPropertyWriteMethod = businessProperty.getWriteMethod();
                        businessPropertyWriteMethod.invoke((Object)value2, itemPropertyReadMethod.invoke((Object)itmItemPubBusiParamVO, new Object[0]));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new BusinessException("\u66f4\u65b0\u7ecf\u8425\u76ee\u5f55\u5c5e\u6027\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
            }
            result.addAll(values);
        }
        this.itmItemBusinessRepo.saveAll(result);
    }

    public ItmItemServiceImpl(SysUdcProxyService sysUdcProxyService, ItmItemAttachmentService itmItemAttachmentService, ItmItemCateService itmItemCateService, ItmItemPropService itmItemPropService, ItmItemTagService itmItemTagService, ItmItemCustPropService itmItemCustPropService, ItmItemQualifyService itmItemQualifyService, PriMainPriceService priMainPriceService, ItmItemUomConvService itmItemUomConvService, ItmItemBusinessService itmItemBusinessService, OrgBuRepo orgBuRepo, PriMainPriceRowRepo priMainPriceRowRepo, OrgBuService orgBuService, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, ItmItemRepo itmItemRepo, ItmItemRepoProc itmItemRepoProc, ItmItemBusinessRepoProc itmItemBusinessRepoProc, ItmItemBusinessRepo itmItemBusinessRepo, UdcService sysUdcService, IdGeneratorProvider idGeneratorProvider) {
        this.sysUdcProxyService = sysUdcProxyService;
        this.itmItemAttachmentService = itmItemAttachmentService;
        this.itmItemCateService = itmItemCateService;
        this.itmItemPropService = itmItemPropService;
        this.itmItemTagService = itmItemTagService;
        this.itmItemCustPropService = itmItemCustPropService;
        this.itmItemQualifyService = itmItemQualifyService;
        this.priMainPriceService = priMainPriceService;
        this.itmItemUomConvService = itmItemUomConvService;
        this.itmItemBusinessService = itmItemBusinessService;
        this.orgBuRepo = orgBuRepo;
        this.priMainPriceRowRepo = priMainPriceRowRepo;
        this.orgBuService = orgBuService;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.itmItemRepo = itmItemRepo;
        this.itmItemRepoProc = itmItemRepoProc;
        this.itmItemBusinessRepoProc = itmItemBusinessRepoProc;
        this.itmItemBusinessRepo = itmItemBusinessRepo;
        this.sysUdcService = sysUdcService;
        this.idGeneratorProvider = idGeneratorProvider;
    }
}

