/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.convert.ItmItemStatusConfigConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmItemStatusConfigDO;
import com.elitesland.yst.supportdomain.item.param.ItmItemStatusConfigDetailVO;
import com.elitesland.yst.supportdomain.item.param.ItmItemStatusConfigPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemStatusConfigSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemStatusConfigRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemStatusConfigRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemStatusConfigService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemStatusConfigPagingVO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemStatusConfigServiceImpl
implements ItmItemStatusConfigService {
    private final ItmItemStatusConfigRepo itmItemStatusConfigRepo;
    private final ItmItemStatusConfigRepoProc itmItemStatusConfigRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ItmItemStatusConfigPagingVO> searchPagingList(ItmItemStatusConfigPagingParam param) {
        return this.itmItemStatusConfigRepoProc.searchPagingList(param);
    }

    @Override
    public void saveStatusConfig(List<ItmItemStatusConfigSaveParam> params) {
        Map<String, Long> paramCountMap = params.stream().collect(Collectors.groupingBy(ItmItemStatusConfigSaveParam::getBusinessCode, Collectors.counting()));
        String repeatString = paramCountMap.entrySet().stream().filter(map -> (Long)map.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.joining("\u3001"));
        if (StringUtils.isNotBlank((CharSequence)repeatString)) {
            throw new BusinessException("\u4e1a\u52a1\u7f16\u7801\uff1a" + repeatString + "; \u91cd\u590d");
        }
        params.forEach(param -> {
            param.setConfigStatus(true);
            if (this.itmItemStatusConfigRepo.existsByBusinessCode(param.getBusinessCode()).booleanValue()) {
                throw new BusinessException("\u4e1a\u52a1\uff1a" + param.getBusinessName() + ",\u5df2\u7ecf\u914d\u7f6e\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            }
        });
        List<ItmItemStatusConfigDO> itmItemStatusConfigDO = ItmItemStatusConfigConvert.INSTANCE.paramToDO(params);
        this.itmItemStatusConfigRepo.saveAll(itmItemStatusConfigDO);
    }

    @Override
    public void updateStatusConfig(List<ItmItemStatusConfigSaveParam> param) {
        List<ItmItemStatusConfigDO> itmItemStatusConfigDO = ItmItemStatusConfigConvert.INSTANCE.paramToDO(param);
        this.itmItemStatusConfigRepo.saveAll(itmItemStatusConfigDO);
    }

    @Override
    @SysCodeProc
    public List<ItmItemStatusConfigDetailVO> getDetailsByIds(List<Long> ids) {
        return this.itmItemStatusConfigRepoProc.getDetailsByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteById(Long id) {
        this.itmItemStatusConfigRepoProc.softDeleteById(id);
    }

    public ItmItemStatusConfigServiceImpl(ItmItemStatusConfigRepo itmItemStatusConfigRepo, ItmItemStatusConfigRepoProc itmItemStatusConfigRepoProc) {
        this.itmItemStatusConfigRepo = itmItemStatusConfigRepo;
        this.itmItemStatusConfigRepoProc = itmItemStatusConfigRepoProc;
    }
}

