/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.supportdomain.item.convert.ItmItemTagConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmItemTagDO;
import com.elitesland.yst.supportdomain.item.param.ItmItemTagSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemTagRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemTagRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemTagService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemTagVO;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemTagServiceImpl
implements ItmItemTagService {
    private final ItmItemTagRepo itmItemTagRepo;
    private final ItmItemTagRepoProc itmItemTagRepoProc;

    @Override
    public List<ItmItemTagVO> findVoByItemIds(List<Long> itemIds) {
        return this.itmItemTagRepoProc.searchVoByItemIds(itemIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itemTagHardSave(List<Long> itemIds, List<ItmItemTagSaveParam> params) {
        if (!CollectionUtils.isEmpty(itemIds)) {
            this.itmItemTagRepo.deleteByItemIdIn(itemIds);
        }
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<ItmItemTagDO> itmItemTagDos = ItmItemTagConvert.INSTANCE.saveParamToDo(params);
        this.itmItemTagRepo.saveAll(itmItemTagDos);
    }

    public ItmItemTagServiceImpl(ItmItemTagRepo itmItemTagRepo, ItmItemTagRepoProc itmItemTagRepoProc) {
        this.itmItemTagRepo = itmItemTagRepo;
        this.itmItemTagRepoProc = itmItemTagRepoProc;
    }
}

