/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.convert.ItmItemUomConvConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmItemUomConvDO;
import com.elitesland.yst.supportdomain.item.param.ItmItemUomConvSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemUomConvRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemUomConvRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemUomConvService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemUomConvVO;
import com.elitesland.yst.supportdomain.item.vo.TmItmItemUomConvVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemUomConvServiceImpl
implements ItmItemUomConvService {
    private final ItmItemUomConvRepo itmItemUomConvRepo;
    private final ItmItemUomConvRepoProc itmItemUomConvRepoProc;

    @Override
    @SysCodeProc
    public List<ItmItemUomConvVO> getItmItemUomConvByItemIds(List<Long> itemId) {
        return this.itmItemUomConvRepoProc.getItmItemUomConvByItemId(itemId);
    }

    @Override
    @SysCodeProc
    public List<TmItmItemUomConvVO> getItmItemUomConvByItemIdsanduom(List<Long> itemId, List<String> uom) {
        return this.itmItemUomConvRepoProc.getItmItemUomConvByItemIdAnduom(itemId, uom);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itemUomConvHardSave(List<Long> itemIds, List<ItmItemUomConvSaveParam> params) {
        if (!CollectionUtils.isEmpty(itemIds)) {
            this.itmItemUomConvRepoProc.deleteByItemIds(itemIds);
        }
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<ItmItemUomConvDO> itmItemUomConvDOS = ItmItemUomConvConvert.INSTANCE.saveParamToDo(params);
        for (ItmItemUomConvDO itmItemUomConvDO : itmItemUomConvDOS) {
            String toUom;
            BigDecimal conversionCoefficient = itmItemUomConvDO.getRatio();
            String fromUom = itmItemUomConvDO.getFromUom();
            if (fromUom.equals(toUom = itmItemUomConvDO.getToUom())) {
                if (conversionCoefficient != null) {
                    itmItemUomConvDO.setRevertRatio(this.judgmentConversionCoefficient(conversionCoefficient));
                }
            } else {
                if (conversionCoefficient == null) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8f6c\u6362\u7cfb\u6570\u5fc5\u586b");
                }
                itmItemUomConvDO.setRevertRatio(this.judgmentConversionCoefficient(conversionCoefficient));
            }
            this.itmItemUomConvRepo.saveAll(itmItemUomConvDOS);
        }
    }

    private BigDecimal judgmentConversionCoefficient(BigDecimal conversionCoefficient) {
        if (conversionCoefficient.compareTo(BigDecimal.ZERO) < 0 || BigDecimal.ZERO.compareTo(conversionCoefficient) == 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8f6c\u6362\u7cfb\u6570\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        return BigDecimal.ONE.divide(conversionCoefficient, 4, RoundingMode.HALF_UP);
    }

    public ItmItemUomConvServiceImpl(ItmItemUomConvRepo itmItemUomConvRepo, ItmItemUomConvRepoProc itmItemUomConvRepoProc) {
        this.itmItemUomConvRepo = itmItemUomConvRepo;
        this.itmItemUomConvRepoProc = itmItemUomConvRepoProc;
    }
}

