/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.convert.ItmPropConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmPropDO;
import com.elitesland.yst.supportdomain.item.param.ItmPropSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmPropRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmPropRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmPropService;
import com.elitesland.yst.supportdomain.item.vo.ItmPropVO;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmPropServiceImpl
implements ItmPropService {
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final ItmPropRepo itmPropRepo;
    private final ItmPropRepoProc itmPropRepoProc;

    @Override
    public List<ItmPropVO> findPropList(String codeName) {
        return this.itmPropRepoProc.findPropList(codeName);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveProp(ItmPropSaveParam param) {
        if (StringUtils.isBlank((CharSequence)param.getCatePropName())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5c5e\u6027\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.itmPropRepo.existsByCatePropName(param.getCatePropName())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5c5e\u6027\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u76f4\u63a5\u9009\u62e9");
        }
        param.setId(null);
        String catePropCode = this.sysNumberGeneratorWrapper.generate("PROP_NO");
        if (this.itmPropRepo.existsByCatePropCode(catePropCode)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7684\u54c1\u7c7b\u5c5e\u6027\u7f16\u53f7\uff1a" + catePropCode + " \u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u914d\u7f6e\u662f\u5426\u6b63\u786e");
        }
        param.setCatePropCode(catePropCode);
        ItmPropDO itmPropDO = ItmPropConvert.INSTANCE.saveParamToDo(param);
        this.itmPropRepo.save((Object)itmPropDO);
        return catePropCode;
    }

    public ItmPropServiceImpl(SysNumberGeneratorWrapper sysNumberGeneratorWrapper, ItmPropRepo itmPropRepo, ItmPropRepoProc itmPropRepoProc) {
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.itmPropRepo = itmPropRepo;
        this.itmPropRepoProc = itmPropRepoProc;
    }
}

