/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.common.TableColumnExtEnum;
import com.elitesland.yst.supportdomain.common.service.TableColumnExtService;
import com.elitesland.yst.supportdomain.item.convert.ItmTagConvert;
import com.elitesland.yst.supportdomain.item.dto.ItmTagDTO;
import com.elitesland.yst.supportdomain.item.entity.ItmTagDO;
import com.elitesland.yst.supportdomain.item.param.ItmTagPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmTagSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmComboTagRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemTagRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmTagRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmTagRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmTagService;
import com.elitesland.yst.supportdomain.item.vo.ItmTagPagingVO;
import com.elitesland.yst.supportdomain.item.vo.ItmTagTreeVO;
import com.elitesland.yst.supportdomain.item.vo.ItmTagVO;
import com.elitesland.yst.supportdomain.util.TreeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmTagServiceImpl
implements ItmTagService {
    private final TableColumnExtService tableColumnExtService;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final ItmTagRepo itmTagRepo;
    private final ItmTagRepoProc itmTagRepoProc;
    private final ItmItemTagRepoProc itmItemTagRepoProc;
    private final ItmComboTagRepoProc itmComboTagRepoProc;
    private static final String TAG_GROUP = "GROUP";
    private static final String TAG_TAG = "TAG";

    @Override
    @SysCodeProc
    public PagingVO<ItmTagPagingVO> searchPaging(ItmTagPagingParam param) {
        return this.itmTagRepoProc.searchPagingByParam(param);
    }

    @Override
    @Cacheable(cacheNames={"TAG"}, key="'TREE'")
    public List<ItmTagTreeVO> tagTree() {
        List<ItmTagTreeVO> treeNodes = this.itmTagRepoProc.findAllTagTreeVO();
        return TreeUtils.buildTree(null, true, treeNodes);
    }

    @Override
    public List<ItmTagTreeVO> querySubTagByPid(Long pid) {
        List<ItmTagTreeVO> result = this.itmTagRepoProc.querySubTagByPid(pid);
        result.forEach(r -> r.setIsLeaf(!this.itmTagRepo.existsByPid(r.getId())));
        return result;
    }

    @Override
    public ItmTagVO queryTagDetailsVoById(Long id) {
        return this.itmTagRepoProc.queryTagDetailsById(id);
    }

    @Override
    @CacheEvict(cacheNames={"TAG"}, key="'TREE'")
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateTag(ItmTagSaveParam param) {
        ItmTagDO itmTagDO = null;
        if (param.getId() == null) {
            if (StringUtils.isBlank((CharSequence)param.getTagName())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (this.itmTagRepo.existsByTagName(param.getTagName())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6807\u7b7e\u540d\u79f0\u5df2\u5b58\u5728");
            }
            itmTagDO = ItmTagConvert.INSTANCE.saveParamToDo(param);
            String tagCode = this.sysNumberGeneratorWrapper.generate("TAG_NO");
            if (this.itmTagRepo.existsByTagCode(tagCode)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7684\u6807\u7b7e\u7f16\u53f7\uff1a" + tagCode + " \u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            }
            itmTagDO.setTagCode(tagCode);
        } else {
            if (!StringUtils.isBlank((CharSequence)param.getTagName()) && this.itmTagRepo.existsByTagNameAndIdNot(param.getTagName(), param.getId())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6807\u7b7e\u540d\u79f0\u5df2\u5b58\u5728");
            }
            Optional itmTagDoOptional = this.itmTagRepo.findById(param.getId());
            if (itmTagDoOptional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6807\u7b7e" + param.getTagCode() + "\u4e0d\u5b58\u5728");
            }
            itmTagDO = (ItmTagDO)itmTagDoOptional.get();
            ItmTagConvert.INSTANCE.updateDoFromSaveParam(param, itmTagDO);
        }
        ItmTagDO resultDO = (ItmTagDO)this.itmTagRepo.save(itmTagDO);
        return resultDO.getId();
    }

    @Override
    @CacheEvict(cacheNames={"TAG"}, key="'TREE'")
    @Transactional(rollbackFor={Exception.class})
    public void switchTagStatusByIds(List<Long> ids, String status) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u9009\u62e9\u4efb\u4f55\u6807\u7b7e");
        }
        ArrayList<Long> fullIds = new ArrayList<Long>();
        this.findFullIds(ids, fullIds);
        this.itmTagRepoProc.updateTagStatusByIds(fullIds, status);
    }

    @Override
    @CacheEvict(cacheNames={"TAG"}, key="'TREE'")
    @Transactional(rollbackFor={Exception.class})
    public void softDeleteTagById(Long id) {
        Optional tagDoOptional = this.itmTagRepo.findById(id);
        if (tagDoOptional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6807\u7b7e\u4e0d\u5b58\u5728");
        }
        ItmTagDO itmTag = (ItmTagDO)tagDoOptional.get();
        if (TAG_GROUP.equals(itmTag.getTagType())) {
            if (this.itmTagRepo.existsByPid(itmTag.getId())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6807\u7b7e\u7ec4\u4e0d\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        } else if (TAG_TAG.equals(itmTag.getTagType())) {
            if (this.tableColumnExtService.existExtColumnByValue(TableColumnExtEnum.ITEM_CATE_TAG_CODE.getTableName(), TableColumnExtEnum.ITEM_CATE_TAG_CODE.getColumnName(), itmTag.getTagCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6807\u7b7e\u5df2\u88ab\u54c1\u7c7b\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            if (this.itmComboTagRepoProc.existsByTagCodeAndComBoNotDelete(itmTag.getTagCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6807\u7b7e\u5df2\u88ab\u7ec4\u5408\u5546\u54c1\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e0d\u652f\u6301\u7684\u6807\u7b7e\u7c7b\u578b\uff1a" + itmTag.getTagType());
        }
        this.itmTagRepoProc.softDeleteTagById(id);
    }

    @Override
    public List<ItmTagDTO> findTagDtoByTagCodes(List<String> tagCodes) {
        if (CollectionUtils.isEmpty(tagCodes)) {
            return null;
        }
        if (CollectionUtils.isEmpty(tagCodes = tagCodes.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            return null;
        }
        return this.itmTagRepoProc.findDtoByTagCodes(tagCodes);
    }

    @Override
    public List<ItmTagDTO> findAllTagDto() {
        return this.itmTagRepoProc.findAllDto();
    }

    private void findFullIds(List<Long> ids, List<Long> fullIds) {
        if (!CollectionUtils.isEmpty(ids)) {
            fullIds.addAll(ids);
            this.findFullIds(this.itmTagRepoProc.findIdsByPids(ids), fullIds);
        }
    }

    public ItmTagServiceImpl(TableColumnExtService tableColumnExtService, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, ItmTagRepo itmTagRepo, ItmTagRepoProc itmTagRepoProc, ItmItemTagRepoProc itmItemTagRepoProc, ItmComboTagRepoProc itmComboTagRepoProc) {
        this.tableColumnExtService = tableColumnExtService;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.itmTagRepo = itmTagRepo;
        this.itmTagRepoProc = itmTagRepoProc;
        this.itmItemTagRepoProc = itmItemTagRepoProc;
        this.itmComboTagRepoProc = itmComboTagRepoProc;
    }
}

