/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.task.repo;

import com.elitesland.yst.supportdomain.item.entity.ItmItemBusinessStatusDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemBusinessStatusDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemLifeStatusDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.task.param.ItmItemLifeStatusUpdateParam;
import com.elitesland.yst.supportdomain.item.task.vo.ItmItemBusinessDeleteParam;
import com.elitesland.yst.supportdomain.item.task.vo.ItmItemLifeStatusJobVO;
import com.elitesland.yst.supportdomain.org.entity.QOrgOuDO;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmItemLifeStatusJobRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemLifeStatusDO itemLifeStatus = QItmItemLifeStatusDO.itmItemLifeStatusDO;
    private final QOrgOuDO orgOu = QOrgOuDO.orgOuDO;
    private final QItmItemBusinessStatusDO itemBusinessStatus = QItmItemBusinessStatusDO.itmItemBusinessStatusDO;
    private final QItmItemDO itmItem = QItmItemDO.itmItemDO;

    private JPAQuery<ItmItemLifeStatusJobVO> getQuery() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemLifeStatusJobVO.class, (Expression[])new Expression[]{this.itemLifeStatus.id, this.itemLifeStatus.itemSource, this.itemLifeStatus.buCode, this.itemLifeStatus.branchPlant, this.itemLifeStatus.itemCode, this.itemLifeStatus.itemLifeStatus, this.itemLifeStatus.globalOrNot})).from((EntityPath)this.itemLifeStatus);
    }

    public List<ItmItemLifeStatusJobVO> getUpdateEffectLifeStatusList() {
        return ((JPAQuery)this.getQuery().where((Predicate)this.itemLifeStatus.validFrom.loe((Comparable)LocalDateTime.now()).and((Predicate)this.itemLifeStatus.validTo.goe((Comparable)LocalDateTime.now())))).fetch();
    }

    public List<ItmItemLifeStatusJobVO> getUpdateFailureLifeStatusList() {
        String nowMax = LocalDate.now() + " 23:59:59";
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        LocalDateTime preMaxDate = LocalDateTime.parse(nowMax, df).minusDays(7L);
        predicates.add(this.itemLifeStatus.validTo.goe((Comparable)preMaxDate));
        predicates.add(this.itemLifeStatus.validTo.loe((Comparable)LocalDateTime.now()));
        return ((JPAQuery)this.getQuery().where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public List<String> findAllGroupOuCode() {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.orgOu.ouCode).from((EntityPath)this.orgOu)).where((Predicate)this.orgOu.ouType.eq((Object)OrgUdcEnum.ORG_OU_TYPE_10.getUdcVal()))).fetch();
    }

    public List<ItmItemBusinessStatusDO> findBusinessLifeStatus(ItmItemLifeStatusUpdateParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getItemSource())) {
            predicates.add(this.itemBusinessStatus.itemSource.eq((Object)param.getItemSource()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBranchPlant())) {
            predicates.add(this.itemBusinessStatus.buCode.eq((Object)param.getBranchPlant()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemCode())) {
            predicates.add(this.itemBusinessStatus.itemCode.eq((Object)param.getItemCode()));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.itemBusinessStatus).from((EntityPath)this.itemBusinessStatus)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public List<ItmItemDO> findItemListLifeStatus(ItmItemLifeStatusUpdateParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getItemSource())) {
            predicates.add(this.itmItem.itemSource.eq((Object)param.getItemSource()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemCode())) {
            predicates.add(this.itmItem.itemCode.eq((Object)param.getItemCode()));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.itmItem).from((EntityPath)this.itmItem)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public void updateFailureItemList(List<String> itemCodes) {
        this.jpaQueryFactory.update((EntityPath)this.itmItem).setNull((Path)this.itmItem.itemStatus2).where(new Predicate[]{this.itmItem.itemCode.in(itemCodes)}).execute();
    }

    public void updateFailureBusiness(ItmItemBusinessDeleteParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty(param.getItemCodes())) {
            predicates.add(this.itemBusinessStatus.itemCode.in(param.getItemCodes()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemCode())) {
            predicates.add(this.itemBusinessStatus.itemCode.eq((Object)param.getItemCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBuCode())) {
            predicates.add(this.itemBusinessStatus.buCode.eq((Object)param.getBuCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemSource())) {
            predicates.add(this.itemBusinessStatus.itemSource.eq((Object)param.getItemSource()));
        }
        this.jpaQueryFactory.update((EntityPath)this.itemBusinessStatus).setNull((Path)this.itemBusinessStatus.itemLifeStatus).where(new Predicate[]{ExpressionUtils.allOf(predicates)}).execute();
    }

    public void updateGlobalBusiness(String itemCode, String itemLifeStatus) {
        this.jpaQueryFactory.update((EntityPath)this.itemBusinessStatus).set((Path)this.itemBusinessStatus.itemLifeStatus, (Object)itemLifeStatus).where(new Predicate[]{this.itemBusinessStatus.itemCode.eq((Object)itemCode)}).execute();
    }

    public void updateGlobalItemList(String itemCode, String itemLifeStatus) {
        this.jpaQueryFactory.update((EntityPath)this.itmItem).set((Path)this.itmItem.itemStatus2, (Object)itemLifeStatus).where(new Predicate[]{this.itmItem.itemCode.eq((Object)itemCode)}).execute();
    }

    public void updateBusinessLifeStatus() {
        this.jpaQueryFactory.update((EntityPath)this.itemBusinessStatus).set((Path)this.itemBusinessStatus.itemLifeStatus, (Object)ItmUdcEnum.ITM_ITEM_LIFE_STATUS_ENABLE.getUdcVal()).where(new Predicate[]{this.itemBusinessStatus.itemLifeStatus.isNull()}).execute();
    }

    public void updateItemListLifeStatus() {
        this.jpaQueryFactory.update((EntityPath)this.itmItem).set((Path)this.itmItem.itemStatus2, (Object)ItmUdcEnum.ITM_ITEM_LIFE_STATUS_ENABLE.getUdcVal()).where(new Predicate[]{this.itmItem.itemStatus2.isNull()}).execute();
    }

    public ItmItemLifeStatusJobRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

