/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.task.service.impl;

import com.elitesland.sale.dto.param.ItemFreezeParam;
import com.elitesland.sale.service.BipItemRpcService;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.entity.ItmItemStatusConfigDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.repo.ItmItemBusinessStatusRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemStatusConfigRepo;
import com.elitesland.yst.supportdomain.item.task.convert.ItmItemLifeStatusConvert;
import com.elitesland.yst.supportdomain.item.task.service.ItmItemBLifeStatusService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemBusinessStatusVO;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItmItemBLifeStatusServiceImpl
implements ItmItemBLifeStatusService {
    private static final Logger log = LoggerFactory.getLogger(ItmItemBLifeStatusServiceImpl.class);
    private static final String S002 = "S002";
    @DubboReference
    private BipItemRpcService bipItemRpcService;
    private final ItmItemBusinessStatusRepoProc itmItemBusinessStatusRepoProc;
    private final ItmItemStatusConfigRepo itmItemStatusConfigRepo;

    @Override
    public void asyncLifeStatusToB() {
        log.info("\u5546\u54c1\u51bb\u7ed3\u72b6\u6001\u540c\u6b65\u81f3b\u7aef\u5f00\u59cb\u3002\u3002\u3002\u3002");
        List<ItmItemBusinessStatusVO> saleList = this.itmItemBusinessStatusRepoProc.getBusinessStatusToBByStatus(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_SALE_FREEZE.getUdcVal());
        log.info("\u5546\u54c1\u51bb\u7ed3\u72b6\u6001\u540c\u6b65\u81f3b\u7aef-\u91c7\u8d2d\u51bb\u7ed3\u7684\u6570\u636e" + saleList.stream().map(sale -> sale.getItemCode() + "-" + sale.getBuCode()).collect(Collectors.joining(",")));
        List<ItmItemBusinessStatusVO> enableList = this.itmItemBusinessStatusRepoProc.getBusinessStatusToBNormal(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_SALE_FREEZE.getUdcVal());
        log.info("\u5546\u54c1\u51bb\u7ed3\u72b6\u6001\u540c\u6b65\u81f3b\u7aef-\u6b63\u5e38\u6570\u636e" + enableList.stream().map(enable -> enable.getItemCode() + "-" + enable.getBuCode()).collect(Collectors.joining(",")));
        List<ItemFreezeParam> saleFreezes = ItmItemLifeStatusConvert.INSTANCE.voToFreezeParam(saleList);
        saleFreezes.forEach(sale -> sale.setFreeze(Boolean.valueOf(true)));
        List<ItemFreezeParam> enables = ItmItemLifeStatusConvert.INSTANCE.voToFreezeParam(enableList);
        enables.forEach(enable -> enable.setFreeze(Boolean.valueOf(false)));
        try {
            Optional<ItmItemStatusConfigDO> byBusinessCode = this.itmItemStatusConfigRepo.findByBusinessCode(S002);
            if (byBusinessCode.isPresent()) {
                ItmItemStatusConfigDO itmItemStatusConfigDO = byBusinessCode.get();
                log.info("\u5546\u54c1\u662f\u5426\u53ef\u552e\u540c\u6b65\u81f3b\u7aef-\u5546\u54c1\u72b6\u6001\u914d\u7f6e\u4fe1\u606f\uff1a" + itmItemStatusConfigDO);
                if (itmItemStatusConfigDO.getConfigStatus().booleanValue()) {
                    if (!itmItemStatusConfigDO.getBusinExcuSignStatus2().booleanValue()) {
                        this.bipItemRpcService.updateItemFreeze(saleFreezes);
                    }
                    if (itmItemStatusConfigDO.getBusinExcuSignStatus1().booleanValue()) {
                        this.bipItemRpcService.updateItemFreeze(enables);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u51bb\u7ed3\u72b6\u6001\u540c\u6b65\u81f3b\u7aef\u9519\u8bef:" + e.getMessage());
            throw new BusinessException("\u5546\u54c1\u51bb\u7ed3\u72b6\u6001\u540c\u6b65\u81f3b\u7aef\u9519\u8bef:" + e.getMessage());
        }
        log.info("\u5546\u54c1\u51bb\u7ed3\u72b6\u6001\u540c\u6b65\u81f3b\u7aef\u6210\u529f\u3002\u3002\u3002");
    }

    public ItmItemBLifeStatusServiceImpl(ItmItemBusinessStatusRepoProc itmItemBusinessStatusRepoProc, ItmItemStatusConfigRepo itmItemStatusConfigRepo) {
        this.itmItemBusinessStatusRepoProc = itmItemBusinessStatusRepoProc;
        this.itmItemStatusConfigRepo = itmItemStatusConfigRepo;
    }
}

