/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.task.service.impl;

import com.elitesland.yst.supportdomain.item.entity.ItmItemBusinessStatusDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.repo.ItmItemBusinessStatusRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepo;
import com.elitesland.yst.supportdomain.item.task.param.ItmItemLifeStatusUpdateParam;
import com.elitesland.yst.supportdomain.item.task.repo.ItmItemLifeStatusJobRepoProc;
import com.elitesland.yst.supportdomain.item.task.service.ItmItemAsyncService;
import com.elitesland.yst.supportdomain.item.task.service.ItmItemLifeStatusJobService;
import com.elitesland.yst.supportdomain.item.task.vo.ItmItemBusinessDeleteParam;
import com.elitesland.yst.supportdomain.item.task.vo.ItmItemLifeStatusJobVO;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemLifeStatusJobServiceImpl
implements ItmItemLifeStatusJobService {
    private static final Logger log = LoggerFactory.getLogger(ItmItemLifeStatusJobServiceImpl.class);
    private final ItmItemLifeStatusJobRepoProc itmItemLifeStatusJobRepoProc;
    private final ItmItemBusinessStatusRepo itmItemBusinessStatusRepo;
    private final ItmItemRepo itmItemRepo;
    private final ItmItemAsyncService itmItemAsyncService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itemLifeStatusTimeTasked() {
        log.info("\u66f4\u65b0\u5546\u54c1\u51bb\u7ed3\u72b6\u6001\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u3002\u3002\u3002\u3002");
        List<String> allGroupOuCode = this.itmItemLifeStatusJobRepoProc.findAllGroupOuCode();
        this.updateFailureLifeStatus();
        List<ItmItemLifeStatusJobVO> updateLifeStatusList = this.itmItemLifeStatusJobRepoProc.getUpdateEffectLifeStatusList();
        updateLifeStatusList.forEach(update -> {
            if (StringUtils.isBlank((CharSequence)update.getBuCode())) {
                this.itmItemLifeStatusJobRepoProc.updateFailureItemList(List.of(update.getItemCode()));
                ItmItemBusinessDeleteParam updateParam = ItmItemBusinessDeleteParam.builder().buCode(update.getItemSource()).itemCode(update.getItemCode()).itemSource(update.getItemSource()).build();
                this.itmItemLifeStatusJobRepoProc.updateFailureBusiness(updateParam);
            } else {
                if (update.getItemSource().equals(update.getBuCode())) {
                    this.itmItemLifeStatusJobRepoProc.updateFailureItemList(List.of(update.getItemCode()));
                }
                ItmItemBusinessDeleteParam updateParam = ItmItemBusinessDeleteParam.builder().buCode(update.getBuCode()).itemCode(update.getItemCode()).itemSource(update.getItemSource()).build();
                this.itmItemLifeStatusJobRepoProc.updateFailureBusiness(updateParam);
            }
        });
        List<ItmItemLifeStatusJobVO> purcFreezeList = updateLifeStatusList.stream().filter(lifeStatus -> ItmUdcEnum.ITM_ITEM_LIFE_STATUS_PURC_FREEZE.getUdcVal().equals(lifeStatus.getItemLifeStatus())).collect(Collectors.toList());
        log.info("\u66f4\u65b0\u5546\u54c1\u51bb\u7ed3\u72b6\u6001\u5b9a\u65f6\u4efb\u52a1-\u91c7\u8d2d\u51bb\u7ed3\u6570\u636e\u3002\u3002\u3002" + purcFreezeList);
        List<ItmItemLifeStatusJobVO> saleFreezeList = updateLifeStatusList.stream().filter(lifeStatus -> ItmUdcEnum.ITM_ITEM_LIFE_STATUS_SALE_FREEZE.getUdcVal().equals(lifeStatus.getItemLifeStatus())).collect(Collectors.toList());
        log.info("\u66f4\u65b0\u5546\u54c1\u51bb\u7ed3\u72b6\u6001\u5b9a\u65f6\u4efb\u52a1-\u9500\u552e\u51bb\u7ed3\u6570\u636e\u3002\u3002\u3002" + saleFreezeList);
        this.saleFreezeUpdate(saleFreezeList, allGroupOuCode);
        this.purcFreezeUpdate(purcFreezeList);
        this.itmItemLifeStatusJobRepoProc.updateBusinessLifeStatus();
        this.itmItemLifeStatusJobRepoProc.updateItemListLifeStatus();
        log.info("\u66f4\u65b0\u5546\u54c1\u51bb\u7ed3\u72b6\u6001\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\u3002\u3002\u3002\u3002");
        this.itmItemAsyncService.timeTaskAsyncLifeStatusToB();
    }

    public void saleFreezeUpdate(List<ItmItemLifeStatusJobVO> saleFreezeList, List<String> allGroupOuCode) {
        if (CollectionUtils.isNotEmpty(saleFreezeList)) {
            List<ItmItemLifeStatusJobVO> nonGlobalList;
            List<ItmItemLifeStatusJobVO> globalList = saleFreezeList.stream().filter(ItmItemLifeStatusJobVO::getGlobalOrNot).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(globalList)) {
                globalList.forEach(global -> {
                    List<ItmItemDO> itemByItemCode = this.itmItemRepo.findByItemCode(global.getItemCode());
                    this.updateItemListLifeStatus(itemByItemCode, global.getItemLifeStatus());
                    List<ItmItemBusinessStatusDO> businessByItemCode = this.itmItemBusinessStatusRepo.findByItemCode(global.getItemCode());
                    this.updateBusinessLifeStatus(businessByItemCode, global.getItemLifeStatus());
                });
            }
            if (CollectionUtils.isNotEmpty(nonGlobalList = saleFreezeList.stream().filter(sale -> sale.getGlobalOrNot() == false).collect(Collectors.toList()))) {
                nonGlobalList.forEach(nonGlobal -> {
                    ItmItemLifeStatusUpdateParam updateParam;
                    String itemSource = nonGlobal.getItemSource();
                    String branchPlant = nonGlobal.getBranchPlant();
                    if (allGroupOuCode.contains(itemSource)) {
                        updateParam = ItmItemLifeStatusUpdateParam.builder().itemCode(nonGlobal.getItemCode()).itemSource(nonGlobal.getItemSource()).itemLifeStatus(nonGlobal.getItemLifeStatus()).branchPlant(nonGlobal.getBranchPlant()).build();
                    } else {
                        updateParam = ItmItemLifeStatusUpdateParam.builder().itemCode(nonGlobal.getItemCode()).itemSource(nonGlobal.getItemSource()).itemLifeStatus(nonGlobal.getItemLifeStatus()).itemStatus2(nonGlobal.getItemLifeStatus()).build();
                        if (itemSource.equals(branchPlant)) {
                            this.updateItemListLifeStatus(this.itmItemLifeStatusJobRepoProc.findItemListLifeStatus(updateParam), nonGlobal.getItemLifeStatus());
                        }
                        updateParam.setBranchPlant(nonGlobal.getBranchPlant());
                    }
                    this.updateBusinessLifeStatus(this.itmItemLifeStatusJobRepoProc.findBusinessLifeStatus(updateParam), nonGlobal.getItemLifeStatus());
                });
            }
        }
    }

    private void purcFreezeUpdate(List<ItmItemLifeStatusJobVO> purcFreezeList) {
        if (CollectionUtils.isNotEmpty(purcFreezeList)) {
            List<ItmItemLifeStatusJobVO> globalList = purcFreezeList.stream().filter(ItmItemLifeStatusJobVO::getGlobalOrNot).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(globalList)) {
                globalList.forEach(global -> {
                    List<ItmItemDO> itemByItemCode = this.itmItemRepo.findByItemCode(global.getItemCode());
                    this.updateItemListLifeStatus(itemByItemCode, global.getItemLifeStatus());
                    List<ItmItemBusinessStatusDO> businessByItemCode = this.itmItemBusinessStatusRepo.findByItemCode(global.getItemCode());
                    this.updateBusinessLifeStatus(businessByItemCode, global.getItemLifeStatus());
                });
            }
            List<ItmItemLifeStatusJobVO> nonGlobalList = purcFreezeList.stream().filter(status -> status.getGlobalOrNot() == false).collect(Collectors.toList());
            nonGlobalList.forEach(purcFreeze -> {
                String itemSource = purcFreeze.getItemSource();
                String branchPlant = purcFreeze.getBranchPlant();
                ItmItemLifeStatusUpdateParam updateParam = ItmItemLifeStatusUpdateParam.builder().itemCode(purcFreeze.getItemCode()).itemSource(purcFreeze.getItemSource()).itemLifeStatus(purcFreeze.getItemLifeStatus()).build();
                if (itemSource.equals(branchPlant)) {
                    this.updateItemListLifeStatus(this.itmItemLifeStatusJobRepoProc.findItemListLifeStatus(updateParam), purcFreeze.getItemLifeStatus());
                }
                updateParam.setBranchPlant(purcFreeze.getBranchPlant());
                this.updateBusinessLifeStatus(this.itmItemLifeStatusJobRepoProc.findBusinessLifeStatus(updateParam), purcFreeze.getItemLifeStatus());
            });
        }
    }

    private void updateFailureLifeStatus() {
        List<ItmItemLifeStatusJobVO> updateFailureLifeStatusList = this.itmItemLifeStatusJobRepoProc.getUpdateFailureLifeStatusList();
        List<String> itemCodeList = updateFailureLifeStatusList.stream().map(ItmItemLifeStatusJobVO::getItemCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(itemCodeList)) {
            this.itmItemLifeStatusJobRepoProc.updateFailureItemList(itemCodeList);
            this.itmItemLifeStatusJobRepoProc.updateFailureBusiness(ItmItemBusinessDeleteParam.builder().itemCodes(itemCodeList).build());
        }
    }

    private void updateBusinessLifeStatus(List<ItmItemBusinessStatusDO> businessStatusDos, String itemLifeStatus) {
        businessStatusDos.forEach(business -> {
            String businessLifeStatus = business.getItemLifeStatus();
            if (StringUtils.isNotBlank((CharSequence)businessLifeStatus) && businessLifeStatus.contains(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_ENABLE.getUdcVal())) {
                business.setItemLifeStatus(null);
            }
            if (StringUtils.isBlank((CharSequence)business.getItemLifeStatus())) {
                business.setItemLifeStatus(itemLifeStatus);
            } else if (!businessLifeStatus.contains(itemLifeStatus)) {
                business.setItemLifeStatus(businessLifeStatus + ";" + itemLifeStatus);
            }
            if (StringUtils.isBlank((CharSequence)business.getItemLifeStatus())) {
                business.setItemLifeStatus(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_ENABLE.getUdcVal());
            }
        });
        this.itmItemBusinessStatusRepo.saveAll(businessStatusDos);
    }

    private void updateItemListLifeStatus(List<ItmItemDO> itemDos, String itemStatus2) {
        itemDos.forEach(item -> {
            String itemLifeStatus = item.getItemStatus2();
            if (StringUtils.isNotBlank((CharSequence)itemLifeStatus) && itemLifeStatus.contains(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_ENABLE.getUdcVal())) {
                item.setItemStatus2(null);
            }
            if (StringUtils.isBlank((CharSequence)item.getItemStatus2())) {
                item.setItemStatus2(itemStatus2);
            } else if (!itemLifeStatus.contains(itemStatus2)) {
                item.setItemStatus2(itemLifeStatus + ";" + itemStatus2);
            }
            if (StringUtils.isBlank((CharSequence)item.getItemStatus2())) {
                item.setItemStatus2(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_ENABLE.getUdcVal());
            }
        });
        this.itmItemRepo.saveAll(itemDos);
    }

    public ItmItemLifeStatusJobServiceImpl(ItmItemLifeStatusJobRepoProc itmItemLifeStatusJobRepoProc, ItmItemBusinessStatusRepo itmItemBusinessStatusRepo, ItmItemRepo itmItemRepo, ItmItemAsyncService itmItemAsyncService) {
        this.itmItemLifeStatusJobRepoProc = itmItemLifeStatusJobRepoProc;
        this.itmItemBusinessStatusRepo = itmItemBusinessStatusRepo;
        this.itmItemRepo = itmItemRepo;
        this.itmItemAsyncService = itmItemAsyncService;
    }
}

