/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.component.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.org.component.param.OrgStoreComPagingParam;
import com.elitesland.yst.supportdomain.org.component.vo.OrgStoreComPagingVO;
import com.elitesland.yst.supportdomain.org.entity.QOrgStoreDO;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class OrgStoreComponentRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QOrgStoreDO orgStoreDO = QOrgStoreDO.orgStoreDO;

    private JPAQuery<OrgStoreComPagingVO> select() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgStoreComPagingVO.class, (Expression[])new Expression[]{this.orgStoreDO.id, this.orgStoreDO.storeCode, this.orgStoreDO.storeName, this.orgStoreDO.storeType})).from((EntityPath)this.orgStoreDO);
    }

    private Predicate where(OrgStoreComPagingParam param) {
        String strLike = "%" + param.getStoreCodeOrNameLike() + "%";
        BooleanExpression predicate = this.orgStoreDO.deleteFlag.eq((Object)0).or((Predicate)this.orgStoreDO.deleteFlag.isNull()).and((Predicate)this.orgStoreDO.storeStatus.eq((Object)OrgUdcEnum.STORE_STATUS_ENABLE.getUdcVal()));
        predicate = StringUtils.isBlank((CharSequence)param.getStoreType()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.orgStoreDO.storeType.eq((Object)param.getStoreType()));
        predicate = StringUtils.isBlank((CharSequence)param.getStoreCodeOrNameLike()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.orgStoreDO.storeCode.like(strLike).or((Predicate)this.orgStoreDO.storeName.like(strLike)));
        return predicate;
    }

    public PagingVO<OrgStoreComPagingVO> searchByParams(OrgStoreComPagingParam param) {
        JPAQuery query = (JPAQuery)this.select().where(this.where(param));
        param.fillOrders(query, this.orgStoreDO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public OrgStoreComponentRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

