/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.component.service.impl;

import com.elitesland.yst.comm.consumer.dto.ComCurrRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComCurrRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComCurrRpcService;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.org.component.convert.OrgEmpComConvert;
import com.elitesland.yst.supportdomain.org.component.param.OrgBankAccComPagingParam;
import com.elitesland.yst.supportdomain.org.component.param.OrgBuComPagingParam;
import com.elitesland.yst.supportdomain.org.component.param.OrgBuTreeComPagingParam;
import com.elitesland.yst.supportdomain.org.component.param.OrgEmpComPagingParam;
import com.elitesland.yst.supportdomain.org.component.param.OrgOuComPagingParam;
import com.elitesland.yst.supportdomain.org.component.repo.OrgComponentRepoProc;
import com.elitesland.yst.supportdomain.org.component.service.OrgComponentService;
import com.elitesland.yst.supportdomain.org.component.vo.OrgBankAccComPagingVO;
import com.elitesland.yst.supportdomain.org.component.vo.OrgBuComPagingVO;
import com.elitesland.yst.supportdomain.org.component.vo.OrgBuComSelectVO;
import com.elitesland.yst.supportdomain.org.component.vo.OrgBuTreeComPagingVO;
import com.elitesland.yst.supportdomain.org.component.vo.OrgEmpBuComVO;
import com.elitesland.yst.supportdomain.org.component.vo.OrgEmpComPagingVO;
import com.elitesland.yst.supportdomain.org.component.vo.OrgEmpComVO;
import com.elitesland.yst.supportdomain.org.component.vo.OrgOuComPagingVO;
import com.elitesland.yst.supportdomain.org.component.vo.OrgOuComVO;
import com.elitesland.yst.supportdomain.org.entity.OrgBuTreeDO;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeRepoProc;
import com.elitesland.yst.supportdomain.org.service.OrgBuTreeDService;
import com.elitesland.yst.supportdomain.org.service.OrgBuTreeVersionService;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreeDetailVO;
import com.elitesland.yst.supportdomain.org.vo.SystemBuTreeVO;
import com.elitesland.yst.supportdomain.util.SystemSettingNoEnum;
import com.elitesland.yst.supportdomain.util.UtilEnum;
import com.elitesland.yst.system.service.ISysRoleOuService;
import com.elitesland.yst.system.vo.SysRoleOuVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class OrgComponentServiceImpl
implements OrgComponentService {
    private final UdcService sysUdcService;
    @DubboReference
    private ComCurrRpcService comCurrRpcService;
    @DubboReference
    private ISysRoleOuService sysRoleOuService;
    private final OrgComponentRepoProc orgComponentRepoProc;
    private final OrgBuTreeRepoProc orgBuTreeRepoProc;
    private final OrgBuTreeRepo orgBuTreeRepo;
    private final OrgBuTreeDService orgBuTreeDService;
    private final OrgBuTreeVersionService orgBuTreeVersionService;

    @Override
    public List<OrgEmpComVO> empComSearch(String empCodeOrName) {
        return this.orgComponentRepoProc.empComSearch(empCodeOrName);
    }

    @Override
    public PagingVO<OrgEmpComPagingVO> empComPagingSearch(OrgEmpComPagingParam param) {
        List<Long> empIds;
        List<OrgEmpBuComVO> empBuComVos;
        PagingVO<OrgEmpComPagingVO> result = this.orgComponentRepoProc.empComPagingSearch(param);
        if (CollectionUtils.isNotEmpty((Collection)result.getRecords()) && CollectionUtils.isNotEmpty(empBuComVos = this.orgComponentRepoProc.findEmpBuComVoByEmpIds(empIds = result.getRecords().stream().map(OrgEmpComPagingVO::getId).collect(Collectors.toList())))) {
            Map<Long, OrgEmpBuComVO> empBuComMap = empBuComVos.stream().collect(Collectors.toMap(OrgEmpBuComVO::getEmpId, t -> t, (t1, t2) -> t1));
            List<String> currCodes = empBuComMap.values().stream().map(OrgEmpBuComVO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<String, String> currMap = this.buildCurrMap(currCodes);
            result.getRecords().forEach(record -> {
                if (MapUtils.isNotEmpty((Map)empBuComMap) && empBuComMap.containsKey(record.getId())) {
                    OrgEmpComConvert.INSTANCE.updateEmpBuVOToEmpVO((OrgEmpBuComVO)empBuComMap.get(record.getId()), (OrgEmpComPagingVO)record);
                }
                if (MapUtils.isNotEmpty((Map)currMap) && StringUtils.isNotBlank((CharSequence)record.getCurrCode())) {
                    record.setCurrName(currMap.getOrDefault(record.getCurrCode(), null));
                }
                Map<Long, List<OrgEmpBuComVO>> empMap = empBuComVos.stream().collect(Collectors.groupingBy(OrgEmpBuComVO::getEmpId));
                if (MapUtils.isNotEmpty((Map)empBuComMap) && empBuComMap.containsKey(record.getId())) {
                    List<OrgEmpBuComVO> orgEmpBuComVOS = empMap.get(record.getId());
                    String empOuNameStr = orgEmpBuComVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OrgEmpBuComVO>(Comparator.comparing(OrgEmpBuComVO::getOuId))), ArrayList::new)).stream().map(OrgEmpBuComVO::getOuName).collect(Collectors.joining(","));
                    record.setOuName(empOuNameStr);
                }
            });
        }
        return result;
    }

    @Override
    @SysCodeProc
    public PagingVO<OrgOuComPagingVO> ouComPagingSearch(OrgOuComPagingParam param) {
        Map<String, String> currMap;
        List<String> currCodes;
        PagingVO<OrgOuComPagingVO> result;
        GeneralUserDetails user = SecurityUtil.getUser();
        if (user != null && user.getUser().getId() != null) {
            try {
                List<SysRoleOuVO> idOne = this.sysRoleOuService.selectByUserId(user.getUser().getId());
                if (idOne != null && !idOne.isEmpty()) {
                    List<Long> longStream = idOne.stream().map(SysRoleOuVO::getOuId).collect(Collectors.toList());
                    param.setOuId(longStream);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(result = this.orgComponentRepoProc.ouComPagingSearch(param)).getRecords()) && CollectionUtils.isNotEmpty(currCodes = result.getRecords().stream().map(OrgOuComPagingVO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && (currMap = this.buildCurrMap(currCodes)) != null) {
            result.getRecords().forEach(record -> {
                if (StringUtils.isNotBlank((CharSequence)record.getCurrCode())) {
                    record.setCurrName(currMap.getOrDefault(record.getCurrCode(), null));
                }
            });
        }
        return result;
    }

    @Override
    public List<OrgOuComVO> ouComSearch(String ouCodeOrName) {
        return this.orgComponentRepoProc.ouComSearch(ouCodeOrName);
    }

    @Override
    @SysCodeProc
    public PagingVO<OrgBuComPagingVO> buSubComPagingSearch(OrgBuComPagingParam param) {
        PagingVO<OrgBuComPagingVO> result = this.orgComponentRepoProc.buComPagingSearch(param, true);
        this.buildBuTypeNameAndCurrName(result);
        return result;
    }

    @Override
    @SysCodeProc
    public PagingVO<OrgBuComPagingVO> buComPagingSearch(OrgBuComPagingParam param) {
        PagingVO<OrgBuComPagingVO> result = this.orgComponentRepoProc.buComPagingSearch(param, false);
        this.buildBuTypeNameAndCurrName(result);
        return result;
    }

    @Override
    public List<OrgBuComSelectVO> buComSelectByBuType(String buType) {
        return this.orgComponentRepoProc.buComSelectByBuType(buType);
    }

    private void buildBuTypeNameAndCurrName(PagingVO<OrgBuComPagingVO> pagingVo) {
        if (CollectionUtils.isNotEmpty((Collection)pagingVo.getRecords())) {
            Map udcMap = this.sysUdcService.getCodeMap("ORG", "BU_TYPE");
            List<String> currCodes = pagingVo.getRecords().stream().map(OrgBuComPagingVO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<String, String> currMap = this.buildCurrMap(currCodes);
            pagingVo.getRecords().forEach(vo -> {
                String buTypeStr = vo.getBuType();
                if (StringUtils.isNotBlank((CharSequence)buTypeStr)) {
                    String buTypeNameStr = Arrays.stream(buTypeStr.split(",")).map(buType -> udcMap.getOrDefault(buType, "")).collect(Collectors.joining(","));
                    vo.setBuTypeName(buTypeNameStr);
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getCurrCode())) {
                    vo.setCurrName(currMap.getOrDefault(vo.getCurrCode(), null));
                }
            });
        }
    }

    @Override
    @SysCodeProc
    public PagingVO<OrgBankAccComPagingVO> bankAccPagingSearch(OrgBankAccComPagingParam param) {
        List<String> currCodes;
        Map<String, String> currMap;
        PagingVO<OrgBankAccComPagingVO> result = this.orgComponentRepoProc.bankAccComPagingSearch(param);
        if (CollectionUtils.isNotEmpty((Collection)result.getRecords()) && (currMap = this.buildCurrMap(currCodes = result.getRecords().stream().map(OrgBankAccComPagingVO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) != null && !currMap.isEmpty()) {
            result.getRecords().forEach(record -> {
                if (StringUtils.isNotBlank((CharSequence)record.getCurrCode())) {
                    record.setCurrName(currMap.getOrDefault(record.getCurrCode(), null));
                }
            });
        }
        return result;
    }

    @Override
    @SysCodeProc
    public PagingVO<OrgBuTreeComPagingVO> queryComOrgBuTreeByParams(OrgBuTreeComPagingParam param) {
        return this.orgComponentRepoProc.searchBuTreeListComByParams(param);
    }

    private Map<String, String> buildCurrMap(List<String> currCodes) {
        if (CollectionUtils.isNotEmpty(currCodes)) {
            ComCurrRpcDtoParam currParam = ComCurrRpcDtoParam.builder().currCodes(currCodes).build();
            List currRpcDtos = this.comCurrRpcService.findRpcDtoByParam(currParam);
            if (CollectionUtils.isNotEmpty((Collection)currRpcDtos)) {
                return currRpcDtos.stream().collect(Collectors.toMap(ComCurrRpcDTO::getCurrCode, ComCurrRpcDTO::getCurrName));
            }
            return Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    @Override
    @SysCodeProc
    @Cacheable(cacheNames={"ORG_BU_TREE"}, key="'BU_TREE_ID_BUORGTREE'")
    public OrgBuTreeDetailVO getOrgBuTreeDetail() {
        SystemBuTreeVO systemBuTreeVO = this.orgBuTreeVersionService.findActiveVersionByBuTreeCode(SystemSettingNoEnum.ITEM_BUSI_TREE.name());
        Optional<OrgBuTreeDO> byBuTreeCode = this.orgBuTreeRepo.findByBuTreeCodeAndNowVersion(systemBuTreeVO.getBuTreeCode(), systemBuTreeVO.getVersion());
        if (byBuTreeCode.isPresent()) {
            OrgBuTreeDO orgBuTreeDO = byBuTreeCode.get();
            Long id = orgBuTreeDO.getId();
            OrgBuTreeDetailVO orgBuTreeDetailVO = this.orgBuTreeRepoProc.findBuTreeDetailById(id);
            if (orgBuTreeDetailVO != null) {
                orgBuTreeDetailVO.setOrgBuTreeDVOList(this.orgBuTreeDService.orgBuTreeDSearchTree(id, UtilEnum.CODE_TYPE.getValue(), null));
            }
            return orgBuTreeDetailVO;
        }
        throw new BusinessException("BUORGTREE\u7ec4\u7ec7\u6811\u4e0d\u5b58\u5728");
    }

    public OrgComponentServiceImpl(UdcService sysUdcService, OrgComponentRepoProc orgComponentRepoProc, OrgBuTreeRepoProc orgBuTreeRepoProc, OrgBuTreeRepo orgBuTreeRepo, OrgBuTreeDService orgBuTreeDService, OrgBuTreeVersionService orgBuTreeVersionService) {
        this.sysUdcService = sysUdcService;
        this.orgComponentRepoProc = orgComponentRepoProc;
        this.orgBuTreeRepoProc = orgBuTreeRepoProc;
        this.orgBuTreeRepo = orgBuTreeRepo;
        this.orgBuTreeDService = orgBuTreeDService;
        this.orgBuTreeVersionService = orgBuTreeVersionService;
    }
}

