/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.controller;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.org.entity.OrgBuDO;
import com.elitesland.yst.supportdomain.org.param.OrgBuPagingParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuRelationOuParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuStatusParam;
import com.elitesland.yst.supportdomain.org.service.OrgBuAuthService;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import com.elitesland.yst.supportdomain.org.vo.OrgBuDetailsVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuRelationOuVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/org/orgBu"})
@Api(value="BU\u7ec4\u7ec7", tags={"BU\u7ec4\u7ec7"})
public class OrgBuController {
    private final OrgBuService orgBuService;
    private final OrgBuAuthService orgBuAuthService;

    @PostMapping(value={"/listAuth"})
    @ApiOperation(value="BU\u7ec4\u7ec7\u5206\u9875\u6761\u4ef6\u67e5\u8be2-\u6570\u636e\u6743\u9650")
    public ApiResult<PagingVO<OrgBuVO>> searchByListAuth(@RequestBody OrgBuPagingParam param) {
        PagingVO<OrgBuVO> result = null;
        try {
            result = this.orgBuAuthService.queryByParamsAuth(param);
        }
        catch (Exception e) {
            e.printStackTrace();
            ApiResult.fail((String)("\u5f02\u5e38:" + e.getMessage()));
        }
        return ApiResult.ok(result);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="BU\u7ec4\u7ec7\u5206\u9875\u6761\u4ef6\u67e5\u8be2")
    public ApiResult<PagingVO<OrgBuVO>> searchByParams(@RequestBody OrgBuPagingParam param) {
        PagingVO<OrgBuVO> result = this.orgBuService.queryByParams(param);
        return ApiResult.ok(result);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="BU\u7ec4\u7ec7\u6dfb\u52a0/\u7f16\u8f91")
    public ApiResult<String> save(@RequestBody OrgBuSaveParam param) {
        OrgBuDO result = this.orgBuService.saveOrUpdate(param);
        return ApiResult.ok((Object)result.getId().toString());
    }

    @PutMapping(value={"/updateOrgBuStatus"})
    @ApiOperation(value="BU\u7ec4\u7ec7\u786e\u8ba4\u3001\u505c\u7528")
    public ApiResult<Object> updateOrgBuStatus(@RequestBody OrgBuStatusParam param) {
        this.orgBuService.updateOrgBuStatus(param);
        return ApiResult.ok();
    }

    @GetMapping(value={"/getById/{id}"})
    @ApiOperation(value="\u901a\u8fc7BU\u7ec4\u7ec7id\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f")
    public ApiResult<OrgBuDetailsVO> searchById(@PathVariable Long id) {
        OrgBuDetailsVO orgBuVO = this.orgBuService.getOrgBuDetailsVOById(id);
        return ApiResult.ok((Object)orgBuVO);
    }

    @GetMapping(value={"/checkByCode/{buCode}"})
    @ApiOperation(value="\u901a\u8fc7buCode\u6821\u9a8c\u7ec4\u7ec7\u662f\u5426\u5b58\u5728")
    public ApiResult<Object> checkByCode(@PathVariable String buCode) {
        Boolean result = this.orgBuService.checkByBuCode(buCode);
        return ApiResult.ok((Object)result);
    }

    @PostMapping(value={"/ouList"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2\u5bf9\u5e94\u516c\u53f8\u4fe1\u606f")
    public ApiResult<List<OrgBuRelationOuVO>> searchByParams(@RequestBody OrgBuRelationOuParam param) {
        List<OrgBuRelationOuVO> result = this.orgBuService.findBuRelationOuList(param);
        return ApiResult.ok(result);
    }

    public OrgBuController(OrgBuService orgBuService, OrgBuAuthService orgBuAuthService) {
        this.orgBuService = orgBuService;
        this.orgBuAuthService = orgBuAuthService;
    }
}

