/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.controller;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.org.excel.service.OrgEmpExcelService;
import com.elitesland.yst.supportdomain.org.param.OrgEmpPagingParam;
import com.elitesland.yst.supportdomain.org.param.OrgEmpSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgEmpSwitchStsParam;
import com.elitesland.yst.supportdomain.org.service.OrgEmpService;
import com.elitesland.yst.supportdomain.org.vo.OrgEmpDetailVO;
import com.elitesland.yst.supportdomain.org.vo.OrgEmpPagingVO;
import com.elitesland.yst.supportdomain.org.vo.OrgUserEmpInfoVO;
import com.elitesland.yst.system.vo.SysUserDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/org/emp"})
@Api(value="\u5458\u5de5", tags={"\u5458\u5de5"})
public class OrgEmpController {
    private static final Logger log = LoggerFactory.getLogger(OrgEmpController.class);
    private final OrgEmpService orgEmpService;
    private final OrgEmpExcelService orgEmpExcelService;

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u5458\u5de5\u5206\u9875\u67e5\u8be2\u63a5\u53e3")
    public ApiResult<PagingVO<OrgEmpPagingVO>> searchPaging(@RequestBody OrgEmpPagingParam param) {
        PagingVO<OrgEmpPagingVO> result = this.orgEmpService.searchPagingByParam(param);
        return ApiResult.ok(result);
    }

    @PostMapping(value={"/switchEmpSts"})
    @ApiOperation(value="\u5458\u5de5\u72b6\u6001\u53d8\u66f4")
    public ApiResult<Void> switchEmpSts(@RequestBody @Valid OrgEmpSwitchStsParam param) {
        this.orgEmpService.switchEmpSts(param);
        return ApiResult.ok();
    }

    @GetMapping(value={"/detail/{id}"})
    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u5458\u5de5\u8be6\u60c5")
    public ApiResult<OrgEmpDetailVO> searchEmpDetailsById(@PathVariable Long id) {
        OrgEmpDetailVO result = this.orgEmpService.searchDetailById(id);
        return ApiResult.ok((Object)result);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u65b0\u589e/\u66f4\u65b0 \u5458\u5de5\u4fe1\u606f")
    public ApiResult<String> saveOrUpdate(@RequestBody OrgEmpSaveParam param) {
        Long result = this.orgEmpService.saveOrUpdateEmp(param);
        return ApiResult.ok((Object)result.toString());
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u7ec4\u7ec7\u76f8\u5173\u4fe1\u606f")
    @GetMapping(value={"/user/current"})
    public ApiResult<OrgUserEmpInfoVO> userEmpInfo() {
        GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
        if (generalUserDetails != null && generalUserDetails.getUser() != null) {
            SysUserDTO currentUser = generalUserDetails.getUser();
            log.info("[EMP-USER-INFO] Find current user info : [userId: " + currentUser.getId() + ", username: " + currentUser.getUsername() + "]");
            OrgUserEmpInfoVO userEmpInfo = currentUser.getId() == null ? null : this.orgEmpService.userEmpInfo(currentUser.getId());
            return ApiResult.ok(userEmpInfo);
        }
        log.info("[EMP-USER-INFO] Current user info not found.");
        return ApiResult.ok();
    }

    @ApiOperation(value="\u5bfc\u5165\u5458\u5de5")
    @PostMapping(value={"/upload"}, headers={"content-type=multipart/form-data"})
    public ApiResult<Object> excelUpload(MultipartFile file) {
        this.orgEmpExcelService.uploadExcel(file);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u5bfc\u51fa\u5458\u5de5")
    @PostMapping(value={"/export"})
    public void exportExcel(@RequestBody OrgEmpPagingParam param, HttpServletResponse response) {
        this.orgEmpExcelService.exportExcel(param, response);
    }

    public OrgEmpController(OrgEmpService orgEmpService, OrgEmpExcelService orgEmpExcelService) {
        this.orgEmpService = orgEmpService;
        this.orgEmpExcelService = orgEmpExcelService;
    }
}

