/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.excel.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.excel.entity.ErrorInfo;
import com.elitesland.yst.supportdomain.org.entity.OrgAddrDO;
import com.elitesland.yst.supportdomain.org.entity.OrgEmpBuDO;
import com.elitesland.yst.supportdomain.org.entity.OrgEmpDO;
import com.elitesland.yst.supportdomain.org.excel.entity.OrgEmpUploadExcel;
import com.elitesland.yst.supportdomain.org.excel.repo.OrgEmpExcelRepoProc;
import com.elitesland.yst.supportdomain.org.excel.vo.OrgBuAndOuInfoExcelVO;
import com.elitesland.yst.supportdomain.org.excel.vo.OrgBuTreeDExcelVO;
import com.elitesland.yst.supportdomain.org.excel.vo.OrgEmpExcelVO;
import com.elitesland.yst.supportdomain.org.repo.OrgAddrRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgEmpBuRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgEmpRepo;
import com.elitesland.yst.system.provider.SysUserRpcService;
import com.elitesland.yst.system.provider.dto.SysUserRpcDTO;
import com.elitesland.yst.system.provider.param.SysUserRpcDtoParam;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgEmpListener
extends AnalysisEventListener<OrgEmpUploadExcel> {
    private static final String HSHORGTREE = "HSHORGTREE";
    private static final String BUORGTREE = "BUORGTREE";
    private static final String EMP_TYPE = "\u5458\u5de5";
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private static final Logger LOGGER = LoggerFactory.getLogger(OrgEmpListener.class);
    private final ErrorInfo errorInfo;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final OrgEmpRepo orgEmpRepo;
    private final OrgEmpBuRepo orgEmpBuRepo;
    private final OrgAddrRepo orgAddrRepo;
    private final List<String> empCodeList;
    private final List<String> empBindUserName;
    private final Map<String, SysUserRpcDTO> userNameMap;
    private final Map<String, Map<String, OrgBuTreeDExcelVO>> buTreeDMap;
    private final Map<Long, Long> buAndOuMap;
    private final Map<String, String> empTypeMap;
    private final Map<String, String> empGenderMap;
    private final Map<String, String> empIdTypeMap;
    private final Map<String, String> addrTypeMap;
    private final Map<String, Map<String, List<OrgEmpBuDO>>> orgEmpBuDoMap = new HashMap<String, Map<String, List<OrgEmpBuDO>>>();
    private final Map<String, Map<String, OrgEmpDO>> orgEmpDoMap = new HashMap<String, Map<String, OrgEmpDO>>();
    private final List<String> uniqueRowList = new ArrayList<String>();

    public OrgEmpListener(ErrorInfo errorInfo, OrgEmpExcelRepoProc orgEmpExcelRepoProc, OrgEmpRepo orgEmpRepo, OrgEmpBuRepo orgEmpBuRepo, OrgAddrRepo orgAddrRepo, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, SysUserRpcService sysUserRpcService, UdcService sysUdcService) {
        this.errorInfo = errorInfo;
        this.orgAddrRepo = orgAddrRepo;
        this.orgEmpRepo = orgEmpRepo;
        this.orgEmpBuRepo = orgEmpBuRepo;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.empCodeList = orgEmpExcelRepoProc.findAllEmpCodeInfo().stream().map(OrgEmpExcelVO::getEmpCode).filter(Objects::nonNull).collect(Collectors.toList());
        this.empBindUserName = orgEmpExcelRepoProc.findAllEmpCodeInfo().stream().map(OrgEmpExcelVO::getUserName).filter(Objects::nonNull).collect(Collectors.toList());
        this.userNameMap = sysUserRpcService.findUserRpcDtoByParam(SysUserRpcDtoParam.builder().enabled(Boolean.TRUE).build()).stream().collect(Collectors.toMap(SysUserRpcDTO::getUsername, t -> t, (t1, t2) -> t1));
        List<OrgBuTreeDExcelVO> orgBuTreeDInfo = orgEmpExcelRepoProc.findOrgBuTreeDInfo();
        this.buTreeDMap = orgBuTreeDInfo.stream().filter(tree -> tree.getBuTreeCode() != null).collect(Collectors.groupingBy(OrgBuTreeDExcelVO::getBuTreeCode)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().collect(Collectors.toMap(OrgBuTreeDExcelVO::getBuCode, t -> t, (t1, t2) -> t1))));
        this.buAndOuMap = orgEmpExcelRepoProc.findBuAndOuInfo(orgBuTreeDInfo.stream().map(OrgBuTreeDExcelVO::getBuId).filter(Objects::nonNull).collect(Collectors.toList())).stream().filter(buAndOu -> null != buAndOu.getBuId() && null != buAndOu.getOuId()).collect(Collectors.toMap(OrgBuAndOuInfoExcelVO::getBuId, OrgBuAndOuInfoExcelVO::getOuId, (t1, t2) -> t1));
        this.empTypeMap = sysUdcService.getCodeMap("ORG", "EMP_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.empGenderMap = sysUdcService.getCodeMap("ORG", "EMP_GENDER").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.empIdTypeMap = sysUdcService.getCodeMap("ORG", "EMP_ID_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.addrTypeMap = sysUdcService.getCodeMap("ORG", "ADDR_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public void invoke(OrgEmpUploadExcel data, AnalysisContext context) {
        String uniqueRow;
        String mobile;
        String idNo;
        String idType;
        String birthDate;
        String empGender;
        String userName;
        int rowId = context.readSheetHolder().getRowIndex() + 1;
        OrgEmpDO orgEmpDO = new OrgEmpDO();
        String empCode = data.getEmpCode();
        if (StringUtils.isNotBlank((CharSequence)empCode)) {
            if (this.empCodeList.contains(empCode)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5458\u5de5\u7f16\u53f7", "\u4e0e\u5df2\u6709\u7f16\u53f7\u91cd\u590d"));
            } else {
                orgEmpDO.setEmpCode(empCode);
            }
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5458\u5de5\u7f16\u53f7", "\u5fc5\u586b"));
        }
        String empName = data.getEmpName();
        if (StringUtils.isNotBlank((CharSequence)empName)) {
            orgEmpDO.setEmpName(empName);
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5458\u5de5\u59d3\u540d", "\u5fc5\u586b"));
        }
        String empType = data.getEmpType();
        if (StringUtils.isNotBlank((CharSequence)empType)) {
            orgEmpDO.setEmpType(Arrays.stream(empType.split("(;|\uff1b)")).map(type -> {
                String empTypeCode = this.empTypeMap.get(type);
                if (StringUtils.isBlank((CharSequence)empTypeCode)) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5458\u5de5\u7c7b\u578b", type + "\u4e0d\u5b58\u5728"));
                }
                return empTypeCode;
            }).filter(Objects::nonNull).distinct().collect(Collectors.joining(",")));
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5458\u5de5\u7c7b\u578b", "\u7c7b\u578b\u5fc5\u586b"));
        }
        String buTreeCode = data.getBuTreeCode();
        String buNames = data.getBuNames();
        HashMap buTreeCodeOrgEmpBuMap = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)buTreeCode)) {
            if (!this.buTreeDMap.containsKey(buTreeCode)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5458\u5de5\u6240\u5c5e\u7ec4\u7ec7\u6811", buTreeCode + "\u7ec4\u7ec7\u6811\u4e0d\u5b58\u5728"));
            }
            if (StringUtils.isNotBlank((CharSequence)buNames)) {
                Map<String, OrgBuTreeDExcelVO> stringOrgBuTreeDExcelVOMap = this.buTreeDMap.get(buTreeCode);
                ArrayList orgEmpBuList = new ArrayList();
                List empBuNames = Arrays.asList(buNames.split("(;|\uff1b)")).stream().distinct().collect(Collectors.toList());
                if (BUORGTREE.equals(buTreeCode) && empBuNames.size() > 1) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5458\u5de5\u6240\u5c5e\u7ec4\u7ec7", "BUORGTREE\u7ec4\u7ec7\u6811\u53ea\u80fd\u7ed1\u5b9a\u4e00\u4e2a\u7ec4\u7ec7"));
                }
                empBuNames.stream().forEach(buName -> {
                    if (stringOrgBuTreeDExcelVOMap.containsKey(buName)) {
                        if (!this.errorInfo.hasError()) {
                            OrgBuTreeDExcelVO orgBuTreeDExcelVO = (OrgBuTreeDExcelVO)stringOrgBuTreeDExcelVOMap.get(buName);
                            OrgEmpBuDO orgEmpBuDO = new OrgEmpBuDO();
                            orgEmpBuDO.setEmpBuId(orgBuTreeDExcelVO.getBuId());
                            orgEmpBuDO.setEmpBuTreeCode(orgBuTreeDExcelVO.getBuTreeCode());
                            orgEmpBuDO.setEmpBuTreeId(orgBuTreeDExcelVO.getBuTreeId());
                            orgEmpBuDO.setEmpBuTreeDId(orgBuTreeDExcelVO.getBuTreeDId());
                            orgEmpBuList.add(orgEmpBuDO);
                        }
                    } else {
                        this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5458\u5de5\u6240\u5c5e\u7ec4\u7ec7", buName + "\u4e0d\u5b58\u5728"));
                    }
                });
                if (CollectionUtils.isNotEmpty(orgEmpBuList)) {
                    buTreeCodeOrgEmpBuMap.put(buTreeCode, orgEmpBuList);
                }
            }
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5458\u5de5\u6240\u5c5e\u7ec4\u7ec7\u6811", "\u5fc5\u586b"));
        }
        if (StringUtils.isBlank((CharSequence)buNames)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5458\u5de5\u6240\u5c5e\u7ec4\u7ec7", "\u5fc5\u586b"));
        }
        if (StringUtils.isNotBlank((CharSequence)(userName = data.getUserName()))) {
            if (this.userNameMap.containsKey(userName)) {
                if (this.empBindUserName.contains(userName)) {
                    this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u7528\u6237\u8d26\u53f7", userName + "\u5df2\u7ecf\u88ab\u5176\u4ed6\u5458\u5de5\u7ed1\u5b9a"));
                } else {
                    SysUserRpcDTO sysUserRpcDTO = this.userNameMap.get(userName);
                    if (null != sysUserRpcDTO) {
                        orgEmpDO.setUserId(sysUserRpcDTO.getId());
                        orgEmpDO.setUserName(sysUserRpcDTO.getUsername());
                    } else {
                        this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u7528\u6237\u8d26\u53f7", userName + "\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728"));
                    }
                }
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u7528\u6237\u8d26\u53f7", userName + "\u7528\u6237\u4e0d\u5b58\u5728"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(empGender = data.getEmpGender()))) {
            String genderCode = this.empGenderMap.get(empGender);
            if (StringUtils.isNotBlank((CharSequence)genderCode)) {
                orgEmpDO.setEmpGender(genderCode);
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6027\u522b", empGender + "\u4e0d\u5b58\u5728"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(birthDate = data.getBirthDate()))) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            try {
                LocalDateTime parse = LocalDateTime.parse(birthDate + " 00:00:00", df);
                orgEmpDO.setBirthDate(parse);
            }
            catch (Exception e) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u51fa\u751f\u65e5\u671f", "\u683c\u5f0f\u9519\u8bef"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(idType = data.getIdType()))) {
            String type2 = this.empIdTypeMap.get(idType);
            if (StringUtils.isNotBlank((CharSequence)type2)) {
                orgEmpDO.setIdType(type2);
            } else {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8bc1\u4ef6\u7c7b\u578b", idType + "\u4e0d\u5b58\u5728"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(idNo = data.getIdNo()))) {
            orgEmpDO.setIdNo(idNo);
        }
        if (StringUtils.isNotBlank((CharSequence)(mobile = data.getMobile()))) {
            orgEmpDO.setMobile(mobile);
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u624b\u673a\u53f7", "\u5fc5\u586b"));
        }
        String email = data.getEmail();
        if (StringUtils.isNotBlank((CharSequence)email)) {
            orgEmpDO.setEmail(email);
        }
        if (this.uniqueRowList.contains(uniqueRow = empCode + "_" + buTreeCode)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "", "\u91cd\u590d\u884c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e"));
        } else {
            this.uniqueRowList.add(uniqueRow);
        }
        if (!this.errorInfo.hasError()) {
            Map<String, List<OrgEmpBuDO>> empBuStringListMap = this.orgEmpBuDoMap.get(empCode);
            if (MapUtils.isNotEmpty(empBuStringListMap)) {
                empBuStringListMap.putAll(buTreeCodeOrgEmpBuMap);
                this.orgEmpBuDoMap.put(empCode, empBuStringListMap);
            } else {
                this.orgEmpBuDoMap.put(empCode, buTreeCodeOrgEmpBuMap);
            }
            Map<String, OrgEmpDO> empStringListMap = this.orgEmpDoMap.get(empCode);
            if (MapUtils.isNotEmpty(empStringListMap)) {
                empStringListMap.put(empCode, orgEmpDO);
                this.orgEmpDoMap.put(empCode, empStringListMap);
            } else {
                this.orgEmpDoMap.put(empCode, Map.of(empCode, orgEmpDO));
            }
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        LOGGER.info("\u89e3\u6790\u5b8c\u6210");
        if (this.errorInfo.hasError()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, this.errorInfo.getLogs().toString());
        }
        this.doSave();
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        if (exception instanceof ExcelDataConvertException) {
            LOGGER.error("\u89e3\u6790\u5931\u8d25\uff0c\u4f46\u662f\u7ee7\u7eed\u89e3\u6790\u4e0b\u4e00\u884c:{}", (Object)exception.getMessage());
            ExcelDataConvertException excelDataConvertException = (ExcelDataConvertException)exception;
            String logStr = MessageFormat.format(ERROR_TEMPLATE, excelDataConvertException.getRowIndex() + 1, excelDataConvertException.getColumnIndex() + 1, excelDataConvertException.getCause().getMessage());
            LOGGER.error(logStr);
            this.errorInfo.log(logStr);
        } else if (exception instanceof BusinessException) {
            throw exception;
        }
    }

    private void doSave() {
        Long nowUserId = null;
        GeneralUserDetails user = SecurityUtil.getUser();
        if (user != null && user.getSecurityOrgUserEmpBuDTO() != null && user.getSecurityOrgUserEmpBuDTO().getEmpId() != null) {
            nowUserId = user.getSecurityOrgUserEmpBuDTO().getEmpId();
        }
        ArrayList orgEmpDOResultList = new ArrayList();
        this.orgEmpDoMap.entrySet().forEach(empInfo -> {
            Map value = (Map)empInfo.getValue();
            if (value.containsKey(HSHORGTREE)) {
                OrgEmpDO orgEmpDO = (OrgEmpDO)value.get(HSHORGTREE);
                OrgEmpBuDO orgEmpBuDO = this.orgEmpBuDoMap.get(empInfo.getKey()).get(HSHORGTREE).get(0);
                orgEmpDO.setSecBuId(orgEmpBuDO.getEmpBuId());
                orgEmpDO.setSecOuId(this.buAndOuMap.get(orgEmpBuDO.getEmpBuId()));
                orgEmpDOResultList.add(orgEmpDO);
            } else {
                ArrayList values = new ArrayList(((Map)empInfo.getValue()).values());
                Map<String, List<OrgEmpBuDO>> stringListMap = this.orgEmpBuDoMap.get(empInfo.getKey());
                String buTreeCode = new ArrayList<String>(stringListMap.keySet()).get(0);
                OrgEmpBuDO orgEmpBuDO = stringListMap.get(buTreeCode).get(0);
                if (CollectionUtils.isNotEmpty(values)) {
                    OrgEmpDO orgEmpDO = (OrgEmpDO)values.get(0);
                    orgEmpDO.setSecBuId(orgEmpBuDO.getEmpBuId());
                    orgEmpDO.setSecOuId(this.buAndOuMap.get(orgEmpBuDO.getEmpBuId()));
                    orgEmpDOResultList.add(orgEmpDO);
                }
            }
        });
        ArrayList<OrgAddrDO> addrDOList = new ArrayList<OrgAddrDO>();
        for (OrgEmpDO orgEmpDO : orgEmpDOResultList) {
            OrgAddrDO orgAddrDO = new OrgAddrDO();
            Long addrNo = Long.valueOf(this.sysNumberGeneratorWrapper.generate("ADDRNO"));
            if (this.orgAddrRepo.existsByAddrNo(addrNo)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7684\u5730\u5740\u53f7\uff1a" + addrNo + " \u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            }
            orgAddrDO.setAddrNo(addrNo);
            orgAddrDO.setAddrType(this.addrTypeMap.get(EMP_TYPE));
            orgAddrDO.setAddrName(orgEmpDO.getEmpName());
            orgAddrDO.setCreateUserId(nowUserId);
            orgEmpDO.setEmpStatus("ACTIVE");
            orgEmpDO.setAddrNo(addrNo);
            orgEmpDO.setPid(0L);
            orgEmpDO.setCreateUserId(nowUserId);
            orgEmpDO.setDeleteFlag(0);
            addrDOList.add(orgAddrDO);
        }
        this.orgEmpRepo.saveAll(orgEmpDOResultList);
        this.orgAddrRepo.saveAll(addrDOList);
        Map<String, OrgEmpDO> orgEmpCodeMap = orgEmpDOResultList.stream().collect(Collectors.toMap(OrgEmpDO::getEmpCode, t -> t));
        ArrayList orgEmpBuDOResult = new ArrayList();
        this.orgEmpBuDoMap.forEach((empCode, value) -> {
            OrgEmpDO orgEmpDO = (OrgEmpDO)orgEmpCodeMap.get(empCode);
            if (null != orgEmpDO) {
                Long empId = orgEmpDO.getId();
                orgEmpBuDOResult.addAll(value.values().stream().flatMap(Collection::stream).map(empBu -> empBu.setEmpId(empId)).collect(Collectors.toList()));
            }
        });
        this.orgEmpBuRepo.saveAll(orgEmpBuDOResult);
    }
}

