/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.excel.repo;

import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.elitesland.yst.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.supportdomain.org.entity.QOrgBuDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgBuTreeDDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgBuTreeDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgEmpBuDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgEmpDO;
import com.elitesland.yst.supportdomain.org.excel.vo.OrgBuAndOuInfoExcelVO;
import com.elitesland.yst.supportdomain.org.excel.vo.OrgBuTreeDExcelVO;
import com.elitesland.yst.supportdomain.org.excel.vo.OrgEmpBuExcelExportVO;
import com.elitesland.yst.supportdomain.org.excel.vo.OrgEmpExcelExportVO;
import com.elitesland.yst.supportdomain.org.excel.vo.OrgEmpExcelVO;
import com.elitesland.yst.supportdomain.org.param.OrgEmpPagingParam;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class OrgEmpExcelRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QOrgBuTreeDDO buTreeD = QOrgBuTreeDDO.orgBuTreeDDO;
    private final QOrgBuTreeDO buTree = QOrgBuTreeDO.orgBuTreeDO;
    private final QOrgBuDO orgBu = QOrgBuDO.orgBuDO;
    private final QOrgEmpDO orgEmp = QOrgEmpDO.orgEmpDO;
    private final QOrgEmpBuDO orgEmpBu = QOrgEmpBuDO.orgEmpBuDO;

    public List<OrgBuTreeDExcelVO> findOrgBuTreeDInfo() {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuTreeDExcelVO.class, (Expression[])new Expression[]{this.buTreeD.id.as("buTreeDId"), this.buTreeD.buId, this.buTreeD.buTreeId, this.orgBu.buCode, this.buTree.buTreeCode})).from((EntityPath)this.buTree)).leftJoin((EntityPath)this.buTreeD)).on((Predicate)this.buTreeD.buTreeId.eq(this.buTree.id))).leftJoin((EntityPath)this.orgBu)).on((Predicate)this.buTreeD.buId.eq(this.orgBu.id))).fetch();
    }

    public List<OrgEmpExcelVO> findAllEmpCodeInfo() {
        return ((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgEmpExcelVO.class, (Expression[])new Expression[]{this.orgEmp.empCode, this.orgEmp.userName})).from((EntityPath)this.orgEmp)).fetch();
    }

    public List<OrgBuAndOuInfoExcelVO> findBuAndOuInfo(List<Long> buIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuAndOuInfoExcelVO.class, (Expression[])new Expression[]{this.orgBu.id.as("buId"), this.orgBu.ouId})).from((EntityPath)this.orgBu)).where((Predicate)this.orgBu.id.in(buIds))).fetch();
    }

    public List<OrgEmpExcelExportVO> getEmpExportByParam(OrgEmpPagingParam param) {
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgEmpExcelExportVO.class, (Expression[])new Expression[]{this.orgEmp.id, this.orgEmp.empCode, this.orgEmp.empName, this.orgEmp.empGender, this.orgEmp.empType, this.orgEmp.birthDate, this.orgEmp.idType, this.orgEmp.idNo, this.orgEmp.userName, this.orgEmp.mobile, this.orgEmp.email})).from((EntityPath)this.orgEmp);
        query.where(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.orgEmp.getMetadata()));
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (!StringUtils.isBlank((CharSequence)param.getEmpCodeName())) {
            String string = "%" + param.getEmpCodeName() + "%";
            predicates.add(this.orgEmp.empCode.like(string).or((Predicate)this.orgEmp.empName.like(string)));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getEmpType())) {
            for (String type : param.getEmpType().split(",")) {
                predicates.add(Expressions.booleanTemplate((String)"FIND_IN_SET({0}, {1}) > 0", (Object[])new Object[]{type, this.orgEmp.empType}));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)param.getUserName())) {
            String string = "%" + param.getUserName() + "%";
            predicates.add(this.orgEmp.userName.like(string));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getEmpStatus())) {
            predicates.add(this.orgEmp.empStatus.eq((Object)param.getEmpStatus()));
        }
        predicates.add(this.orgEmp.deleteFlag.isNull().or((Predicate)this.orgEmp.deleteFlag.eq((Object)0)));
        query.where(ExpressionUtils.allOf(predicates));
        return query.fetch();
    }

    public List<OrgEmpBuExcelExportVO> getEmpBuExportByParam(List<Long> empIds, OrgEmpPagingParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(this.orgEmpBu.empId.in(empIds));
        if (null != param.getEmpBuId()) {
            predicates.add(this.orgEmpBu.empBuId.eq((Object)param.getEmpBuId()));
            if (StringUtils.isNotBlank((CharSequence)param.getEmpBuTreeCode())) {
                predicates.add(this.orgEmpBu.empBuTreeCode.eq((Object)param.getEmpBuTreeCode()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBuNameCode())) {
            String likeStr = "%" + param.getBuNameCode() + "%";
            List empIdList = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.orgEmpBu.empId).from((EntityPath)this.orgEmpBu)).leftJoin((EntityPath)this.orgBu)).on((Predicate)this.orgEmpBu.empBuId.eq(this.orgBu.id))).where((Predicate)this.orgBu.buName.like(likeStr).or((Predicate)this.orgBu.buCode.like(likeStr)))).fetch().stream().distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(empIdList)) {
                predicates.add(this.orgEmp.id.in(empIdList));
            } else {
                predicates.clear();
            }
        }
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgEmpBuExcelExportVO.class, (Expression[])new Expression[]{this.orgEmpBu.empId, this.orgEmpBu.empBuTreeCode.as("buTreeCode"), this.orgEmpBu.empBuId})).from((EntityPath)this.orgEmpBu)).where(ExpressionUtils.allOf(predicates));
        return query.fetch();
    }

    public PagingVO<OrgEmpBuExcelExportVO> getEmpBuExportByParam(OrgEmpPagingParam param) {
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (null != param.getEmpBuId()) {
            predicates.add(this.orgEmpBu.empBuId.eq((Object)param.getEmpBuId()));
            if (StringUtils.isNotBlank((CharSequence)param.getEmpBuTreeCode())) {
                predicates.add(this.orgEmpBu.empBuTreeCode.eq((Object)param.getEmpBuTreeCode()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBuNameCode())) {
            String string = "%" + param.getBuNameCode() + "%";
            List empIdList = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.orgEmpBu.empId).from((EntityPath)this.orgEmpBu)).leftJoin((EntityPath)this.orgBu)).on((Predicate)this.orgEmpBu.empBuId.eq(this.orgBu.id))).where((Predicate)this.orgBu.buName.like(string).or((Predicate)this.orgBu.buCode.like(string)))).fetch().stream().distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(empIdList)) {
                predicates.add(this.orgEmp.id.in(empIdList));
            } else {
                predicates.clear();
            }
        }
        if (!StringUtils.isBlank((CharSequence)param.getEmpCodeName())) {
            String string = "%" + param.getEmpCodeName() + "%";
            predicates.add(this.orgEmp.empCode.like(string).or((Predicate)this.orgEmp.empName.like(string)));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getEmpType())) {
            for (String type : param.getEmpType().split(",")) {
                predicates.add(Expressions.booleanTemplate((String)"FIND_IN_SET({0}, {1}) > 0", (Object[])new Object[]{type, this.orgEmp.empType}));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)param.getUserName())) {
            String string = "%" + param.getUserName() + "%";
            predicates.add(this.orgEmp.userName.like(string));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getEmpStatus())) {
            predicates.add(this.orgEmp.empStatus.eq((Object)param.getEmpStatus()));
        }
        predicates.add(this.orgEmp.deleteFlag.isNull().or((Predicate)this.orgEmp.deleteFlag.eq((Object)0)));
        JPAQuery jPAQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgEmpBuExcelExportVO.class, (Expression[])new Expression[]{this.orgEmp.id.as("empId"), this.orgEmp.empCode, this.orgEmp.empName, this.orgEmp.empGender, this.orgEmp.empType, this.orgEmp.birthDate, this.orgEmp.idType, this.orgEmp.idNo, this.orgEmp.userName, this.orgEmp.mobile, this.orgEmp.email, this.orgEmpBu.empId, this.orgEmpBu.empBuTreeCode.as("buTreeCode"), this.orgEmpBu.empBuId})).from((EntityPath)this.orgEmpBu)).where(ExpressionUtils.allOf(predicates));
        jPAQuery.where(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.orgEmp.getMetadata()));
        param.fillOrders(jPAQuery, this.orgEmp);
        param.setPaging(jPAQuery);
        return PagingVO.builder().total(Long.valueOf(jPAQuery.fetchCount())).records(jPAQuery.fetch()).build();
    }

    public OrgEmpExcelRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

