/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.excel.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.excel.entity.ErrorInfo;
import com.elitesland.yst.supportdomain.org.convert.OrgEmpExcelConvert;
import com.elitesland.yst.supportdomain.org.dto.OrgBuDTO;
import com.elitesland.yst.supportdomain.org.excel.entity.OrgEmpExcelSystemExport;
import com.elitesland.yst.supportdomain.org.excel.entity.OrgEmpUploadExcel;
import com.elitesland.yst.supportdomain.org.excel.listener.OrgEmpListener;
import com.elitesland.yst.supportdomain.org.excel.repo.OrgEmpExcelRepoProc;
import com.elitesland.yst.supportdomain.org.excel.service.OrgEmpExcelService;
import com.elitesland.yst.supportdomain.org.excel.vo.OrgEmpBuExcelExportVO;
import com.elitesland.yst.supportdomain.org.excel.vo.OrgEmpExcelExportVO;
import com.elitesland.yst.supportdomain.org.param.OrgBuDtoParam;
import com.elitesland.yst.supportdomain.org.param.OrgEmpPagingParam;
import com.elitesland.yst.supportdomain.org.repo.OrgAddrRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepoProc;
import com.elitesland.yst.supportdomain.org.repo.OrgEmpBuRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgEmpRepo;
import com.elitesland.yst.system.provider.SysUserRpcService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OrgEmpExcelServiceImpl
implements OrgEmpExcelService {
    private static final Logger log = LoggerFactory.getLogger(OrgEmpExcelServiceImpl.class);
    private final OrgEmpExcelRepoProc orgEmpExcelRepoProc;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final OrgEmpRepo orgEmpRepo;
    private final OrgEmpBuRepo orgEmpBuRepo;
    private final OrgAddrRepo orgAddrRepo;
    private final OrgBuRepoProc orgBuRepoProc;
    @DubboReference
    private SysUserRpcService sysUserRpcService;
    private final UdcService sysUdcService;
    private final TaskExecutor taskExecutor;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void uploadExcel(MultipartFile file) {
        ExcelReader reader;
        ErrorInfo errorInfo = new ErrorInfo();
        try {
            reader = EasyExcel.read((InputStream)file.getInputStream()).build();
        }
        catch (IOException e) {
            throw new BusinessException("excel\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
        }
        ReadSheet sheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).head(OrgEmpUploadExcel.class)).headRowNumber(Integer.valueOf(6))).registerReadListener((ReadListener)new OrgEmpListener(errorInfo, this.orgEmpExcelRepoProc, this.orgEmpRepo, this.orgEmpBuRepo, this.orgAddrRepo, this.sysNumberGeneratorWrapper, this.sysUserRpcService, this.sysUdcService))).build();
        reader.read(new ReadSheet[]{sheet});
    }

    @Override
    public void exportExcel(OrgEmpPagingParam param, HttpServletResponse response) {
        Map<String, String> empTypeMap = this.sysUdcService.getCodeMap("ORG", "EMP_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> empGenderMap = this.sysUdcService.getCodeMap("ORG", "EMP_GENDER").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> empIdTypeMap = this.sysUdcService.getCodeMap("ORG", "EMP_ID_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        List<OrgEmpExcelExportVO> empExportByParam = this.orgEmpExcelRepoProc.getEmpExportByParam(param);
        CompletableFuture<Void> empTypeThread = CompletableFuture.runAsync(() -> {
            for (OrgEmpExcelExportVO orgEmpExcelExportVO : empExportByParam) {
                String empType = orgEmpExcelExportVO.getEmpType();
                List<String> empTypes = Arrays.asList(empType.split(","));
                orgEmpExcelExportVO.setEmpType(empTypes.stream().map(empTypeMap::get).collect(Collectors.joining(",")));
            }
        }, (Executor)this.taskExecutor);
        CompletableFuture<Void> empGenderThread = CompletableFuture.runAsync(() -> {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            for (OrgEmpExcelExportVO orgEmpExcelExportVO : empExportByParam) {
                orgEmpExcelExportVO.setEmpGender((String)empGenderMap.get(orgEmpExcelExportVO.getEmpGender()));
                LocalDateTime birthDate = orgEmpExcelExportVO.getBirthDate();
                if (null == birthDate) continue;
                orgEmpExcelExportVO.setBirthDateStr(df.format(birthDate));
            }
        }, (Executor)this.taskExecutor);
        CompletableFuture<Void> empIdTypeThread = CompletableFuture.runAsync(() -> {
            for (OrgEmpExcelExportVO orgEmpExcelExportVO : empExportByParam) {
                orgEmpExcelExportVO.setIdType((String)empIdTypeMap.get(orgEmpExcelExportVO.getIdType()));
            }
        }, (Executor)this.taskExecutor);
        Map<Long, List<OrgEmpExcelExportVO>> empExportMap = empExportByParam.stream().collect(Collectors.groupingBy(OrgEmpExcelExportVO::getId));
        CompletableFuture<List> empBuThread = CompletableFuture.supplyAsync(() -> {
            List<Long> empIds = empExportByParam.stream().map(OrgEmpExcelExportVO::getId).collect(Collectors.toList());
            List<OrgEmpBuExcelExportVO> empBuExportByParam = this.orgEmpExcelRepoProc.getEmpBuExportByParam(empIds, param);
            List<Long> buIds = empBuExportByParam.stream().map(OrgEmpBuExcelExportVO::getEmpBuId).collect(Collectors.toList());
            List<OrgBuDTO> buList = this.orgBuRepoProc.findDtoByParam(OrgBuDtoParam.builder().buIds(buIds).build());
            Map<Long, String> buNameMap = buList.stream().collect(Collectors.toMap(OrgBuDTO::getId, OrgBuDTO::getBuName));
            Map<Long, String> ouNameMap = buList.stream().collect(Collectors.toMap(OrgBuDTO::getId, OrgBuDTO::getOuName));
            Map<String, String> empBuMap = empBuExportByParam.stream().collect(Collectors.groupingBy(emp -> emp.getEmpId() + "-" + emp.getBuTreeCode())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, value -> ((List)value.getValue()).stream().map(ouBu -> {
                Long empBuId = ouBu.getEmpBuId();
                return (String)buNameMap.get(empBuId);
            }).collect(Collectors.joining(","))));
            Map<String, String> ouMap = empBuExportByParam.stream().collect(Collectors.groupingBy(emp -> emp.getEmpId() + "-" + emp.getBuTreeCode())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, value -> ((List)value.getValue()).stream().map(ouBu -> {
                Long empBuId = ouBu.getEmpBuId();
                return (String)ouNameMap.get(empBuId);
            }).distinct().collect(Collectors.joining(","))));
            ArrayList<OrgEmpBuExcelExportVO> result = new ArrayList<OrgEmpBuExcelExportVO>();
            for (Map.Entry<String, String> map : empBuMap.entrySet()) {
                String key = map.getKey();
                String value2 = map.getValue();
                String[] split = key.split("-");
                OrgEmpBuExcelExportVO orgEmpBuExcelExportVO = new OrgEmpBuExcelExportVO();
                orgEmpBuExcelExportVO.setEmpId(Long.valueOf(split[0]));
                orgEmpBuExcelExportVO.setBuTreeCode(split[1]);
                orgEmpBuExcelExportVO.setBuNames(value2);
                orgEmpBuExcelExportVO.setOuNames(ouMap.get(key));
                result.add(orgEmpBuExcelExportVO);
            }
            return result;
        }, (Executor)this.taskExecutor);
        empTypeThread.join();
        empGenderThread.join();
        empIdTypeThread.join();
        List empBuList = empBuThread.join();
        for (OrgEmpBuExcelExportVO orgEmpBuExcelExportVO : empBuList) {
            Long empId = orgEmpBuExcelExportVO.getEmpId();
            List<OrgEmpExcelExportVO> orgEmpExcelExportVOS = empExportMap.get(empId);
            if (!CollectionUtils.isNotEmpty(orgEmpExcelExportVOS)) continue;
            OrgEmpExcelExportVO orgEmpExcelExportVO = orgEmpExcelExportVOS.get(0);
            OrgEmpExcelConvert.INSTANCE.updateEmpBuFromEmp(orgEmpBuExcelExportVO, orgEmpExcelExportVO);
        }
        WriteSheet empSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)0, (String)"\u5458\u5de5\u5bfc\u51fa").head(OrgEmpBuExcelExportVO.class)).build();
        ServletOutputStream outputStream = null;
        ExcelWriter excelWriter = null;
        IOException exception = null;
        try {
            response.setHeader("Content-disposition", "attachment;filename=\u5458\u5de5\u5bfc\u51fa.xlsx");
            response.setContentType("multipart/form-data");
            response.setCharacterEncoding("utf-8");
            outputStream = response.getOutputStream();
            excelWriter = EasyExcel.write((OutputStream)outputStream).build();
            excelWriter.write((Collection)empBuList, empSheet);
            outputStream.flush();
            excelWriter.finish();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BusinessException("\u4e0b\u8f7dexcel\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    exception = e;
                }
            }
        }
        if (null != exception) {
            throw new BusinessException("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25", (Throwable)exception);
        }
    }

    @Override
    public PagingVO<OrgEmpExcelSystemExport> getEmpExportData(OrgEmpPagingParam param) {
        Map<String, String> empTypeMap = this.sysUdcService.getCodeMap("ORG", "EMP_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> empGenderMap = this.sysUdcService.getCodeMap("ORG", "EMP_GENDER").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> empIdTypeMap = this.sysUdcService.getCodeMap("ORG", "EMP_ID_TYPE").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        PagingVO<OrgEmpBuExcelExportVO> empBuExportPaging = this.orgEmpExcelRepoProc.getEmpBuExportByParam(param);
        List empBuExportByParam = empBuExportPaging.getRecords();
        CompletableFuture<Void> empTypeThread = CompletableFuture.runAsync(() -> {
            for (OrgEmpBuExcelExportVO orgEmpExcelExportVO : empBuExportByParam) {
                String empType = orgEmpExcelExportVO.getEmpType();
                List<String> empTypes = Arrays.asList(empType.split(","));
                orgEmpExcelExportVO.setEmpType(empTypes.stream().map(empTypeMap::get).collect(Collectors.joining(",")));
            }
        }, (Executor)this.taskExecutor);
        CompletableFuture<Void> empGenderThread = CompletableFuture.runAsync(() -> {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            for (OrgEmpBuExcelExportVO orgEmpExcelExportVO : empBuExportByParam) {
                orgEmpExcelExportVO.setEmpGender((String)empGenderMap.get(orgEmpExcelExportVO.getEmpGender()));
                LocalDateTime birthDate = orgEmpExcelExportVO.getBirthDate();
                if (null == birthDate) continue;
                orgEmpExcelExportVO.setBirthDateStr(df.format(birthDate));
            }
        }, (Executor)this.taskExecutor);
        CompletableFuture<Void> empIdTypeThread = CompletableFuture.runAsync(() -> {
            for (OrgEmpBuExcelExportVO orgEmpExcelExportVO : empBuExportByParam) {
                orgEmpExcelExportVO.setIdType((String)empIdTypeMap.get(orgEmpExcelExportVO.getIdType()));
            }
        }, (Executor)this.taskExecutor);
        CompletableFuture<List> empBuThread = CompletableFuture.supplyAsync(() -> {
            List<Long> buIds = empBuExportByParam.stream().map(OrgEmpBuExcelExportVO::getEmpBuId).collect(Collectors.toList());
            List<OrgBuDTO> buList = this.orgBuRepoProc.findDtoByParam(OrgBuDtoParam.builder().buIds(buIds).build());
            Map<Long, String> buNameMap = buList.stream().collect(Collectors.toMap(OrgBuDTO::getId, OrgBuDTO::getBuName));
            Map<Long, String> ouNameMap = buList.stream().collect(Collectors.toMap(OrgBuDTO::getId, OrgBuDTO::getOuName));
            Map<String, String> empBuMap = empBuExportByParam.stream().collect(Collectors.groupingBy(emp -> emp.getEmpId() + "-" + emp.getBuTreeCode())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, value -> ((List)value.getValue()).stream().map(ouBu -> {
                Long empBuId = ouBu.getEmpBuId();
                return (String)buNameMap.get(empBuId);
            }).collect(Collectors.joining(","))));
            Map<String, String> ouMap = empBuExportByParam.stream().collect(Collectors.groupingBy(emp -> emp.getEmpId() + "-" + emp.getBuTreeCode())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, value -> ((List)value.getValue()).stream().map(ouBu -> {
                Long empBuId = ouBu.getEmpBuId();
                return (String)ouNameMap.get(empBuId);
            }).distinct().collect(Collectors.joining(","))));
            ArrayList<OrgEmpBuExcelExportVO> result = new ArrayList<OrgEmpBuExcelExportVO>();
            for (Map.Entry<String, String> map : empBuMap.entrySet()) {
                String key = map.getKey();
                String value2 = map.getValue();
                String[] split = key.split("-");
                OrgEmpBuExcelExportVO orgEmpBuExcelExportVO = new OrgEmpBuExcelExportVO();
                orgEmpBuExcelExportVO.setEmpId(Long.valueOf(split[0]));
                orgEmpBuExcelExportVO.setBuTreeCode(split[1]);
                orgEmpBuExcelExportVO.setBuNames(value2);
                orgEmpBuExcelExportVO.setOuNames(ouMap.get(key));
                result.add(orgEmpBuExcelExportVO);
            }
            return result;
        }, (Executor)this.taskExecutor);
        empTypeThread.join();
        empGenderThread.join();
        empIdTypeThread.join();
        List empBuList = empBuThread.join();
        return PagingVO.builder().total(empBuExportPaging.getTotal()).records(OrgEmpExcelConvert.INSTANCE.excelBuVOToExcelVO(empBuList)).build();
    }

    public OrgEmpExcelServiceImpl(OrgEmpExcelRepoProc orgEmpExcelRepoProc, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, OrgEmpRepo orgEmpRepo, OrgEmpBuRepo orgEmpBuRepo, OrgAddrRepo orgAddrRepo, OrgBuRepoProc orgBuRepoProc, UdcService sysUdcService, TaskExecutor taskExecutor) {
        this.orgEmpExcelRepoProc = orgEmpExcelRepoProc;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.orgEmpRepo = orgEmpRepo;
        this.orgEmpBuRepo = orgEmpBuRepo;
        this.orgAddrRepo = orgAddrRepo;
        this.orgBuRepoProc = orgBuRepoProc;
        this.sysUdcService = sysUdcService;
        this.taskExecutor = taskExecutor;
    }
}

