/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.provider;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.comm.consumer.dto.ComCityCodeRpcDTO;
import com.elitesland.yst.comm.consumer.dto.ComCurrRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComCityCodeRpcDtoParam;
import com.elitesland.yst.comm.consumer.param.ComCurrRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComCityCodeRpcService;
import com.elitesland.yst.comm.consumer.service.ComCurrRpcService;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.org.convert.OrgAddrConvert;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.elitesland.yst.supportdomain.org.param.OrgAddrBankAccSaveParam;
import com.elitesland.yst.supportdomain.org.provider.repo.OrgAddrRpcRepoProc;
import com.elitesland.yst.supportdomain.org.repo.OrgOuRepoProc;
import com.elitesland.yst.supportdomain.org.service.OrgAddrAddressService;
import com.elitesland.yst.supportdomain.org.service.OrgAddrBankAccService;
import com.elitesland.yst.supportdomain.org.service.OrgAddrService;
import com.elitesland.yst.supportdomain.org.vo.OrgOuVO;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgBankAccRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.param.OrgAddrAddressRpcUpdateParam;
import com.elitesland.yst.supportdomain.provider.org.param.OrgAddrBankAccRpcSaveParam;
import com.elitesland.yst.supportdomain.provider.org.param.OrgAddrRpcSaveParam;
import com.elitesland.yst.supportdomain.provider.org.param.OrgAddrUpdateThirdpartyByParam;
import com.elitesland.yst.supportdomain.provider.org.param.OrgAddressRpcDtoParam;
import com.elitesland.yst.supportdomain.provider.org.param.OrgBankAccRpcDtoParam;
import com.elitesland.yst.supportdomain.provider.org.service.OrgAddrRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@UnicomTag(value="GENERAL")
public class OrgAddrRpcServiceImpl
implements OrgAddrRpcService {
    private static final Long ZERO = 0L;
    private final OrgAddrService orgAddrService;
    private final OrgAddrAddressService orgAddrAddressService;
    private final OrgAddrBankAccService orgAddrBankAccService;
    @DubboReference
    private ComCityCodeRpcService comCityCodeRpcService;
    @DubboReference
    private ComCurrRpcService comCurrRpcService;
    private final OrgAddrRpcRepoProc orgAddrRpcRepoProc;
    private final OrgOuRepoProc orgOuRepoProc;

    public ApiResult<Long> orgAddrSaveOrUpdateReturnAddrNo(OrgAddrRpcSaveParam param) {
        try {
            Long result = this.orgAddrService.orgAddrSaveOrUpdateReturnAddrNo(OrgAddrConvert.INSTANCE.rpcSaveParamToSaveParam(param));
            return ApiResult.ok((Object)result);
        }
        catch (BusinessException be) {
            return ApiResult.fail((String)be.getMessage());
        }
        catch (RuntimeException re) {
            return ApiResult.fail((String)re.toString());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void orgAddrUpdateThirdpartyByParam(OrgAddrUpdateThirdpartyByParam param) {
        Long executeNum = this.orgAddrRpcRepoProc.orgAddrUpdateThirdpartyByParam(param);
        if (ZERO.equals(executeNum)) {
            throw new BusinessException("\u4f9b\u5e94\u5546\u65e0\u5bf9\u5e94\u94f6\u884c\u4fe1\u606f");
        }
        if (StringUtils.isNotBlank((CharSequence)param.getOuCode())) {
            List<OrgOuVO> addrNoByOuCode = this.orgOuRepoProc.findAddrNoByOuCode(param.getOuCode());
            if (CollectionUtils.isEmpty(addrNoByOuCode)) {
                throw new BusinessException("\u516c\u53f8\u7f16\u7801\uff1a" + param.getOuCode() + ";\u4e0d\u5b58\u5728\u5730\u5740\u53f7");
            }
            OrgOuVO orgOuVO = addrNoByOuCode.get(0);
            param.setAddrNo(orgOuVO.getAddrNo());
            param.setAccType(OrgUdcEnum.ADDR_BANKACC_TYPE_IN.getUdcVal());
            Long executeOuNum = this.orgAddrRpcRepoProc.orgAddrUpdateThirdpartyByParam(param);
            if (ZERO.equals(executeOuNum)) {
                throw new BusinessException("\u5185\u90e8\u4f9b\u5e94\u5546\u7ed1\u5b9a\u7684\u516c\u53f8\u65e0\u5bf9\u5e94\u94f6\u884c\u4fe1\u606f");
            }
        }
    }

    public ApiResult<OrgAddrDetailsRpcDTO> findRpcDtoByAddrNo(Long addrNo) {
        try {
            OrgAddrDetailsRpcDTO result = OrgAddrConvert.INSTANCE.voToRpcDTO(this.orgAddrService.searchDetailsByAddrNo(addrNo));
            return ApiResult.ok((Object)result);
        }
        catch (BusinessException be) {
            return ApiResult.fail((String)be.getMessage());
        }
        catch (RuntimeException re) {
            return ApiResult.fail((String)re.toString());
        }
    }

    public void softDeleteOrgAddrByAddrNo(Long addrNo) {
        this.orgAddrService.softDeleteAddrByAddrNo(addrNo);
    }

    public List<OrgAddressRpcDTO> findAddrAddressRpcDtoByParam(OrgAddressRpcDtoParam param) {
        List<OrgAddressRpcDTO> result = this.orgAddrRpcRepoProc.findAddressRpcDtoByParam(param);
        if (CollectionUtils.isNotEmpty(result)) {
            this.setAreaNames(result);
        }
        return result;
    }

    public List<OrgBankAccRpcDTO> findBankAccRpcDtoByParam(OrgBankAccRpcDtoParam param) {
        ComCurrRpcDtoParam currParam;
        List currDtos;
        List currCodes;
        List<OrgBankAccRpcDTO> result = this.orgAddrRpcRepoProc.findBankAccRpcDtoByParam(param);
        if (CollectionUtils.isNotEmpty(result) && CollectionUtils.isNotEmpty(currCodes = result.stream().map(OrgBankAccRpcDTO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && CollectionUtils.isNotEmpty((Collection)(currDtos = this.comCurrRpcService.findRpcDtoByParam(currParam = ComCurrRpcDtoParam.builder().currCodes(currCodes).build())))) {
            Map<String, String> currMap = currDtos.stream().collect(Collectors.toMap(ComCurrRpcDTO::getCurrCode, ComCurrRpcDTO::getCurrName));
            result.forEach(dto -> {
                if (StringUtils.isNotBlank((CharSequence)dto.getCurrCode())) {
                    dto.setCurrName((String)currMap.getOrDefault(dto.getCurrCode(), null));
                }
            });
        }
        return result;
    }

    public void softUpdateOrgAddrAddressByMobile(String mobile, String es7) {
        this.orgAddrAddressService.softUpdateAddrAddressByMobile(mobile, es7);
    }

    public void orgAddrAddressDetailsSaveOrUpdate(List<OrgAddrAddressRpcUpdateParam> params) {
        this.orgAddrAddressService.addrAddressDetailsSaveOrUpdate(params);
    }

    public Long orgAddraStatusCount(Long addrNo, String addrStatus) {
        return this.orgAddrService.orgAddraStatusCount(addrNo, addrStatus);
    }

    public Long updateOrgAddraddrStatus(Long addrNo, String addrStatus) {
        return this.orgAddrService.updateOrgAddraddrStatus(addrNo, addrStatus);
    }

    public void orgAddrBankAccHardRpcSave(Long addrNo, OrgAddrBankAccRpcSaveParam param) {
        ArrayList<OrgAddrBankAccSaveParam> params = new ArrayList<OrgAddrBankAccSaveParam>();
        OrgAddrBankAccSaveParam orgAddrBankAccSaveParam = new OrgAddrBankAccSaveParam();
        orgAddrBankAccSaveParam.setAccType(param.getAccType());
        orgAddrBankAccSaveParam.setDefaultFlag(true);
        orgAddrBankAccSaveParam.setBankName(param.getBankName());
        orgAddrBankAccSaveParam.setBranchName(param.getBranchName());
        orgAddrBankAccSaveParam.setBankAcc(param.getBankAcc());
        orgAddrBankAccSaveParam.setCurrCode(param.getCurrCode());
        params.add(orgAddrBankAccSaveParam);
        this.orgAddrBankAccService.orgAddrBankAccHardSave(addrNo, params);
    }

    private void setAreaNames(List<OrgAddressRpcDTO> addressVos) {
        ArrayList areaCodes = new ArrayList();
        addressVos.forEach(address -> {
            if (!StringUtils.isBlank((CharSequence)address.getProvince())) {
                areaCodes.add(address.getProvince());
            }
            if (!StringUtils.isBlank((CharSequence)address.getCity())) {
                areaCodes.add(address.getCity());
            }
            if (!StringUtils.isBlank((CharSequence)address.getCounty())) {
                areaCodes.add(address.getCounty());
            }
        });
        if (!CollectionUtils.isEmpty(areaCodes)) {
            List codes = areaCodes.stream().distinct().collect(Collectors.toList());
            ComCityCodeRpcDtoParam rpcParam = ComCityCodeRpcDtoParam.builder().areaCodes(codes).build();
            List cityCodes = this.comCityCodeRpcService.findRpcDtoByParam(rpcParam);
            if (!CollectionUtils.isEmpty((Collection)cityCodes)) {
                Map<String, ComCityCodeRpcDTO> cityMap = cityCodes.stream().collect(Collectors.toMap(ComCityCodeRpcDTO::getAreaCode, t -> t));
                addressVos.forEach(address -> {
                    if (!StringUtils.isBlank((CharSequence)address.getProvince()) && cityMap.containsKey(address.getProvince())) {
                        address.setProvinceName(((ComCityCodeRpcDTO)cityMap.get(address.getProvince())).getAreaName());
                    }
                    if (!StringUtils.isBlank((CharSequence)address.getCity()) && cityMap.containsKey(address.getCity())) {
                        address.setCityName(((ComCityCodeRpcDTO)cityMap.get(address.getCity())).getAreaName());
                    }
                    if (!StringUtils.isBlank((CharSequence)address.getCounty()) && cityMap.containsKey(address.getCounty())) {
                        address.setCountyName(((ComCityCodeRpcDTO)cityMap.get(address.getCounty())).getAreaName());
                    }
                });
            }
        }
    }

    public OrgAddrRpcServiceImpl(OrgAddrService orgAddrService, OrgAddrAddressService orgAddrAddressService, OrgAddrBankAccService orgAddrBankAccService, OrgAddrRpcRepoProc orgAddrRpcRepoProc, OrgOuRepoProc orgOuRepoProc) {
        this.orgAddrService = orgAddrService;
        this.orgAddrAddressService = orgAddrAddressService;
        this.orgAddrBankAccService = orgAddrBankAccService;
        this.orgAddrRpcRepoProc = orgAddrRpcRepoProc;
        this.orgOuRepoProc = orgOuRepoProc;
    }
}

