/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.provider;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.org.convert.OrgBuConvert;
import com.elitesland.yst.supportdomain.org.entity.OrgBuDO;
import com.elitesland.yst.supportdomain.org.entity.OrgEmpDO;
import com.elitesland.yst.supportdomain.org.provider.repo.OrgBuRpcRepoProc;
import com.elitesland.yst.supportdomain.org.repo.OrgEmpRepo;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import com.elitesland.yst.supportdomain.org.service.OrgBuTreeService;
import com.elitesland.yst.supportdomain.org.vo.OrgBuDetailsVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreeDVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreeDetailVO;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgBuDetailsRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.param.OrgBuRpcDtoParam;
import com.elitesland.yst.supportdomain.provider.org.param.OrgBuRpcSaveParam;
import com.elitesland.yst.supportdomain.provider.org.param.OrgBuRpcSaveResult;
import com.elitesland.yst.supportdomain.provider.org.service.OrgBuRpcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DubboService
@UnicomTag(value="GENERAL")
public class OrgBuRpcServiceImpl
implements OrgBuRpcService {
    private static final Logger log = LoggerFactory.getLogger(OrgBuRpcServiceImpl.class);
    private final UdcService sysUdcService;
    private final OrgBuService orgBuService;
    private final OrgBuTreeService orgBuTreeService;
    private final OrgEmpRepo orgEmpRepo;
    private final OrgBuRpcRepoProc orgBuRpcRepoProc;

    public List<Long> findBuIdsByUserId(Long userId) {
        Optional<OrgEmpDO> optional = this.orgEmpRepo.findByUserId(userId);
        if (optional.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getBuIdsByOrgEmp(optional.get());
    }

    public List<Long> findBuIdsByUsername(String username) {
        Optional<OrgEmpDO> optional = this.orgEmpRepo.findByUserName(username);
        if (optional.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getBuIdsByOrgEmp(optional.get());
    }

    public ApiResult<OrgBuRpcSaveResult> orgBuRpcSaveOrUpdate(OrgBuRpcSaveParam param) {
        try {
            OrgBuDO orgBuDo = this.orgBuService.saveOrUpdate(OrgBuConvert.INSTANCE.rpcSaveParamToSaveParam(param));
            OrgBuRpcSaveResult result = new OrgBuRpcSaveResult();
            result.setBuId(orgBuDo.getId());
            result.setBuCode(orgBuDo.getBuCode());
            result.setBuName(orgBuDo.getBuName());
            result.setAddrNo(orgBuDo.getAddrNo());
            return ApiResult.ok((Object)result);
        }
        catch (BusinessException be) {
            return ApiResult.fail((String)be.getMessage());
        }
    }

    public ApiResult<OrgBuDetailsRpcDTO> findDetailDtoById(Long id) {
        try {
            OrgBuDetailsVO orgBuDetailsVo = this.orgBuService.getOrgBuDetailsVOById(id);
            OrgBuDetailsRpcDTO result = OrgBuConvert.INSTANCE.detailsVoToRpcDetailsDto(orgBuDetailsVo);
            return ApiResult.ok((Object)result);
        }
        catch (RuntimeException re) {
            return ApiResult.fail((String)re.getMessage());
        }
    }

    public List<OrgBuRpcDTO> findBuDtoByParam(OrgBuRpcDtoParam param) {
        List<OrgBuRpcDTO> result = this.orgBuRpcRepoProc.findBuRpcDtoByParam(param);
        if (CollectionUtils.isNotEmpty(result)) {
            Map udcMap = this.sysUdcService.getCodeMap("ORG", "BU_TYPE");
            result.forEach(dto -> {
                String buTypeStr = dto.getBuType();
                if (StringUtils.isNotBlank((CharSequence)buTypeStr)) {
                    String buTypeNameStr = Arrays.stream(buTypeStr.split(",")).map(buType -> udcMap.getOrDefault(buType, "")).collect(Collectors.joining(","));
                    dto.setBuTypeName(buTypeNameStr);
                }
            });
        }
        return result;
    }

    private List<Long> getBuIdsByOrgEmp(OrgEmpDO orgEmpDO) {
        OrgBuTreeDetailVO orgBuTreeDetailVO;
        if (orgEmpDO.getEmpBuTreeId() == null || orgEmpDO.getEmpBuTreeId() == 0L || orgEmpDO.getEmpBuId() == null || orgEmpDO.getEmpBuId() == 0L) {
            log.error("Dubbo \u5bf9\u5916\u63a5\u53e3\u5f02\u5e38\uff0c\u83b7\u53d6\u7ec4\u7ec7\u6811\u8be6\u60c5\u5931\u8d25\uff0c\u5458\u5de5ID\uff1a" + orgEmpDO.getId() + ",\u5458\u5de5\u672a\u7ed1\u5b9a\u7ec4\u7ec7\u4fe1\u606f");
            return Collections.emptyList();
        }
        try {
            orgBuTreeDetailVO = this.orgBuTreeService.getOrgBuTreeDetailById(orgEmpDO.getEmpBuTreeId());
        }
        catch (Exception e) {
            log.error("Dubbo \u5bf9\u5916\u63a5\u53e3\u5f02\u5e38\uff0c\u83b7\u53d6\u7ec4\u7ec7\u6811\u8be6\u60c5\u5931\u8d25\uff0c\u5458\u5de5ID\uff1a" + orgEmpDO.getId() + "  \u7ec4\u7ec7\u6811ID\uff1a" + orgEmpDO.getEmpBuTreeId() + "  message\uff1a" + e.getMessage());
            return Collections.emptyList();
        }
        if (orgBuTreeDetailVO == null) {
            return Collections.emptyList();
        }
        List<OrgBuTreeDVO> buTree = orgBuTreeDetailVO.getOrgBuTreeDVOList();
        if (CollectionUtils.isEmpty(buTree)) {
            return Collections.emptyList();
        }
        OrgBuTreeDVO currentBuTree = this.findSubBuTree(orgEmpDO.getEmpBuTreeDId(), buTree);
        if (currentBuTree == null) {
            return Collections.emptyList();
        }
        ArrayList<Long> buIds = new ArrayList<Long>();
        this.buildBuIds(buIds, Collections.singletonList(currentBuTree));
        return buIds;
    }

    private OrgBuTreeDVO findSubBuTree(Long treeId, List<OrgBuTreeDVO> buTree) {
        Iterator<OrgBuTreeDVO> iterator = buTree.iterator();
        if (iterator.hasNext()) {
            OrgBuTreeDVO tree = iterator.next();
            if (tree.getId().equals(treeId)) {
                return tree;
            }
            if (tree.getIsLeaf().booleanValue()) {
                return null;
            }
            return this.findSubBuTree(treeId, tree.getTreeNodes());
        }
        return null;
    }

    private void buildBuIds(List<Long> buIds, List<OrgBuTreeDVO> buTree) {
        buTree.forEach(tree -> {
            buIds.add(tree.getBuId());
            if (tree.getIsLeaf().booleanValue()) {
                return;
            }
            this.buildBuIds(buIds, tree.getTreeNodes());
        });
    }

    public OrgBuRpcServiceImpl(UdcService sysUdcService, OrgBuService orgBuService, OrgBuTreeService orgBuTreeService, OrgEmpRepo orgEmpRepo, OrgBuRpcRepoProc orgBuRpcRepoProc) {
        this.sysUdcService = sysUdcService;
        this.orgBuService = orgBuService;
        this.orgBuTreeService = orgBuTreeService;
        this.orgEmpRepo = orgEmpRepo;
        this.orgBuRpcRepoProc = orgBuRpcRepoProc;
    }
}

