/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.provider;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.org.provider.repo.OrgEmpRpcRepoProc;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgEmpBuRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.param.OrgEmpRpcDtoParam;
import com.elitesland.yst.supportdomain.provider.org.param.OrgEmpUserRpcParam;
import com.elitesland.yst.supportdomain.provider.org.service.OrgEmpRpcService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@UnicomTag(value="GENERAL")
public class OrgEmpRpcServiceImpl
implements OrgEmpRpcService {
    private static final Logger log = LoggerFactory.getLogger(OrgEmpRpcServiceImpl.class);
    private final UdcService sysUdcService;
    private final OrgEmpRpcRepoProc orgEmpRpcRepoProc;

    public List<OrgEmpRpcDTO> findEmpDtoByParam(OrgEmpRpcDtoParam param) {
        List<OrgEmpRpcDTO> result = this.orgEmpRpcRepoProc.findEmpDtoByParam(param);
        if (CollectionUtils.isNotEmpty(result)) {
            Map udcMap = this.sysUdcService.getCodeMap("ORG", "EMP_TYPE");
            List<Long> empIds = result.stream().map(OrgEmpRpcDTO::getId).collect(Collectors.toList());
            List<OrgEmpBuRpcDTO> empBuRpcDto = this.orgEmpRpcRepoProc.findEmpBuRpcDtoByEmpIds(empIds);
            Map<Long, List<OrgEmpBuRpcDTO>> empBuMap = empBuRpcDto.stream().collect(Collectors.groupingBy(OrgEmpBuRpcDTO::getEmpId));
            result.forEach(dto -> {
                String empTypeStr = dto.getEmpType();
                if (StringUtils.isNotBlank((CharSequence)empTypeStr)) {
                    String empTypeNameStr = Arrays.stream(empTypeStr.split(",")).map(empType -> udcMap.getOrDefault(empType, "")).collect(Collectors.joining(","));
                    dto.setEmpTypeName(empTypeNameStr);
                }
                if (MapUtils.isNotEmpty((Map)empBuMap) && empBuMap.containsKey(dto.getId())) {
                    OrgEmpBuRpcDTO empBu = (OrgEmpBuRpcDTO)((List)empBuMap.get(dto.getId())).get(0);
                    dto.setBuId(empBu.getBuId());
                    dto.setBuCode(empBu.getBuCode());
                    dto.setBuName(empBu.getBuName());
                    dto.setOuCode(empBu.getOuCode());
                    dto.setOuName(empBu.getOuName());
                }
            });
        }
        return result;
    }

    public OrgUserEmpInfoRpcDTO findUserEmpInfo(Long userId) {
        List<OrgEmpBuRpcDTO> empBuList;
        OrgUserEmpInfoRpcDTO result = this.orgEmpRpcRepoProc.userEmpRpcInfo(userId);
        if (null == result) {
            return null;
        }
        Long empId = result.getEmpId();
        if (empId != null && CollectionUtils.isNotEmpty(empBuList = this.orgEmpRpcRepoProc.findEmpBuRpcDtoByEmpIds(Collections.singletonList(empId)))) {
            OrgEmpBuRpcDTO empBu = empBuList.get(0);
            result.setBuId(empBu.getBuId());
            result.setBuCode(empBu.getBuCode());
            result.setBuName(empBu.getBuName());
            result.setOuId(empBu.getOuId());
            result.setOuCode(empBu.getOuCode());
            result.setOuName(empBu.getOuName());
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public String userExportBindEmp(List<OrgEmpUserRpcParam> param) {
        log.debug("\u7528\u6237\u5bfc\u5165\uff0c\u5458\u5de5\u7ed1\u5b9a\u7528\u6237\u5f00\u59cb\uff0c\u53c2\u6570\u4e3a\uff1a{}", param);
        StringBuilder result = new StringBuilder();
        List empCodes = param.stream().map(OrgEmpUserRpcParam::getEmpCode).collect(Collectors.toList());
        Map<String, List<OrgEmpUserRpcParam>> empCodeMap = param.stream().collect(Collectors.groupingBy(OrgEmpUserRpcParam::getEmpCode));
        List<OrgEmpRpcDTO> empDtoByParam = this.orgEmpRpcRepoProc.findEmpDtoByParam(OrgEmpRpcDtoParam.builder().empCodes(empCodes).build());
        HashMap empDtoByParamMap = empDtoByParam.stream().collect(HashMap::new, (m, v) -> m.put(v.getEmpCode(), v.getUserName()), HashMap::putAll);
        ArrayList errorEmpCode = new ArrayList();
        empCodeMap.forEach((empCode, value) -> {
            if (value.size() > 1) {
                result.append(MessageFormat.format("\u5458\u5de5\u7f16\u7801:{0},\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\u7528\u6237;", empCode));
                errorEmpCode.add(empCode);
            } else if (StringUtils.isNotBlank((CharSequence)((CharSequence)empDtoByParamMap.get(empCode)))) {
                result.append(MessageFormat.format("\u5458\u5de5\u7f16\u7801:{0},\u5df2\u7ed1\u5b9a\u7528\u6237\uff1a{1};", empCode, empDtoByParamMap.get(empCode)));
                errorEmpCode.add(empCode);
            }
        });
        log.debug("\u7528\u6237\u5bfc\u5165\uff0c\u5458\u5de5\u7ed1\u5b9a\u7528\u6237,\u5b58\u5728\u95ee\u9898\u7684\u5458\u5de5\u7f16\u7801\uff1a{}", errorEmpCode);
        if (CollectionUtils.isNotEmpty(errorEmpCode)) {
            List<OrgEmpUserRpcParam> updateData = param.stream().filter(s -> !errorEmpCode.contains(s.getEmpCode())).collect(Collectors.toList());
            this.updateAndSync(updateData);
        } else {
            this.updateAndSync(param);
        }
        log.debug("\u7528\u6237\u5bfc\u5165\uff0c\u5458\u5de5\u7ed1\u5b9a\u7528\u6237,\u95ee\u9898\uff1a{}", (Object)result.toString());
        return result.toString();
    }

    private void updateAndSync(List<OrgEmpUserRpcParam> param) {
        if (CollectionUtils.isNotEmpty(param)) {
            for (OrgEmpUserRpcParam orgEmpUserRpcParam : param) {
                this.orgEmpRpcRepoProc.updateUserInfoByEmpCode(orgEmpUserRpcParam.getEmpCode(), orgEmpUserRpcParam.getUserName(), orgEmpUserRpcParam.getUserId());
            }
        }
    }

    public OrgEmpRpcServiceImpl(UdcService sysUdcService, OrgEmpRpcRepoProc orgEmpRpcRepoProc) {
        this.sysUdcService = sysUdcService;
        this.orgEmpRpcRepoProc = orgEmpRpcRepoProc;
    }
}

