/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.provider;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.org.entity.OrgEmpDO;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeVOParam;
import com.elitesland.yst.supportdomain.org.provider.repo.OrgUserEmpBuRpcRepoProc;
import com.elitesland.yst.supportdomain.org.repo.OrgEmpRepo;
import com.elitesland.yst.supportdomain.org.service.OrgBuTreeService;
import com.elitesland.yst.supportdomain.org.service.OrgBuTreeVersionService;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreeVO;
import com.elitesland.yst.supportdomain.org.vo.SystemBuTreeVO;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgOuUserRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgUserEmpBuDTO;
import com.elitesland.yst.supportdomain.provider.org.param.OrgOuUserRpcDtoParam;
import com.elitesland.yst.supportdomain.provider.org.param.OrgUserIdBuParam;
import com.elitesland.yst.supportdomain.provider.org.service.OrgUserEmpBuRpcService;
import com.elitesland.yst.supportdomain.util.SystemSettingNoEnum;
import com.querydsl.core.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
@UnicomTag(value="GENERAL")
public class OrgUserEmpBuRpcServiceImpl
implements OrgUserEmpBuRpcService {
    private final OrgEmpRepo orgEmpRepo;
    private final OrgUserEmpBuRpcRepoProc orgUserEmpBuRpcRepoProc;
    private final OrgBuTreeVersionService orgBuTreeVersionService;
    private final OrgBuTreeService orgBuTreeService;

    public ApiResult<OrgUserEmpBuDTO> findUserEmpBuInfoByUserId(Long userId) {
        List<Tuple> empBuInfos;
        Optional<OrgEmpDO> empOptional = this.orgEmpRepo.findByUserId(userId);
        if (empOptional.isEmpty()) {
            return ApiResult.ok();
        }
        OrgEmpDO emp = empOptional.get();
        OrgUserEmpBuDTO result = new OrgUserEmpBuDTO();
        result.setEmpId(emp.getId());
        result.setUserId(emp.getUserId());
        if (StringUtils.isNotBlank((CharSequence)emp.getCodePath())) {
            result.setEmpCodePath(emp.getCodePath());
            result.setChildEmpIds(this.orgUserEmpBuRpcRepoProc.findChildEmpIdsByPath(emp.getCodePath()));
        }
        if (CollectionUtils.isEmpty((Collection)result.getChildEmpIds())) {
            result.setChildEmpIds(Collections.singletonList(emp.getId()));
        }
        if (CollectionUtils.isNotEmpty(empBuInfos = this.orgUserEmpBuRpcRepoProc.findBuInfoByEmpId(emp.getId()))) {
            List empBuIds = empBuInfos.stream().map(info -> (Long)info.get(0, Long.class)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            result.setEmpBuIds(empBuIds);
            SystemBuTreeVO activeVersionByBuTreeCode = this.orgBuTreeVersionService.findActiveVersionByBuTreeCode(SystemSettingNoEnum.ORG_STRUCTURE_TREE.name());
            String buTreeCode = activeVersionByBuTreeCode.getBuTreeCode();
            String nowVersion = activeVersionByBuTreeCode.getVersion();
            List<OrgBuTreeVO> orgBuTreeVoByParam = this.orgBuTreeService.findOrgBuTreeVoByParam(OrgBuTreeVOParam.builder().buTreeCode(buTreeCode).nowVersion(nowVersion).build());
            if (CollectionUtils.isEmpty(orgBuTreeVoByParam)) {
                throw new BusinessException("\u65e0\u7b26\u5408\u7248\u672c\u7684\u7ec4\u7ec7\u6811\uff0c\u8bf7\u68c0\u67e5\u7cfb\u7edf\u914d\u7f6e");
            }
            Long empBuTreeId = orgBuTreeVoByParam.get(0).getId();
            result.setEmpBuTreeId(empBuTreeId);
            List empBuPath = empBuInfos.stream().map(info -> (String)info.get(2, String.class)).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            result.setEmpBuCodePath(empBuPath);
            List<String> empBuPathLike = empBuPath.stream().map(path -> path + "%").collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(empBuPathLike)) {
                List<Long> childBuIds = this.orgUserEmpBuRpcRepoProc.findChildBuIdsByCodePathLike(empBuTreeId, empBuPathLike);
                result.setChildEmpBuIds(childBuIds);
            }
            if (CollectionUtils.isEmpty((Collection)result.getChildEmpBuIds())) {
                result.setChildEmpBuIds(new ArrayList(empBuIds));
            }
        }
        return ApiResult.ok((Object)result);
    }

    public ApiResult<List<Long>> findUserIdsByParam(OrgUserIdBuParam param) {
        List<Long> ouIds = param.getOuIds() == null ? null : param.getOuIds().stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> buIds = param.getBuIds() == null ? null : param.getBuIds().stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> userIds = null;
        if (CollectionUtils.isNotEmpty(ouIds) && CollectionUtils.isNotEmpty(buIds)) {
            userIds = this.orgUserEmpBuRpcRepoProc.findUserIdsByOuIds(ouIds);
            List<Long> buUserIds = this.orgUserEmpBuRpcRepoProc.findUserIdsByBuIds(buIds);
            userIds.retainAll(buUserIds);
        } else {
            userIds = CollectionUtils.isNotEmpty(ouIds) ? this.orgUserEmpBuRpcRepoProc.findUserIdsByOuIds(ouIds) : (CollectionUtils.isNotEmpty(buIds) ? this.orgUserEmpBuRpcRepoProc.findUserIdsByBuIds(buIds) : Collections.emptyList());
        }
        return ApiResult.ok(userIds);
    }

    public List<OrgOuUserRpcDTO> findOuUserByParam(OrgOuUserRpcDtoParam param) {
        return this.orgUserEmpBuRpcRepoProc.findOuUserByParam(param);
    }

    public OrgUserEmpBuRpcServiceImpl(OrgEmpRepo orgEmpRepo, OrgUserEmpBuRpcRepoProc orgUserEmpBuRpcRepoProc, OrgBuTreeVersionService orgBuTreeVersionService, OrgBuTreeService orgBuTreeService) {
        this.orgEmpRepo = orgEmpRepo;
        this.orgUserEmpBuRpcRepoProc = orgUserEmpBuRpcRepoProc;
        this.orgBuTreeVersionService = orgBuTreeVersionService;
        this.orgBuTreeService = orgBuTreeService;
    }
}

