/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.provider.repo;

import com.elitesland.yst.supportdomain.org.entity.QOrgAddrAddressDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgBuDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgEmpBuDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgEmpDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgOuDO;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgEmpBuRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.param.OrgEmpRpcDtoParam;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class OrgEmpRpcRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QOrgEmpDO orgEmp = QOrgEmpDO.orgEmpDO;
    private final QOrgEmpBuDO orgEmpBu = QOrgEmpBuDO.orgEmpBuDO;
    private final QOrgBuDO orgBu = QOrgBuDO.orgBuDO;
    private final QOrgOuDO orgOu = QOrgOuDO.orgOuDO;
    private final QOrgAddrAddressDO orgAddrAddress = QOrgAddrAddressDO.orgAddrAddressDO;

    public List<OrgEmpRpcDTO> findEmpDtoByParam(OrgEmpRpcDtoParam param) {
        List userIds;
        List empCodes;
        List empIds;
        QOrgEmpDO pOrgEmp = new QOrgEmpDO("pOrgEmp");
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgEmpRpcDTO.class, (Expression[])new Expression[]{this.orgEmp.id, this.orgEmp.empCode, this.orgEmp.empName, this.orgEmp.empType, this.orgEmp.empStatus, this.orgEmp.userId, this.orgEmp.userName, this.orgEmp.addrNo, this.orgEmp.mobile, this.orgEmp.pid, pOrgEmp.userId.as("pidUserId"), pOrgEmp.userName.as("pidUserName")})).from((EntityPath)this.orgEmp)).leftJoin((EntityPath)pOrgEmp)).on((Predicate)pOrgEmp.id.eq(this.orgEmp.pid));
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (CollectionUtils.isNotEmpty((Collection)param.getEmpIds()) && CollectionUtils.isNotEmpty(empIds = param.getEmpIds().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            predicates.add(this.orgEmp.id.in(empIds));
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getEmpCodes()) && CollectionUtils.isNotEmpty(empCodes = param.getEmpCodes().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            predicates.add(this.orgEmp.empCode.in(empCodes));
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getUserIds()) && CollectionUtils.isNotEmpty(userIds = param.getUserIds().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            predicates.add(this.orgEmp.userId.in(userIds));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getEmpType())) {
            predicates.add(ExpressionUtils.predicateTemplate((String)"FIND_IN_SET({0}, {1}) > 0", (Object[])new Object[]{param.getEmpType(), this.orgEmp.empType}));
        }
        if (predicates.isEmpty()) {
            return Collections.emptyList();
        }
        predicates.add(this.orgEmp.deleteFlag.isNull().or((Predicate)this.orgEmp.deleteFlag.eq((Object)0)));
        query.where(ExpressionUtils.allOf(predicates));
        return query.fetch();
    }

    public List<OrgEmpBuRpcDTO> findEmpBuRpcDtoByEmpIds(List<Long> empIds) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgEmpBuRpcDTO.class, (Expression[])new Expression[]{this.orgEmpBu.empId, this.orgBu.id.as("buId"), this.orgBu.buCode, this.orgBu.buName, this.orgOu.id.as("ouId"), this.orgOu.ouCode, this.orgOu.ouName, this.orgOu.ouCurr.as("currCode")})).from((EntityPath)this.orgEmpBu)).innerJoin((EntityPath)this.orgBu)).on((Predicate)this.orgBu.id.eq(this.orgEmpBu.empBuId))).innerJoin((EntityPath)this.orgOu)).on((Predicate)this.orgOu.id.eq(this.orgBu.ouId))).where((Predicate)this.orgEmpBu.empId.in(empIds))).where((Predicate)this.orgEmpBu.deleteFlag.isNull().or((Predicate)this.orgEmpBu.deleteFlag.eq((Object)0)))).fetch();
    }

    public OrgUserEmpInfoRpcDTO userEmpRpcInfo(Long userId) {
        return (OrgUserEmpInfoRpcDTO)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgUserEmpInfoRpcDTO.class, (Expression[])new Expression[]{this.orgEmp.userId, this.orgEmp.userName, this.orgEmp.id.as("empId"), this.orgEmp.empCode, this.orgEmp.empName, this.orgEmp.addrNo, this.orgAddrAddress.contPerson, this.orgAddrAddress.mobile, this.orgAddrAddress.tel, this.orgAddrAddress.fax, this.orgAddrAddress.email})).from((EntityPath)this.orgEmp)).leftJoin((EntityPath)this.orgAddrAddress)).on((Predicate)this.orgAddrAddress.addrNo.eq(this.orgEmp.addrNo).and((Predicate)this.orgAddrAddress.addressType.eq((Object)OrgUdcEnum.ADDRESS_TYPE_DEFAULT.getUdcVal())).and((Predicate)this.orgAddrAddress.defaultFlag.eq(Boolean.valueOf(true))).and((Predicate)this.orgAddrAddress.deleteFlag.isNull().or((Predicate)this.orgAddrAddress.deleteFlag.eq((Object)0))))).where((Predicate)this.orgEmp.userId.eq((Object)userId))).fetchOne();
    }

    public void updateUserInfoByEmpCode(String empCode, String userName, Long userId) {
        this.jpaQueryFactory.update((EntityPath)this.orgEmp).set(this.orgEmp.userId, (Object)userId).set((Path)this.orgEmp.userName, (Object)userName).where(new Predicate[]{this.orgEmp.empCode.eq((Object)empCode)}).execute();
    }

    public List<Long> getEmpIdByEmpCode(List<String> empCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.orgEmp.id).from((EntityPath)this.orgEmp)).where((Predicate)this.orgEmp.empCode.in(empCodes))).fetch();
    }

    public OrgEmpRpcRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

