/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.provider.repo;

import com.elitesland.yst.supportdomain.org.entity.QOrgBuDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgBuTreeDDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgEmpBuDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgEmpDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgOuDO;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgOuUserRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.param.OrgOuUserRpcDtoParam;
import com.elitesland.yst.supportdomain.util.UtilEnum;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class OrgUserEmpBuRpcRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QOrgEmpDO orgEmpDO = QOrgEmpDO.orgEmpDO;
    private final QOrgEmpBuDO orgEmpBuDO = QOrgEmpBuDO.orgEmpBuDO;
    private final QOrgBuTreeDDO orgBuTreeDDO = QOrgBuTreeDDO.orgBuTreeDDO;
    private final QOrgOuDO orgOuDO = QOrgOuDO.orgOuDO;
    private final QOrgBuDO orgBuDO = QOrgBuDO.orgBuDO;

    public List<Long> findChildEmpIdsByPath(String path) {
        String pathLike = path + "%";
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.orgEmpDO.id).from((EntityPath)this.orgEmpDO)).where((Predicate)this.orgEmpDO.codePath.like(pathLike))).fetch();
    }

    public List<Tuple> findBuInfoByEmpId(Long empId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.orgEmpBuDO.empBuId, this.orgEmpBuDO.empBuTreeId, this.orgBuTreeDDO.codePath}).from((EntityPath)this.orgEmpBuDO)).innerJoin((EntityPath)this.orgBuTreeDDO)).on((Predicate)this.orgBuTreeDDO.buTreeId.eq(this.orgEmpBuDO.empBuTreeId).and((Predicate)this.orgBuTreeDDO.id.eq(this.orgEmpBuDO.empBuTreeDId)))).where((Predicate)this.orgEmpBuDO.empId.eq((Object)empId).and((Predicate)this.orgEmpBuDO.empBuTreeCode.eq((Object)UtilEnum.BU_ORG_HSHORGTREE.getValue())))).fetch();
    }

    public List<Long> findChildBuIdsByCodePathLike(Long buTreeId, List<String> codePathLike) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct(this.orgBuTreeDDO.buId).from((EntityPath)this.orgBuTreeDDO)).where((Predicate)this.orgBuTreeDDO.buTreeId.eq((Object)buTreeId));
        ArrayList predicates = new ArrayList();
        codePathLike.forEach(pathLike -> predicates.add(this.orgBuTreeDDO.codePath.like(pathLike)));
        query.where(ExpressionUtils.anyOf(predicates));
        return query.fetch();
    }

    public List<Long> findUserIdsByOuIds(List<Long> ouIds) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct(this.orgEmpDO.userId).from((EntityPath)this.orgOuDO)).innerJoin((EntityPath)this.orgBuDO)).on((Predicate)this.orgBuDO.ouId.eq(this.orgOuDO.id))).innerJoin((EntityPath)this.orgEmpBuDO)).on((Predicate)this.orgEmpBuDO.empBuId.eq(this.orgBuDO.id))).innerJoin((EntityPath)this.orgEmpDO)).on((Predicate)this.orgEmpDO.id.eq(this.orgEmpBuDO.empId).and((Predicate)this.orgEmpDO.userId.isNotNull()))).where((Predicate)this.orgOuDO.id.in(ouIds))).fetch();
    }

    public List<Long> findUserIdsByBuIds(List<Long> buIds) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct(this.orgEmpDO.userId).from((EntityPath)this.orgBuDO)).innerJoin((EntityPath)this.orgEmpBuDO)).on((Predicate)this.orgEmpBuDO.empBuId.eq(this.orgBuDO.id))).innerJoin((EntityPath)this.orgEmpDO)).on((Predicate)this.orgEmpDO.id.eq(this.orgEmpBuDO.empId).and((Predicate)this.orgEmpDO.userId.isNotNull()))).where((Predicate)this.orgBuDO.id.in(buIds))).fetch();
    }

    public List<OrgOuUserRpcDTO> findOuUserByParam(OrgOuUserRpcDtoParam param) {
        List ouCodes;
        List ouIds;
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)Projections.bean(OrgOuUserRpcDTO.class, (Expression[])new Expression[]{this.orgEmpDO.userId, this.orgEmpDO.userName, this.orgEmpDO.id.as("empId"), this.orgEmpDO.empName, this.orgEmpDO.empCode})).from((EntityPath)this.orgOuDO)).innerJoin((EntityPath)this.orgBuDO)).on((Predicate)this.orgBuDO.ouId.eq(this.orgOuDO.id))).innerJoin((EntityPath)this.orgEmpBuDO)).on((Predicate)this.orgEmpBuDO.empBuId.eq(this.orgBuDO.id))).innerJoin((EntityPath)this.orgEmpDO)).on((Predicate)this.orgEmpDO.id.eq(this.orgEmpBuDO.empId).and((Predicate)this.orgEmpDO.userId.isNotNull()));
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty((Collection)param.getOuIds()) && CollectionUtils.isNotEmpty(ouIds = param.getOuIds().stream().distinct().filter(Objects::nonNull).collect(Collectors.toList()))) {
            predicates.add(this.orgOuDO.id.in(ouIds));
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getOuCodes()) && CollectionUtils.isNotEmpty(ouCodes = param.getOuCodes().stream().distinct().filter(Objects::nonNull).collect(Collectors.toList()))) {
            predicates.add(this.orgOuDO.ouCode.in(ouCodes));
        }
        if (CollectionUtils.isNotEmpty(predicates)) {
            query.where(ExpressionUtils.allOf(predicates));
        }
        return query.fetch();
    }

    public OrgUserEmpBuRpcRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

