/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.org.entity.QOrgAddrDO;
import com.elitesland.yst.supportdomain.org.param.OrgAddrPagingParam;
import com.elitesland.yst.supportdomain.org.vo.OrgAddrDetailVO;
import com.elitesland.yst.supportdomain.org.vo.OrgAddrPagingVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class OrgAddrRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QOrgAddrDO orgAddr = QOrgAddrDO.orgAddrDO;
    private final Path<?>[] detailColumns;
    private final QBean<OrgAddrDetailVO> orgAddrDetailVOQBean;
    private final QBean<OrgAddrPagingVO> orgAddrPagingVOQBean;

    public PagingVO<OrgAddrPagingVO> searchPaging(OrgAddrPagingParam param) {
        String likeStr;
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select(this.orgAddrPagingVOQBean).from((EntityPath)this.orgAddr);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isBlank((CharSequence)param.getAddrNo())) {
            likeStr = "%" + param.getAddrNo() + "%";
            predicates.add(this.orgAddr.addrNo.like(likeStr));
        }
        if (!StringUtils.isBlank((CharSequence)param.getAddrName())) {
            likeStr = "%" + param.getAddrName() + "%";
            predicates.add(this.orgAddr.addrName.like(likeStr));
        }
        if (!StringUtils.isBlank((CharSequence)param.getAddrType())) {
            predicates.add(this.orgAddr.addrType.eq((Object)param.getAddrType()));
        }
        predicates.add(this.orgAddr.deleteFlag.isNull().or((Predicate)this.orgAddr.deleteFlag.eq((Object)0)));
        query.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.orgAddr);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public OrgAddrDetailVO findDetailsById(Long id) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.orgAddrDetailVOQBean).from((EntityPath)this.orgAddr)).where((Predicate)this.orgAddr.id.eq((Object)id));
        return (OrgAddrDetailVO)query.fetchOne();
    }

    public OrgAddrDetailVO findDetailsByAddrNo(Long addrNo) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.orgAddrDetailVOQBean).from((EntityPath)this.orgAddr)).where((Predicate)this.orgAddr.addrNo.eq((Object)addrNo));
        return (OrgAddrDetailVO)query.fetchOne();
    }

    public void softDeleteById(Long id) {
        this.jpaQueryFactory.update((EntityPath)this.orgAddr).set(this.orgAddr.deleteFlag, (Object)1).where(new Predicate[]{this.orgAddr.id.eq((Object)id)}).execute();
    }

    public void softDeleteByAddrNo(Long addrNo) {
        this.jpaQueryFactory.update((EntityPath)this.orgAddr).set(this.orgAddr.deleteFlag, (Object)1).where(new Predicate[]{this.orgAddr.addrNo.eq((Object)addrNo)}).execute();
    }

    public Long orgAddraStatusCount(Long addrNo, String addrStatus) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.orgAddr.id).from((EntityPath)this.orgAddr)).where((Predicate)this.orgAddr.addrNo.eq((Object)addrNo).and((Predicate)this.orgAddr.addrStatus.eq((Object)addrStatus)))).fetchCount();
    }

    @Transactional
    public Long updateOrgAddraddrStatus(Long addrNo, String addrStatus) {
        return this.jpaQueryFactory.update((EntityPath)this.orgAddr).set((Path)this.orgAddr.addrStatus, (Object)addrStatus).where(new Predicate[]{this.orgAddr.addrNo.eq((Object)addrNo)}).execute();
    }

    public OrgAddrRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.detailColumns = new Path[]{this.orgAddr.id, this.orgAddr.addrNo, this.orgAddr.addrType, this.orgAddr.addrName};
        this.orgAddrDetailVOQBean = Projections.bean(OrgAddrDetailVO.class, this.detailColumns);
        this.orgAddrPagingVOQBean = Projections.bean(OrgAddrPagingVO.class, (Expression[])new Expression[]{this.orgAddr.id, this.orgAddr.addrNo, this.orgAddr.addrType, this.orgAddr.addrName, this.orgAddr.createUserId, this.orgAddr.creator.as("createUserName"), this.orgAddr.createTime});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

