/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.supportdomain.org.dto.OrgBuDTO;
import com.elitesland.yst.supportdomain.org.entity.OrgBuDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgAddrAddressDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgBuDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgBuTreeDDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgBuTreeDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgOuDO;
import com.elitesland.yst.supportdomain.org.param.OrgBuDtoParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuPagingParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuRelationOuParam;
import com.elitesland.yst.supportdomain.org.vo.OrgBuRelationOuVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class OrgBuRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QOrgBuDO orgBuDO = QOrgBuDO.orgBuDO;
    private final QOrgBuTreeDDO orgBuTreeDDO = QOrgBuTreeDDO.orgBuTreeDDO;
    private final QOrgBuTreeDO orgBuTreeDO = QOrgBuTreeDO.orgBuTreeDO;
    private final QOrgAddrAddressDO orgAddrAddress = QOrgAddrAddressDO.orgAddrAddressDO;
    private final QOrgOuDO orgOuDO = QOrgOuDO.orgOuDO;

    private JPAQuery<OrgBuVO> select() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuVO.class, (Expression[])new Expression[]{this.orgBuDO.id, this.orgBuDO.buCode, this.orgBuDO.buName, this.orgBuDO.buAbbr, this.orgOuDO.id.as("ouId"), this.orgOuDO.ouName, this.orgBuDO.buType, this.orgBuDO.buStatus, this.orgBuDO.costCentreCode, this.orgBuDO.costCentreName})).from((EntityPath)this.orgBuDO)).leftJoin((EntityPath)this.orgOuDO)).on((Predicate)this.orgBuDO.ouId.eq(this.orgOuDO.id));
    }

    private Predicate where(OrgBuPagingParam param) {
        String strLike = "%" + param.getBuCodeNameLike() + "%";
        BooleanExpression predicate = this.orgBuDO.deleteFlag.eq((Object)0).or((Predicate)this.orgBuDO.deleteFlag.isNull());
        predicate = StringUtils.isBlank((CharSequence)param.getOuId()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.orgBuDO.ouId.eq((Object)Long.valueOf(param.getOuId())));
        predicate = StringUtils.isBlank((CharSequence)param.getExceptBuType()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.orgBuDO.buType.notLike("%" + param.getExceptBuType() + "%"));
        predicate = StringUtils.isBlank((CharSequence)param.getBuType()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)ExpressionUtils.predicateTemplate((String)"FIND_IN_SET({0}, {1}) > 0", (Object[])new Object[]{param.getBuType(), this.orgBuDO.buType}));
        predicate = StringUtils.isBlank((CharSequence)param.getBuStatus()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.orgBuDO.buStatus.eq((Object)param.getBuStatus()));
        predicate = StringUtils.isBlank((CharSequence)param.getBuCodeNameLike()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.orgBuDO.buCode.like(strLike).or((Predicate)this.orgBuDO.buName.like(strLike)).or((Predicate)this.orgBuDO.buAbbr.like(strLike)));
        return predicate;
    }

    public PagingVO<OrgBuVO> searchByParams(OrgBuPagingParam param) {
        JPAQuery query = (JPAQuery)this.select().where(this.where(param));
        query.where(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.orgBuDO.getMetadata()));
        param.fillOrders(query, this.orgBuDO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public List<OrgBuDTO> findDtoByParam(OrgBuDtoParam param) {
        List buCodes;
        List buIds;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        List list = buIds = param.getBuIds() == null ? null : param.getBuIds().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(buIds)) {
            predicates.add(this.orgBuDO.id.in(buIds));
        }
        List list2 = buCodes = param.getBuCodes() == null ? null : param.getBuCodes().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(buCodes)) {
            predicates.add(this.orgBuDO.buCode.in(buCodes));
        }
        if (CollectionUtils.isEmpty(predicates)) {
            return Collections.emptyList();
        }
        predicates.add(this.orgBuDO.deleteFlag.isNull().or((Predicate)this.orgBuDO.deleteFlag.eq((Object)0)));
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuDTO.class, (Expression[])new Expression[]{this.orgBuDO.id, this.orgBuDO.buCode, this.orgBuDO.buName, this.orgBuDO.buType, this.orgOuDO.ouName})).from((EntityPath)this.orgBuDO)).leftJoin((EntityPath)this.orgOuDO)).on((Predicate)this.orgBuDO.ouId.eq(this.orgOuDO.id))).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public List<OrgBuDTO> findBuDtoByTreeCode(String buTreeCode) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuDTO.class, (Expression[])new Expression[]{this.orgBuDO.id, this.orgBuDO.buCode, this.orgBuDO.buName})).from((EntityPath)this.orgBuDO)).leftJoin((EntityPath)this.orgBuTreeDDO)).on((Predicate)this.orgBuDO.id.eq(this.orgBuTreeDDO.buId))).leftJoin((EntityPath)this.orgBuTreeDO)).on((Predicate)this.orgBuTreeDDO.buTreeId.eq(this.orgBuTreeDO.id))).where((Predicate)this.orgBuTreeDO.buTreeCode.eq((Object)buTreeCode))).fetch();
    }

    public List<OrgBuRelationOuVO> findBuRelationOuList(OrgBuRelationOuParam param) {
        List buCodes;
        List buIds;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty(param.getBuIds()) && CollectionUtils.isNotEmpty(buIds = param.getBuIds().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            predicates.add(this.orgBuDO.id.in(buIds));
        }
        if (CollectionUtils.isNotEmpty(param.getBuCodes()) && CollectionUtils.isNotEmpty(buCodes = param.getBuCodes().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            predicates.add(this.orgBuDO.buCode.in(buCodes));
        }
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuRelationOuVO.class, (Expression[])new Expression[]{this.orgBuDO.id, this.orgBuDO.buCode, this.orgBuDO.buName, this.orgBuDO.ouId, this.orgOuDO.ouCode, this.orgOuDO.ouName})).from((EntityPath)this.orgBuDO)).leftJoin((EntityPath)this.orgOuDO)).on((Predicate)this.orgOuDO.id.eq(this.orgBuDO.ouId))).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public List<OrgBuDO> findAllByBuCodes(List<String> buCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.orgBuDO).from((EntityPath)this.orgBuDO)).where((Predicate)this.orgBuDO.buCode.in(buCodes))).fetch();
    }

    public OrgBuRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

