/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.org.entity.OrgBuTreeDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgBuTreeDO;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreePagingParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeVListParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeVOParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeVPagingParam;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreeDetailVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreePagingVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreeVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class OrgBuTreeRepoProc {
    private static final String DRAFT = OrgUdcEnum.ORG_BUTREE_STATUS_DRAFT.getUdcVal();
    private static final String ACTIVE = OrgUdcEnum.ORG_BUTREE_STATUS_ACTIVE.getUdcVal();
    private final JPAQueryFactory jpaQueryFactory;
    private final QOrgBuTreeDO orgBuTreeDO = QOrgBuTreeDO.orgBuTreeDO;

    private JPAQuery<OrgBuTreePagingVO> select() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuTreePagingVO.class, (Expression[])new Expression[]{this.orgBuTreeDO.id, this.orgBuTreeDO.buTreeCode, this.orgBuTreeDO.buTreeName, this.orgBuTreeDO.buTreeType, this.orgBuTreeDO.buTreeStatus, this.orgBuTreeDO.nowVersion, this.orgBuTreeDO.createTime, this.orgBuTreeDO.creator, this.orgBuTreeDO.updater, this.orgBuTreeDO.modifyTime, this.orgBuTreeDO.versionInstruction})).from((EntityPath)this.orgBuTreeDO);
    }

    private Predicate where(OrgBuTreePagingParam param) {
        BooleanExpression predicate = this.orgBuTreeDO.deleteFlag.eq((Object)0).or((Predicate)this.orgBuTreeDO.deleteFlag.isNull());
        predicate = StringUtils.isBlank((CharSequence)param.getBuTreeCode()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.orgBuTreeDO.buTreeCode.like("%" + param.getBuTreeCode() + "%"));
        predicate = StringUtils.isBlank((CharSequence)param.getBuTreeName()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.orgBuTreeDO.buTreeName.like("%" + param.getBuTreeName() + "%"));
        predicate = StringUtils.isBlank((CharSequence)param.getBuTreeType()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.orgBuTreeDO.buTreeType.eq((Object)param.getBuTreeType()));
        predicate = StringUtils.isBlank((CharSequence)param.getBuTreeStatus()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.orgBuTreeDO.buTreeStatus.eq((Object)param.getBuTreeStatus()));
        return predicate;
    }

    public PagingVO<OrgBuTreePagingVO> searchByParams(OrgBuTreePagingParam param) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Predicate where = this.where(param);
        predicates.add(where);
        JPAQuery query = (JPAQuery)this.select().where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.orgBuTreeDO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    private Long getPagingNumByPredicate(List<Predicate> predicates) {
        List fetch = ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.orgBuTreeDO.id).from((EntityPath)this.orgBuTreeDO)).where(ExpressionUtils.allOf(predicates))).groupBy(new Expression[]{this.orgBuTreeDO.buTreeCode, this.orgBuTreeDO.buTreeStatus})).fetch();
        return fetch.size();
    }

    public OrgBuTreeDetailVO findBuTreeDetailById(Long id) {
        return (OrgBuTreeDetailVO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuTreeDetailVO.class, (Expression[])new Expression[]{this.orgBuTreeDO.id, this.orgBuTreeDO.buTreeType, this.orgBuTreeDO.buTreeStatus, this.orgBuTreeDO.buTreeCode, this.orgBuTreeDO.buTreeName, this.orgBuTreeDO.buTreeVersion, this.orgBuTreeDO.nowVersion, this.orgBuTreeDO.versionInstruction})).from((EntityPath)this.orgBuTreeDO)).where((Predicate)this.orgBuTreeDO.id.eq((Object)id))).fetchOne();
    }

    public void updateStatusByIds(List<Long> ids, String buTreeStatus) {
        this.jpaQueryFactory.update((EntityPath)this.orgBuTreeDO).set((Path)this.orgBuTreeDO.buTreeStatus, (Object)buTreeStatus).set((Path)this.orgBuTreeDO.isNowVersion, (Object)false).set(this.orgBuTreeDO.disableTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.orgBuTreeDO.id.in(ids)}).execute();
    }

    public List<String> getBuTreeVersionByBuTreeCode(String buTreeCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.orgBuTreeDO.nowVersion).from((EntityPath)this.orgBuTreeDO)).where((Predicate)this.orgBuTreeDO.buTreeCode.eq((Object)buTreeCode))).fetch();
    }

    public List<OrgBuTreeVO> getBuTreeListByBuTreeCode(OrgBuTreeVListParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getBuTreeCode())) {
            predicates.add(this.orgBuTreeDO.buTreeCode.eq((Object)param.getBuTreeCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getVersion())) {
            predicates.add(this.orgBuTreeDO.nowVersion.eq((Object)param.getVersion()));
        }
        if (null != param.getWhetherViewResumeData() && param.getWhetherViewResumeData().booleanValue()) {
            predicates.add(this.orgBuTreeDO.buTreeStatus.eq((Object)OrgUdcEnum.ORG_BUTREE_STATUS_ACTIVE.getUdcVal()).or((Predicate)this.orgBuTreeDO.buTreeStatus.eq((Object)OrgUdcEnum.ORG_BUTREE_STATUS_CLOSED.getUdcVal())));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuTreeVO.class, (Expression[])new Expression[]{this.orgBuTreeDO.id, this.orgBuTreeDO.buTreeCode, this.orgBuTreeDO.buTreeName, this.orgBuTreeDO.buTreeType, this.orgBuTreeDO.buTreeStatus, this.orgBuTreeDO.nowVersion, this.orgBuTreeDO.createTime, this.orgBuTreeDO.creator, this.orgBuTreeDO.releaseTime, this.orgBuTreeDO.releaseUser, this.orgBuTreeDO.isNowVersion, this.orgBuTreeDO.versionInstruction, this.orgBuTreeDO.disableTime})).from((EntityPath)this.orgBuTreeDO)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public List<OrgBuTreeDO> getNowActiveBuTree(String buTreeCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.orgBuTreeDO).from((EntityPath)this.orgBuTreeDO)).where((Predicate)this.orgBuTreeDO.buTreeCode.eq((Object)buTreeCode).and((Predicate)this.orgBuTreeDO.isNowVersion.eq(Boolean.valueOf(true))))).fetch();
    }

    public List<String> findActiveVersionByBuTreeCode(String buTreeCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.orgBuTreeDO.nowVersion).from((EntityPath)this.orgBuTreeDO)).where((Predicate)this.orgBuTreeDO.buTreeCode.eq((Object)buTreeCode).and((Predicate)this.orgBuTreeDO.isNowVersion.eq(Boolean.valueOf(true))))).fetch();
    }

    public List<OrgBuTreeVO> findOrgBuTreeVoByParam(OrgBuTreeVOParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getBuTreeCode())) {
            predicates.add(this.orgBuTreeDO.buTreeCode.eq((Object)param.getBuTreeCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getNowVersion())) {
            predicates.add(this.orgBuTreeDO.nowVersion.eq((Object)param.getNowVersion()));
        }
        if (CollectionUtils.isEmpty(predicates)) {
            return Collections.emptyList();
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuTreeVO.class, (Expression[])new Expression[]{this.orgBuTreeDO.id, this.orgBuTreeDO.buTreeCode, this.orgBuTreeDO.buTreeName, this.orgBuTreeDO.buTreeType, this.orgBuTreeDO.buTreeStatus, this.orgBuTreeDO.nowVersion, this.orgBuTreeDO.createTime, this.orgBuTreeDO.creator, this.orgBuTreeDO.releaseTime, this.orgBuTreeDO.releaseUser, this.orgBuTreeDO.isNowVersion, this.orgBuTreeDO.versionInstruction, this.orgBuTreeDO.disableTime})).from((EntityPath)this.orgBuTreeDO)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public PagingVO<OrgBuTreeVO> getBuTreePagingByParam(OrgBuTreeVPagingParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getBuTreeCode())) {
            predicates.add(this.orgBuTreeDO.buTreeCode.eq((Object)param.getBuTreeCode()));
        }
        predicates.add(this.orgBuTreeDO.buTreeStatus.eq((Object)OrgUdcEnum.ORG_BUTREE_STATUS_ACTIVE.getUdcVal()).or((Predicate)this.orgBuTreeDO.buTreeStatus.eq((Object)OrgUdcEnum.ORG_BUTREE_STATUS_CLOSED.getUdcVal())));
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuTreeVO.class, (Expression[])new Expression[]{this.orgBuTreeDO.id, this.orgBuTreeDO.buTreeCode, this.orgBuTreeDO.buTreeName, this.orgBuTreeDO.buTreeType, this.orgBuTreeDO.buTreeStatus, this.orgBuTreeDO.nowVersion, this.orgBuTreeDO.createTime, this.orgBuTreeDO.creator, this.orgBuTreeDO.releaseTime, this.orgBuTreeDO.releaseUser, this.orgBuTreeDO.isNowVersion, this.orgBuTreeDO.versionInstruction, this.orgBuTreeDO.disableTime})).from((EntityPath)this.orgBuTreeDO)).where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.orgBuTreeDO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public OrgBuTreeRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

