/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.supportdomain.org.entity.QOrgAddrAddressDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgBuDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgEmpBuDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgEmpDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgOuDO;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.elitesland.yst.supportdomain.org.param.OrgEmpPagingParam;
import com.elitesland.yst.supportdomain.org.vo.OrgEmpBuInfo;
import com.elitesland.yst.supportdomain.org.vo.OrgEmpDetailVO;
import com.elitesland.yst.supportdomain.org.vo.OrgEmpPagingVO;
import com.elitesland.yst.supportdomain.org.vo.OrgUserEmpInfoVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class OrgEmpRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QOrgEmpDO orgEmp = QOrgEmpDO.orgEmpDO;
    private final QOrgEmpBuDO orgEmpBu = QOrgEmpBuDO.orgEmpBuDO;
    private final QOrgBuDO orgBu = QOrgBuDO.orgBuDO;
    private final QOrgOuDO orgOu = QOrgOuDO.orgOuDO;
    private final QOrgAddrAddressDO orgAddrAddress = QOrgAddrAddressDO.orgAddrAddressDO;

    public PagingVO<OrgEmpPagingVO> searchPaging(OrgEmpPagingParam param) {
        String likeStr;
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgEmpPagingVO.class, (Expression[])new Expression[]{this.orgEmp.id, this.orgEmp.empCode, this.orgEmp.empName, this.orgEmp.empStatus, this.orgEmp.empType, this.orgEmp.userName})).from((EntityPath)this.orgEmp)).leftJoin((EntityPath)this.orgEmpBu)).on((Predicate)this.orgEmp.id.eq(this.orgEmpBu.empId));
        query.where(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.orgEmp.getMetadata()));
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isBlank((CharSequence)param.getEmpCodeName())) {
            likeStr = "%" + param.getEmpCodeName() + "%";
            predicates.add(this.orgEmp.empCode.like(likeStr).or((Predicate)this.orgEmp.empName.like(likeStr)));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getEmpType())) {
            predicates.add(this.orgEmp.empType.eq((Object)param.getEmpType()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getUserName())) {
            likeStr = "%" + param.getUserName() + "%";
            predicates.add(this.orgEmp.userName.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getEmpStatus())) {
            predicates.add(this.orgEmp.empStatus.eq((Object)param.getEmpStatus()));
        }
        predicates.add(this.orgEmp.deleteFlag.isNull().or((Predicate)this.orgEmp.deleteFlag.eq((Object)0)));
        if (null != param.getEmpBuId()) {
            predicates.add(this.orgEmpBu.empBuId.eq((Object)param.getEmpBuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBuNameCode())) {
            likeStr = "%" + param.getBuNameCode() + "%";
            List empIdList = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.orgEmpBu.empId).from((EntityPath)this.orgEmpBu)).leftJoin((EntityPath)this.orgBu)).on((Predicate)this.orgEmpBu.empBuId.eq(this.orgBu.id))).where((Predicate)this.orgBu.buName.like(likeStr).or((Predicate)this.orgBu.buCode.like(likeStr)))).fetch().stream().distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(empIdList)) {
                predicates.add(this.orgEmp.id.in(empIdList));
            } else {
                predicates.clear();
            }
        }
        if (CollectionUtils.isEmpty(predicates)) {
            return PagingVO.builder().total(Long.valueOf(0L)).build();
        }
        query.where(ExpressionUtils.allOf(predicates));
        query.where(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.orgEmp.getMetadata()));
        query.groupBy(new Expression[]{this.orgEmp.id, this.orgEmp.empCode, this.orgEmp.empName, this.orgEmp.empStatus, this.orgEmp.empType, this.orgEmp.userName, this.orgEmp.createTime});
        param.fillOrders(query, this.orgEmp);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public OrgEmpDetailVO getDetailById(Long id) {
        QOrgBuDO orgBu = QOrgBuDO.orgBuDO;
        QOrgEmpDO pOrgEmp = new QOrgEmpDO("pOrgEmp");
        return (OrgEmpDetailVO)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgEmpDetailVO.class, (Expression[])new Expression[]{this.orgEmp.id, this.orgEmp.empBuTreeId, this.orgEmp.empBuTreeDId, this.orgEmp.empBuId, this.orgEmp.pid, pOrgEmp.empCode.as("pEmpCode"), pOrgEmp.empName.as("pEmpName"), this.orgEmp.empCode, this.orgEmp.empName, this.orgEmp.empGender, this.orgEmp.empType, this.orgEmp.birthDate, this.orgEmp.idType, this.orgEmp.idNo, this.orgEmp.userId, this.orgEmp.userName, this.orgEmp.addrNo, this.orgEmp.mobile, this.orgEmp.email, this.orgEmp.dataSource, orgBu.buName.as("empBuName"), orgBu.buCode.as("empBuCode")})).from((EntityPath)this.orgEmp)).leftJoin((EntityPath)pOrgEmp)).on((Predicate)pOrgEmp.id.eq(this.orgEmp.pid))).leftJoin((EntityPath)orgBu)).on((Predicate)orgBu.id.eq(this.orgEmp.empBuId))).where((Predicate)this.orgEmp.id.eq((Object)id).and((Predicate)this.orgEmp.deleteFlag.isNull().or((Predicate)this.orgEmp.deleteFlag.eq((Object)0))))).fetchOne();
    }

    public OrgUserEmpInfoVO userEmpInfo(Long userId) {
        QOrgBuDO orgOuBu = new QOrgBuDO("orgOuBu");
        return (OrgUserEmpInfoVO)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgUserEmpInfoVO.class, (Expression[])new Expression[]{this.orgEmp.userId, this.orgEmp.userName, this.orgEmp.id.as("empId"), this.orgEmp.empCode, this.orgEmp.empName, this.orgBu.id.as("buId"), this.orgBu.buCode, this.orgBu.buName, this.orgOu.id.as("ouId"), this.orgOu.ouCode, this.orgOu.ouName, this.orgOu.ouCurr.as("currCode"), orgOuBu.id.as("ouBuId"), orgOuBu.buCode.as("ouBuCode"), orgOuBu.buName.as("ouBuName"), this.orgEmp.addrNo, this.orgEmp.mobile.as("empMobile"), this.orgAddrAddress.contPerson, this.orgAddrAddress.mobile, this.orgAddrAddress.tel, this.orgAddrAddress.fax, this.orgAddrAddress.email})).from((EntityPath)this.orgEmp)).leftJoin((EntityPath)this.orgBu)).on((Predicate)this.orgBu.id.eq(this.orgEmp.empBuId))).leftJoin((EntityPath)this.orgOu)).on((Predicate)this.orgOu.id.eq(this.orgBu.ouId))).leftJoin((EntityPath)orgOuBu)).on((Predicate)orgOuBu.id.eq(this.orgOu.buId))).leftJoin((EntityPath)this.orgAddrAddress)).on((Predicate)this.orgAddrAddress.addrNo.eq(this.orgEmp.addrNo).and((Predicate)this.orgAddrAddress.addressType.eq((Object)OrgUdcEnum.ADDRESS_TYPE_DEFAULT.getUdcVal())).and((Predicate)this.orgAddrAddress.defaultFlag.eq(Boolean.valueOf(true))).and((Predicate)this.orgAddrAddress.deleteFlag.isNull().or((Predicate)this.orgAddrAddress.deleteFlag.eq((Object)0))))).where((Predicate)this.orgEmp.userId.eq((Object)userId))).fetchOne();
    }

    public List<OrgEmpBuInfo> findUserEmpBuInfoByEmpId(Long empId) {
        QOrgBuDO orgOuBu = new QOrgBuDO("orgOuBu");
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgEmpBuInfo.class, (Expression[])new Expression[]{this.orgBu.id.as("buId"), this.orgBu.buCode, this.orgBu.buName, this.orgOu.id.as("ouId"), this.orgOu.ouCode, this.orgOu.ouName, this.orgOu.ouCurr.as("currCode"), orgOuBu.id.as("ouBuId"), orgOuBu.buCode.as("ouBuCode"), orgOuBu.buName.as("ouBuName")})).from((EntityPath)this.orgEmpBu)).leftJoin((EntityPath)this.orgBu)).on((Predicate)this.orgBu.id.eq(this.orgEmpBu.empBuId))).leftJoin((EntityPath)this.orgOu)).on((Predicate)this.orgOu.id.eq(this.orgBu.ouId))).leftJoin((EntityPath)orgOuBu)).on((Predicate)orgOuBu.id.eq(this.orgOu.buId))).where((Predicate)this.orgEmpBu.empId.eq((Object)empId))).fetch();
    }

    public OrgEmpRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

