/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.supportdomain.org.dto.OrgOuDTO;
import com.elitesland.yst.supportdomain.org.entity.QOrgAddrAddressDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgAddrBankAccDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgAddrDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgAddrQualifyDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgBuDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgOuDO;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.elitesland.yst.supportdomain.org.param.OrgOuPagingParam;
import com.elitesland.yst.supportdomain.org.vo.OrgAddrBankAccVO;
import com.elitesland.yst.supportdomain.org.vo.OrgOuVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class OrgOuRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QOrgOuDO orgOuDO = QOrgOuDO.orgOuDO;
    private final QOrgBuDO orgBuDO = QOrgBuDO.orgBuDO;
    private final QOrgAddrDO orgAddr = QOrgAddrDO.orgAddrDO;
    private final QOrgAddrAddressDO orgAddrAddress = QOrgAddrAddressDO.orgAddrAddressDO;
    private final QOrgAddrBankAccDO orgAddrBankAcc = QOrgAddrBankAccDO.orgAddrBankAccDO;
    private final QOrgAddrQualifyDO orgAddrQualify = QOrgAddrQualifyDO.orgAddrQualifyDO;

    private JPAQuery<OrgOuVO> select() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgOuVO.class, (Expression[])new Expression[]{this.orgOuDO.id, this.orgOuDO.ouCode, this.orgOuDO.ouName, this.orgOuDO.ouAbbr, this.orgOuDO.ouType, this.orgOuDO.ouStatus, this.orgOuDO.externalCode})).from((EntityPath)this.orgOuDO);
    }

    private Predicate where(OrgOuPagingParam param) {
        String strLike = "%" + param.getOuCodeNameLike() + "%";
        BooleanExpression predicate = this.orgOuDO.deleteFlag.eq((Object)0).or((Predicate)this.orgOuDO.deleteFlag.isNull());
        predicate = StringUtils.isBlank((CharSequence)param.getOuType()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.orgOuDO.ouType.eq((Object)param.getOuType()));
        predicate = StringUtils.isBlank((CharSequence)param.getOuCodeNameLike()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.orgOuDO.ouCode.like(strLike).or((Predicate)this.orgOuDO.ouName.like(strLike)).or((Predicate)this.orgOuDO.ouAbbr.like(strLike)));
        return predicate;
    }

    public PagingVO<OrgOuVO> searchByParams(OrgOuPagingParam param) {
        JPAQuery query = (JPAQuery)this.select().where(this.where(param));
        query.where(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.orgOuDO.getMetadata()));
        param.fillOrders(query, this.orgOuDO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public List<OrgOuDTO> findAllOuDto() {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgOuDTO.class, (Expression[])new Expression[]{this.orgOuDO.id, this.orgOuDO.ouCode, this.orgOuDO.ouName, this.orgOuDO.ouCurr.as("currCode"), this.orgBuDO.id.as("buId"), this.orgBuDO.buCode, this.orgBuDO.buName})).from((EntityPath)this.orgOuDO)).innerJoin((EntityPath)this.orgBuDO)).on((Predicate)this.orgBuDO.id.eq(this.orgOuDO.buId))).where((Predicate)this.orgOuDO.deleteFlag.isNull().or((Predicate)this.orgOuDO.deleteFlag.eq((Object)0)))).fetch();
    }

    public List<OrgAddrBankAccVO> kycFindOuBankAccById(Long id) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgAddrBankAccVO.class, (Expression[])new Expression[]{this.orgAddrBankAcc.accType, this.orgAddrBankAcc.bankName, this.orgAddrBankAcc.branchName, this.orgAddrBankAcc.bankAcc, this.orgAddrBankAcc.bankAccountName, this.orgAddrBankAcc.thirdpartyVirtualUserId, this.orgAddrBankAcc.thirdpartyVirtualAcc, this.orgAddrBankAcc.holderName})).from((EntityPath)this.orgAddrBankAcc)).innerJoin((EntityPath)this.orgOuDO)).on((Predicate)this.orgAddrBankAcc.addrNo.eq(this.orgOuDO.addrNo))).where((Predicate)this.orgOuDO.id.eq((Object)id))).fetch();
    }

    public Set<String> findExistCode(Set<String> ouCodeSet) {
        return new HashSet<String>(((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.orgOuDO.ouCode).from((EntityPath)this.orgOuDO)).where((Predicate)this.orgOuDO.ouCode.in(ouCodeSet))).fetch());
    }

    public List<Long> filterOrgForTw(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.orgOuDO.id).from((EntityPath)this.orgOuDO)).where((Predicate)this.orgOuDO.id.in(ids).and((Predicate)this.orgOuDO.ouType.in((Object[])new String[]{"10", "30"})))).fetch();
    }

    public List<OrgOuVO> findAddrNoByOuCode(String ouCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgOuVO.class, (Expression[])new Expression[]{this.orgOuDO.id, this.orgOuDO.addrNo})).from((EntityPath)this.orgOuDO)).where((Predicate)this.orgOuDO.ouCode.eq((Object)ouCode))).fetch();
    }

    public List<Long> findExistUnEnableById(List<Long> dataIdList) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.orgOuDO.id).from((EntityPath)this.orgOuDO)).where((Predicate)this.orgOuDO.id.in(dataIdList).and((Predicate)this.orgOuDO.ouStatus.eq((Object)OrgUdcEnum.OU_STATUS_DRAFT.getUdcVal())))).fetch();
    }

    public OrgOuRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

