/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.supportdomain.org.entity.QOrgAddrAddressDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgBuDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgOuDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgStoreDO;
import com.elitesland.yst.supportdomain.org.param.OrgStorePagingParam;
import com.elitesland.yst.supportdomain.org.param.OrgStoreStatusParam;
import com.elitesland.yst.supportdomain.org.vo.OrgStorePagingVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class OrgStoreRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QOrgStoreDO orgStoreDO = QOrgStoreDO.orgStoreDO;
    private final QOrgBuDO orgBuDO = QOrgBuDO.orgBuDO;
    private final QOrgAddrAddressDO orgAddrAddress = QOrgAddrAddressDO.orgAddrAddressDO;
    private final QOrgOuDO orgOuDO = QOrgOuDO.orgOuDO;

    private JPAQuery<OrgStorePagingVO> select() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgStorePagingVO.class, (Expression[])new Expression[]{this.orgStoreDO.id, this.orgStoreDO.storeCode, this.orgStoreDO.storeName, this.orgStoreDO.storeType, this.orgStoreDO.storeStatus, this.orgStoreDO.openTimeSpan, this.orgBuDO.buName.as("pidName"), this.orgStoreDO.addrNo})).from((EntityPath)this.orgStoreDO)).leftJoin((EntityPath)this.orgBuDO)).on((Predicate)this.orgStoreDO.pid.eq(this.orgBuDO.id));
    }

    private Predicate where(OrgStorePagingParam param) {
        String strLike = "%" + param.getStoreCodeOrNameLike() + "%";
        BooleanExpression predicate = this.orgStoreDO.deleteFlag.eq((Object)0).or((Predicate)this.orgStoreDO.deleteFlag.isNull());
        predicate = StringUtils.isBlank((CharSequence)param.getStoreType()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.orgStoreDO.storeType.eq((Object)param.getStoreType()));
        predicate = param.getPId() == null || param.getPId() == 0L ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.orgStoreDO.pid.eq((Object)param.getPId()));
        predicate = StringUtils.isBlank((CharSequence)param.getStoreCodeOrNameLike()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.orgStoreDO.storeCode.like(strLike).or((Predicate)this.orgStoreDO.storeName.like(strLike)));
        return predicate;
    }

    public PagingVO<OrgStorePagingVO> searchByParams(OrgStorePagingParam param) {
        JPAQuery query = (JPAQuery)this.select().where(this.where(param));
        query.where(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.orgStoreDO.getMetadata()));
        param.fillOrders(query, this.orgStoreDO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public void statusUpdate(OrgStoreStatusParam param) {
        this.jpaQueryFactory.update((EntityPath)this.orgStoreDO).set((Path)this.orgStoreDO.storeStatus, (Object)param.getStoreStatus()).where(new Predicate[]{this.orgStoreDO.id.in(param.getIds())}).execute();
    }

    public OrgStoreRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

