/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.service.impl;

import com.elitesland.yst.comm.consumer.dto.ComCityCodeRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComCityCodeRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComCityCodeRpcService;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.supportdomain.org.convert.OrgAddrAddressConvert;
import com.elitesland.yst.supportdomain.org.entity.OrgAddrAddressDO;
import com.elitesland.yst.supportdomain.org.param.OrgAddrAddressSaveParam;
import com.elitesland.yst.supportdomain.org.repo.OrgAddrAddressRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgAddrAddressRepoProc;
import com.elitesland.yst.supportdomain.org.service.OrgAddrAddressService;
import com.elitesland.yst.supportdomain.org.vo.OrgAddrAddressVO;
import com.elitesland.yst.supportdomain.provider.org.param.OrgAddrAddressRpcUpdateParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgAddrAddressServiceImpl
implements OrgAddrAddressService {
    private static final Logger log = LoggerFactory.getLogger(OrgAddrAddressServiceImpl.class);
    @DubboReference
    private ComCityCodeRpcService comCityCodeRpcService;
    private final OrgAddrAddressRepo orgAddrAddressRepo;
    private final OrgAddrAddressRepoProc orgAddrAddressRepoProc;

    @Override
    @SysCodeProc
    public List<OrgAddrAddressVO> findByAddrNo(Long addrNo) {
        List<OrgAddrAddressVO> addressVos = this.orgAddrAddressRepoProc.findVoByAddrNo(addrNo);
        if (!CollectionUtils.isEmpty(addressVos)) {
            this.setAreaNames(addressVos);
        }
        return addressVos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void orgAddrAddressHardSave(Long addrNo, List<OrgAddrAddressSaveParam> params) {
        if (addrNo == null) {
            return;
        }
        this.orgAddrAddressRepo.deleteByAddrNo(addrNo);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<OrgAddrAddressDO> orgAddrAddressDos = OrgAddrAddressConvert.INSTANCE.saveParamToDo(params);
        orgAddrAddressDos.forEach(t -> t.setAddrNo(addrNo));
        this.orgAddrAddressRepo.saveAll(orgAddrAddressDos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void softUpdateAddrAddressByMobile(String mobile, String es7) {
        this.orgAddrAddressRepoProc.softUpdateAddressByMobile(mobile, es7);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addrAddressDetailsSaveOrUpdate(List<OrgAddrAddressRpcUpdateParam> params) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        log.info("\u652f\u6491\u57df\u3002\u3002\u3002\u8054\u7cfb\u4eba\u65b0\u589e\u6216\u4fee\u6539\u3002\u3002\u3002Start");
        params.stream().forEach(t -> {
            if (t.getBuId() == null) {
                OrgAddrAddressDO addressDO = new OrgAddrAddressDO();
                addressDO.setId(t.getId());
                addressDO.setAddrNo(t.getAddrNo());
                addressDO.setAddressType(t.getAddressType());
                addressDO.setBuId(t.getBuId());
                addressDO.setBuName(t.getBuName());
                addressDO.setContPerson(t.getContPerson());
                addressDO.setCreator(t.getCreateor());
                addressDO.setDefaultFlag(t.getDefaultFlag());
                addressDO.setEmail(t.getEmail());
                addressDO.setMobile(t.getMobile());
                addressDO.setRemark(t.getRemark());
                addressDO.setEs1(t.getEs1());
                addressDO.setEs2(t.getEs2());
                addressDO.setEs4(t.getEs4());
                addressDO.setEs6(t.getEs6());
                addressDO.setEs7(t.getEs7());
                this.orgAddrAddressRepo.save(addressDO);
            } else {
                this.orgAddrAddressRepoProc.updateAddrAddressDetail((OrgAddrAddressRpcUpdateParam)t);
            }
        });
        log.info("\u652f\u6491\u57df\u3002\u3002\u3002\u8054\u7cfb\u4eba\u65b0\u589e\u6216\u4fee\u6539\u3002\u3002\u3002End");
    }

    @Override
    public void setAreaNames(List<OrgAddrAddressVO> addressVos) {
        ComCityCodeRpcDtoParam rpcParam;
        List cityCodes;
        ArrayList areaCodes = new ArrayList();
        addressVos.forEach(address -> {
            if (!StringUtils.isBlank((CharSequence)address.getProvince())) {
                areaCodes.add(address.getProvince());
            }
            if (!StringUtils.isBlank((CharSequence)address.getCity())) {
                areaCodes.add(address.getCity());
            }
            if (!StringUtils.isBlank((CharSequence)address.getCounty())) {
                areaCodes.add(address.getCounty());
            }
        });
        if (!CollectionUtils.isEmpty(areaCodes) && !CollectionUtils.isEmpty((Collection)(cityCodes = this.comCityCodeRpcService.findRpcDtoByParam(rpcParam = ComCityCodeRpcDtoParam.builder().areaCodes(areaCodes).build())))) {
            Map<String, ComCityCodeRpcDTO> cityMap = cityCodes.stream().collect(Collectors.toMap(ComCityCodeRpcDTO::getAreaCode, t -> t));
            addressVos.forEach(address -> {
                if (!StringUtils.isBlank((CharSequence)address.getProvince()) && cityMap.containsKey(address.getProvince())) {
                    address.setProvinceName(((ComCityCodeRpcDTO)cityMap.get(address.getProvince())).getAreaName());
                }
                if (!StringUtils.isBlank((CharSequence)address.getCity()) && cityMap.containsKey(address.getCity())) {
                    address.setCityName(((ComCityCodeRpcDTO)cityMap.get(address.getCity())).getAreaName());
                }
                if (!StringUtils.isBlank((CharSequence)address.getCounty()) && cityMap.containsKey(address.getCounty())) {
                    address.setCountyName(((ComCityCodeRpcDTO)cityMap.get(address.getCounty())).getAreaName());
                }
            });
        }
    }

    public OrgAddrAddressServiceImpl(OrgAddrAddressRepo orgAddrAddressRepo, OrgAddrAddressRepoProc orgAddrAddressRepoProc) {
        this.orgAddrAddressRepo = orgAddrAddressRepo;
        this.orgAddrAddressRepoProc = orgAddrAddressRepoProc;
    }
}

