/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.service.impl;

import com.elitesland.yst.comm.consumer.dto.ComCurrRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComCurrRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComCurrRpcService;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.org.convert.OrgAddrBankAccConvert;
import com.elitesland.yst.supportdomain.org.entity.OrgAddrBankAccDO;
import com.elitesland.yst.supportdomain.org.param.OrgAddrBankAccSaveParam;
import com.elitesland.yst.supportdomain.org.repo.OrgAddrBankAccRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgAddrBankAccRepoProc;
import com.elitesland.yst.supportdomain.org.service.OrgAddrBankAccService;
import com.elitesland.yst.supportdomain.org.vo.OrgAddrBankAccVO;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgAddrBankAccServiceImpl
implements OrgAddrBankAccService {
    @DubboReference
    private ComCurrRpcService comCurrRpcService;
    private final OrgAddrBankAccRepo orgAddrBankAccRepo;
    private final OrgAddrBankAccRepoProc orgAddrBankAccRepoProc;

    @Override
    @SysCodeProc
    public List<OrgAddrBankAccVO> findByAddrNo(Long addrNo) {
        List<OrgAddrBankAccVO> addrBankAccVos = this.orgAddrBankAccRepoProc.findVoByAddrNo(addrNo);
        if (!CollectionUtils.isEmpty(addrBankAccVos)) {
            this.setCurrName(addrBankAccVos);
        }
        return addrBankAccVos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void orgAddrBankAccHardSave(Long addrNo, List<OrgAddrBankAccSaveParam> params) {
        if (null != addrNo && CollectionUtils.isNotEmpty(params)) {
            Map<String, List<OrgAddrBankAccSaveParam>> uniqueMap = params.stream().collect(Collectors.groupingBy(saveParam -> saveParam.getAccType() + "-" + saveParam.getBankAcc()));
            uniqueMap.forEach((key, value) -> {
                if (value.size() > 1) {
                    List<String> uniqueList = Arrays.asList(key.split("-"));
                    throw new BusinessException("\u540c\u4e00\u6536\u6b3e\u7c7b\u578b\u4e0b\uff0c\u4e0d\u5141\u8bb8\u51fa\u73b0\u76f8\u540c\u94f6\u884c\u8d26\u6237\uff1a" + uniqueList.get(1));
                }
            });
        }
        if (addrNo == null) {
            return;
        }
        this.orgAddrBankAccRepo.deleteByAddrNo(addrNo);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<OrgAddrBankAccDO> orgAddrBankAccDos = OrgAddrBankAccConvert.INSTANCE.saveParamToDo(params);
        orgAddrBankAccDos.forEach(t -> t.setAddrNo(addrNo));
        this.orgAddrBankAccRepo.saveAll(orgAddrBankAccDos);
    }

    private void setCurrName(List<OrgAddrBankAccVO> addrBankAccVos) {
        ComCurrRpcDtoParam rpcParam;
        List currency;
        List currCodes = addrBankAccVos.stream().map(OrgAddrBankAccVO::getCurrCode).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(currCodes) && !CollectionUtils.isEmpty((Collection)(currency = this.comCurrRpcService.findRpcDtoByParam(rpcParam = ComCurrRpcDtoParam.builder().currCodes(currCodes).build())))) {
            Map<String, ComCurrRpcDTO> currMap = currency.stream().collect(Collectors.toMap(ComCurrRpcDTO::getCurrCode, t -> t));
            addrBankAccVos.forEach(acc -> {
                if (!StringUtils.isBlank((CharSequence)acc.getCurrCode()) && currMap.containsKey(acc.getCurrCode())) {
                    acc.setCurrName(((ComCurrRpcDTO)currMap.get(acc.getCurrCode())).getCurrName());
                }
            });
        }
    }

    public OrgAddrBankAccServiceImpl(OrgAddrBankAccRepo orgAddrBankAccRepo, OrgAddrBankAccRepoProc orgAddrBankAccRepoProc) {
        this.orgAddrBankAccRepo = orgAddrBankAccRepo;
        this.orgAddrBankAccRepoProc = orgAddrBankAccRepoProc;
    }
}

