/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.supportdomain.org.convert.OrgAddrQualifyConvert;
import com.elitesland.yst.supportdomain.org.entity.OrgAddrQualifyDO;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.elitesland.yst.supportdomain.org.param.OrgAddrQualifySaveParam;
import com.elitesland.yst.supportdomain.org.repo.OrgAddrQualifyRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgAddrQualifyRepoProc;
import com.elitesland.yst.supportdomain.org.service.OrgAddrQualifyService;
import com.elitesland.yst.supportdomain.org.vo.OrgAddrQualifyVO;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgAddrQualifyServiceImpl
implements OrgAddrQualifyService {
    private final OrgAddrQualifyRepo orgAddrQualifyRepo;
    private final OrgAddrQualifyRepoProc orgAddrQualifyRepoProc;

    @Override
    @SysCodeProc
    public List<OrgAddrQualifyVO> findByAddrNo(Long addrNo) {
        List<OrgAddrQualifyVO> orgAddrQualifyVOList = this.orgAddrQualifyRepoProc.findVoByAddrNo(addrNo);
        this.fill(orgAddrQualifyVOList);
        return orgAddrQualifyVOList;
    }

    private void fill(List<OrgAddrQualifyVO> orgAddrQualifyVOList) {
        orgAddrQualifyVOList.stream().forEach(i -> {
            if (null == i.getLangTermFlag() || 0 == i.getLangTermFlag()) {
                i.setLangTermFlagName(OrgUdcEnum.ORG_DEFAULTVALID_0.getValDesc());
            } else {
                i.setLangTermFlagName(OrgUdcEnum.ORG_DEFAULTVALID_1.getValDesc());
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void orgAddrQualifyHardSave(Long addrNo, List<OrgAddrQualifySaveParam> params) {
        if (addrNo == null) {
            return;
        }
        this.orgAddrQualifyRepo.deleteByAddrNo(addrNo);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<OrgAddrQualifyDO> orgAddrQualifyDos = OrgAddrQualifyConvert.INSTANCE.saveParamToDo(params);
        orgAddrQualifyDos.forEach(t -> t.setAddrNo(addrNo));
        this.orgAddrQualifyRepo.saveAll(orgAddrQualifyDos);
    }

    public OrgAddrQualifyServiceImpl(OrgAddrQualifyRepo orgAddrQualifyRepo, OrgAddrQualifyRepoProc orgAddrQualifyRepoProc) {
        this.orgAddrQualifyRepo = orgAddrQualifyRepo;
        this.orgAddrQualifyRepoProc = orgAddrQualifyRepoProc;
    }
}

