/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.org.convert.OrgAddrConvert;
import com.elitesland.yst.supportdomain.org.entity.OrgAddrDO;
import com.elitesland.yst.supportdomain.org.param.OrgAddrAddressSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgAddrBankAccSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgAddrPagingParam;
import com.elitesland.yst.supportdomain.org.param.OrgAddrSaveParam;
import com.elitesland.yst.supportdomain.org.repo.OrgAddrRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgAddrRepoProc;
import com.elitesland.yst.supportdomain.org.service.OrgAddrAddressService;
import com.elitesland.yst.supportdomain.org.service.OrgAddrBankAccService;
import com.elitesland.yst.supportdomain.org.service.OrgAddrQualifyService;
import com.elitesland.yst.supportdomain.org.service.OrgAddrService;
import com.elitesland.yst.supportdomain.org.vo.OrgAddrDetailVO;
import com.elitesland.yst.supportdomain.org.vo.OrgAddrPagingVO;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgAddrServiceImpl
implements OrgAddrService {
    private final OrgAddrAddressService orgAddrAddressService;
    private final OrgAddrBankAccService orgAddrBankAccService;
    private final OrgAddrQualifyService orgAddrQualifyService;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final OrgAddrRepo orgAddrRepo;
    private final OrgAddrRepoProc orgAddrRepoProc;
    private final UdcService sysUdcService;

    @Override
    @SysCodeProc
    public PagingVO<OrgAddrPagingVO> searchPaging(OrgAddrPagingParam param) {
        return this.orgAddrRepoProc.searchPaging(param);
    }

    @Override
    @SysCodeProc
    public OrgAddrDetailVO searchDetailsByAddrNo(Long addrNo) {
        if (addrNo == null) {
            return null;
        }
        OrgAddrDetailVO orgAddrDetailVO = this.orgAddrRepoProc.findDetailsByAddrNo(addrNo);
        if (orgAddrDetailVO == null) {
            return null;
        }
        orgAddrDetailVO.setOrgAddrAddressVos(this.orgAddrAddressService.findByAddrNo(addrNo));
        orgAddrDetailVO.setOrgAddrBankAccVos(this.orgAddrBankAccService.findByAddrNo(addrNo));
        orgAddrDetailVO.setOrgAddrQualifyVos(this.orgAddrQualifyService.findByAddrNo(addrNo));
        return orgAddrDetailVO;
    }

    @Override
    @SysCodeProc
    public OrgAddrDetailVO searchDetailsById(Long id) {
        OrgAddrDetailVO orgAddrDetailVO = this.orgAddrRepoProc.findDetailsById(id);
        Long addrNo = orgAddrDetailVO.getAddrNo();
        orgAddrDetailVO.setOrgAddrAddressVos(this.orgAddrAddressService.findByAddrNo(addrNo));
        orgAddrDetailVO.setOrgAddrBankAccVos(this.orgAddrBankAccService.findByAddrNo(addrNo));
        orgAddrDetailVO.setOrgAddrQualifyVos(this.orgAddrQualifyService.findByAddrNo(addrNo));
        return orgAddrDetailVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long orgAddrSaveOrUpdateReturnAddrNo(OrgAddrSaveParam param) {
        return this.orgAddrSaveOrUpdate(param).getAddrNo();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long orgAddrSaveOrUpdateReturnId(OrgAddrSaveParam param) {
        return this.orgAddrSaveOrUpdate(param).getId();
    }

    @Override
    public void softDeleteAddrById(Long id) {
        this.orgAddrRepoProc.softDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void softDeleteAddrByAddrNo(Long addrNo) {
        this.orgAddrRepoProc.softDeleteByAddrNo(addrNo);
    }

    @Override
    @Transactional
    public Long updateOrgAddraddrStatus(Long addrNo, String addrStatus) {
        return this.orgAddrRepoProc.updateOrgAddraddrStatus(addrNo, addrStatus);
    }

    @Override
    public Long orgAddraStatusCount(Long addrNo, String addrStatus) {
        return this.orgAddrRepoProc.orgAddraStatusCount(addrNo, addrStatus);
    }

    private OrgAddrDO orgAddrSaveOrUpdate(OrgAddrSaveParam param) {
        Long addrNo;
        OrgAddrDO orgAddrDO = null;
        if (param.getId() == null && param.getAddrNo() == null) {
            if (StringUtils.isBlank((CharSequence)param.getAddrName())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5730\u5740\u8584\u540d\u79f0\u5fc5\u586b");
            }
            if (StringUtils.isBlank((CharSequence)param.getAddrType())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5730\u5740\u8584\u7c7b\u578b\u5fc5\u586b");
            }
            orgAddrDO = OrgAddrConvert.INSTANCE.saveParamToDo(param);
            addrNo = Long.valueOf(this.sysNumberGeneratorWrapper.generate("ADDRNO"));
            if (this.orgAddrRepo.existsByAddrNo(addrNo)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7684\u5730\u5740\u53f7\uff1a" + addrNo + " \u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            }
            orgAddrDO.setAddrNo(addrNo);
            if (ObjectUtils.isNotEmpty((Object)param.getSuppNo())) {
                addrNo = param.getSuppNo();
                orgAddrDO.setAddrNo(param.getSuppNo());
            }
            this.orgAddrRepo.save(orgAddrDO);
        } else {
            Optional<OrgAddrDO> optional = param.getId() != null ? this.orgAddrRepo.findById(param.getId()) : this.orgAddrRepo.findByAddrNo(param.getAddrNo());
            if (optional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5730\u5740\u8584\uff1a" + param.getAddrNo() + " \u4e0d\u5b58\u5728");
            }
            orgAddrDO = optional.get();
        }
        addrNo = orgAddrDO.getAddrNo();
        this.checkAndHardSaveAddrInfo(addrNo, param);
        return orgAddrDO;
    }

    private void checkAndHardSaveAddrInfo(Long addrNo, OrgAddrSaveParam param) {
        List errorData;
        Map accTypeUdc = this.sysUdcService.getCodeMap("ORG", "ADDR_BANKACC_TYPE");
        if (!CollectionUtils.isEmpty(param.getOrgAddrAddressSaveParams())) {
            errorData = param.getOrgAddrAddressSaveParams().stream().filter(t -> t.getAddressType() == null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(errorData)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5730\u5740\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Map addressTypeUdc = this.sysUdcService.getCodeMap("ORG", "ADDRESS_TYPE");
            HashSet needDefaultSet = new HashSet();
            Map<String, List<OrgAddrAddressSaveParam>> addressTypeGroup = param.getOrgAddrAddressSaveParams().stream().collect(Collectors.groupingBy(OrgAddrAddressSaveParam::getAddressType));
            addressTypeGroup.forEach((addressType, addressList) -> {
                List defaultInfo = addressList.stream().filter(address -> address.getDefaultFlag() != null && address.getDefaultFlag() != false).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(defaultInfo)) {
                    needDefaultSet.add(addressType);
                } else if (defaultInfo.size() > 1) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5730\u5740\u7c7b\u578b\uff1a" + addressTypeUdc.getOrDefault(addressType, addressType) + "\uff0c\u9ed8\u8ba4\u5730\u5740\u53ea\u80fd\u6709\u4e00\u4e2a");
                }
            });
            if (CollectionUtils.isNotEmpty(needDefaultSet)) {
                needDefaultSet.forEach(addressType -> {
                    for (OrgAddrAddressSaveParam address : param.getOrgAddrAddressSaveParams()) {
                        if (!addressType.equals(address.getAddressType())) continue;
                        address.setDefaultFlag(true);
                        break;
                    }
                });
            }
        }
        if (!CollectionUtils.isEmpty(param.getOrgAddrBankAccSaveParams())) {
            errorData = param.getOrgAddrBankAccSaveParams().stream().filter(t -> t.getAccType() == null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(errorData)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u53f7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HashSet needDefaultSet = new HashSet();
            Map<String, List<OrgAddrBankAccSaveParam>> accTypeGroup = param.getOrgAddrBankAccSaveParams().stream().collect(Collectors.groupingBy(OrgAddrBankAccSaveParam::getAccType));
            accTypeGroup.forEach((accType, accList) -> {
                List defaultInfo = accList.stream().filter(acc -> acc.getDefaultFlag() != null && acc.getDefaultFlag() != false).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(defaultInfo)) {
                    needDefaultSet.add(accType);
                } else if (defaultInfo.size() > 1) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u53f7\u7c7b\u578b\uff1a" + accTypeUdc.getOrDefault(accType, accType) + "\uff0c\u9ed8\u8ba4\u94f6\u884c\u4fe1\u606f\u53ea\u80fd\u6709\u4e00\u4e2a");
                }
            });
            if (CollectionUtils.isNotEmpty(needDefaultSet)) {
                needDefaultSet.forEach(accType -> {
                    for (OrgAddrBankAccSaveParam acc : param.getOrgAddrBankAccSaveParams()) {
                        if (!accType.equals(acc.getAccType())) continue;
                        acc.setDefaultFlag(true);
                        break;
                    }
                });
            }
        }
        this.orgAddrAddressService.orgAddrAddressHardSave(addrNo, param.getOrgAddrAddressSaveParams());
        this.orgAddrBankAccService.orgAddrBankAccHardSave(addrNo, param.getOrgAddrBankAccSaveParams());
        this.orgAddrQualifyService.orgAddrQualifyHardSave(addrNo, param.getOrgAddrQualifySaveParams());
    }

    public OrgAddrServiceImpl(OrgAddrAddressService orgAddrAddressService, OrgAddrBankAccService orgAddrBankAccService, OrgAddrQualifyService orgAddrQualifyService, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, OrgAddrRepo orgAddrRepo, OrgAddrRepoProc orgAddrRepoProc, UdcService sysUdcService) {
        this.orgAddrAddressService = orgAddrAddressService;
        this.orgAddrBankAccService = orgAddrBankAccService;
        this.orgAddrQualifyService = orgAddrQualifyService;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.orgAddrRepo = orgAddrRepo;
        this.orgAddrRepoProc = orgAddrRepoProc;
        this.sysUdcService = sysUdcService;
    }
}

