/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.service.impl;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.common.util.RedisUtils;
import com.elitesland.yst.supportdomain.org.convert.OrgOuConvert;
import com.elitesland.yst.supportdomain.org.entity.OrgAreaDO;
import com.elitesland.yst.supportdomain.org.entity.OrgOuDO;
import com.elitesland.yst.supportdomain.org.param.OrgAreaSaveParam;
import com.elitesland.yst.supportdomain.org.repo.OrgAreaRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgAreaRepoProc;
import com.elitesland.yst.supportdomain.org.repo.OrgOuRepo;
import com.elitesland.yst.supportdomain.org.service.OrgAreaService;
import com.elitesland.yst.supportdomain.org.vo.OrgAreaDetailVO;
import com.elitesland.yst.supportdomain.org.vo.OrgOuVO;
import com.elitesland.yst.supportdomain.util.BeanCopyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class OrgAreaServiceImpl
implements OrgAreaService {
    private final OrgAreaRepo orgAreaRepo;
    private final OrgAreaRepoProc orgAreaRepoProc;
    private final OrgOuRepo orgOuRepo;
    private final RedisUtils redisUtils;
    private static final String ORG_AREA_CACHE_KEY = "ORG_AREA_OU_ID_";

    @Override
    public List<OrgOuVO> listOuInfo() {
        List<Long> ouIds = this.orgAreaRepoProc.listOuId();
        if (CollectionUtils.isEmpty(ouIds)) {
            return new ArrayList<OrgOuVO>();
        }
        List allById = this.orgOuRepo.findAllById(ouIds);
        return allById.stream().map(OrgOuConvert.INSTANCE::doToVo).collect(Collectors.toList());
    }

    @Override
    public OrgAreaDetailVO findDetailsByOuId(Long ouId) {
        String cacheKey = ORG_AREA_CACHE_KEY + ouId;
        Object redisResult = this.redisUtils.get(cacheKey);
        if (redisResult != null) {
            return (OrgAreaDetailVO)redisResult;
        }
        OrgAreaDetailVO orgAreaDetail = new OrgAreaDetailVO();
        OrgAreaDO queryBean = new OrgAreaDO();
        queryBean.setOuId(ouId);
        List all = this.orgAreaRepo.findAll(Example.of((Object)queryBean));
        OrgOuDO orgOuDO = this.orgOuRepo.findById(ouId).orElse(new OrgOuDO());
        BeanCopyUtil.beanCopy(orgOuDO, orgAreaDetail);
        orgAreaDetail.setOuId(orgOuDO.getId());
        if (CollectionUtils.isEmpty((Collection)all)) {
            return orgAreaDetail;
        }
        orgAreaDetail.setBuCode(StringUtils.isNotBlank((CharSequence)orgOuDO.getBuCode()) ? orgOuDO.getBuCode() : ((OrgAreaDO)all.get(0)).getBuCode());
        orgAreaDetail.setBuId(orgOuDO.getBuId() == null ? ((OrgAreaDO)all.get(0)).getBuId() : orgOuDO.getBuId());
        orgAreaDetail.setBuName(StringUtils.isNotBlank((CharSequence)orgOuDO.getBuName()) ? orgOuDO.getBuName() : ((OrgAreaDO)all.get(0)).getBuName());
        List<OrgAreaDetailVO.Area> areaList = all.stream().map(dbArea -> {
            OrgAreaDetailVO.Area area = new OrgAreaDetailVO.Area();
            BeanCopyUtil.beanCopy(dbArea, area);
            return area;
        }).collect(Collectors.toList());
        orgAreaDetail.setAreaList(areaList);
        if (CollectionUtils.isNotEmpty(orgAreaDetail.getAreaList())) {
            this.redisUtils.set(cacheKey, (Object)orgAreaDetail, 300L);
        }
        return orgAreaDetail;
    }

    @Override
    public List<Long> save(OrgAreaSaveParam orgAreaSaveParams) {
        if (orgAreaSaveParams == null || CollectionUtils.isEmpty(orgAreaSaveParams.getAreaList())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6ca1\u6709\u884c\u653f\u533a\u5212\u4fe1\u606f");
        }
        List<String> countyList = orgAreaSaveParams.getAreaList().stream().map(OrgAreaSaveParam.Area::getCounty).collect(Collectors.toList());
        List<OrgAreaDO> existList = this.orgAreaRepoProc.findExists(orgAreaSaveParams.getOuId(), countyList);
        if (CollectionUtils.isNotEmpty(existList)) {
            OrgOuDO orgOuDO = this.orgOuRepo.findById(existList.get(0).getOuId()).orElse(new OrgOuDO());
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u548c\u516c\u53f8\uff1a" + orgOuDO.getOuName() + "\u884c\u653f\u533a\u5212\u8bbe\u7f6e\u51b2\u7a81");
        }
        String keyArray = ORG_AREA_CACHE_KEY + orgAreaSaveParams.getOuId();
        this.redisUtils.del(new String[]{keyArray});
        List doList = orgAreaSaveParams.getAreaList().stream().map(area -> {
            OrgAreaDO orgAreaDO = new OrgAreaDO();
            BeanCopyUtil.beanCopy(orgAreaSaveParams, orgAreaDO);
            BeanCopyUtil.beanCopy(area, orgAreaDO);
            return orgAreaDO;
        }).collect(Collectors.toList());
        this.orgAreaRepo.deleteAllByOuId(orgAreaSaveParams.getOuId());
        this.orgAreaRepo.saveAll(doList);
        return doList.stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    public OrgAreaServiceImpl(OrgAreaRepo orgAreaRepo, OrgAreaRepoProc orgAreaRepoProc, OrgOuRepo orgOuRepo, RedisUtils redisUtils) {
        this.orgAreaRepo = orgAreaRepo;
        this.orgAreaRepoProc = orgAreaRepoProc;
        this.orgOuRepo = orgOuRepo;
        this.redisUtils = redisUtils;
    }
}

