/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.org.convert.OrgBuConvert;
import com.elitesland.yst.supportdomain.org.dto.OrgBuDTO;
import com.elitesland.yst.supportdomain.org.entity.OrgBuDO;
import com.elitesland.yst.supportdomain.org.entity.OrgOuDO;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.elitesland.yst.supportdomain.org.param.OrgAddrSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuDtoParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuPagingParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuRelationOuParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuStatusParam;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepoProc;
import com.elitesland.yst.supportdomain.org.repo.OrgOuRepo;
import com.elitesland.yst.supportdomain.org.service.OrgAddrService;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import com.elitesland.yst.supportdomain.org.vo.OrgBuDetailsVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuRelationOuVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuVO;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgBuServiceImpl
implements OrgBuService {
    private static final Integer ZERO = 0;
    private final OrgBuRepoProc orgBuRepoProc;
    private final OrgBuRepo orgBuRepo;
    private final OrgOuRepo orgOuRepo;
    private final OrgAddrService orgAddrService;
    private final UdcService sysUdcService;

    @Override
    @SysCodeProc
    public PagingVO<OrgBuVO> queryByParams(OrgBuPagingParam param) {
        PagingVO<OrgBuVO> pageResult = this.orgBuRepoProc.searchByParams(param);
        if (CollectionUtils.isNotEmpty((Collection)pageResult.getRecords())) {
            Map udcMap = this.sysUdcService.getCodeMap("ORG", "BU_TYPE");
            pageResult.getRecords().forEach(s -> s.setBuTypeName(this.buTypeConvert(s.getBuType(), udcMap)));
        }
        return pageResult;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(cacheNames={"ORG_BU_TREE"}, allEntries=true)
    public OrgBuDO saveOrUpdate(OrgBuSaveParam param) {
        OrgBuDO orgBuDO = null;
        OrgAddrSaveParam orgAddrSaveParam = param.getOrgAddrSaveParam();
        if (param.getId() == null) {
            if (this.orgBuRepo.existsByBuCode(param.getBuCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ec4\u7ec7\u7f16\u53f7:" + param.getBuCode() + ",\u5df2\u5b58\u5728");
            }
            orgAddrSaveParam.setId(null);
            orgAddrSaveParam.setAddrName(param.getBuName());
            orgAddrSaveParam.setAddrType(OrgUdcEnum.ADDR_TYPE_BU.getUdcVal());
            Long addrNo = this.orgAddrService.orgAddrSaveOrUpdateReturnAddrNo(orgAddrSaveParam);
            orgBuDO = OrgBuConvert.INSTANCE.saveToDo(param);
            orgBuDO.setAddrNo(addrNo);
        } else {
            if (orgAddrSaveParam.getId() == null) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5730\u5740\u8584ID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
            }
            this.orgAddrService.orgAddrSaveOrUpdateReturnAddrNo(orgAddrSaveParam);
            Optional optional = this.orgBuRepo.findById(param.getId());
            if (optional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ec4\u7ec7\uff1a" + param.getBuCode() + "\u4e0d\u5b58\u5728");
            }
            orgBuDO = (OrgBuDO)optional.get();
            if (OrgUdcEnum.BU_STATUS_ACTIVE.getUdcVal().equals(orgBuDO.getBuStatus())) {
                param.setBuStatus(OrgUdcEnum.BU_STATUS_ACTIVE.getUdcVal());
            }
            OrgBuConvert.INSTANCE.updateDoFromSaveParam(param, orgBuDO);
        }
        OrgBuDO result = (OrgBuDO)this.orgBuRepo.save(orgBuDO);
        if (param.getOuId() != null) {
            orgBuDO.setSecBuId(result.getId());
        }
        if (param.getOuId() != null) {
            orgBuDO.setSecOuId(param.getOuId());
        }
        return result;
    }

    @Override
    public Optional<OrgBuDO> getOrgBuById(String id) {
        Optional optional = this.orgBuRepo.findById(Long.valueOf(id));
        if (!optional.isPresent()) {
            throw new BusinessException("\u7ec4\u7ec7id\uff1a" + id + ", \u4e0d\u5b58\u5728");
        }
        return optional;
    }

    @Override
    @SysCodeProc
    public OrgBuDetailsVO getOrgBuDetailsVOById(Long id) {
        Optional buOptional = this.orgBuRepo.findById(id);
        if (buOptional.isEmpty()) {
            throw new BusinessException("\u7ec4\u7ec7id\uff1a" + id + ", \u4e0d\u5b58\u5728");
        }
        OrgBuDO orgBuDO = (OrgBuDO)buOptional.get();
        OrgBuDetailsVO orgBuDetailsVO = OrgBuConvert.INSTANCE.doToVo(orgBuDO);
        Optional ouOptional = this.orgOuRepo.findById(orgBuDO.getOuId());
        ouOptional.ifPresent(orgOuDO -> orgBuDetailsVO.setOuName(orgOuDO.getOuName()));
        Map udcMap = this.sysUdcService.getCodeMap("ORG", "BU_TYPE");
        orgBuDetailsVO.setBuTypeName(this.buTypeConvert(orgBuDetailsVO.getBuType(), udcMap));
        orgBuDetailsVO.setOrgAddrDetailVO(this.orgAddrService.searchDetailsByAddrNo(orgBuDO.getAddrNo()));
        return orgBuDetailsVO;
    }

    @Override
    @CacheEvict(cacheNames={"ORG_BU_TREE"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public void updateOrgBuStatus(OrgBuStatusParam param) {
        param.getIds().forEach(s -> {
            OrgBuDO orgBuDO = this.getOrgBuById((String)s).get();
            if (!OrgUdcEnum.OU_STATUS_ACTIVE.getUdcVal().equals(param.getBuStatus()) && !param.isForceStop()) {
                OrgOuDO orgOuDO = (OrgOuDO)this.orgOuRepo.findById(orgBuDO.getOuId()).get();
                if (!OrgUdcEnum.OU_STATUS_CLOSED.getUdcVal().equals(orgOuDO.getOuStatus())) {
                    throw new BusinessException("\u5f53\u524d\u7ec4\u7ec7\u5173\u8054\u7684\u516c\u53f8:" + orgOuDO.getOuName() + "\uff0c\u8fd8\u5728\u4f7f\u7528\u4e2d\uff0c\u8bf7\u5148\u505c\u7528\u516c\u53f8\uff0c\u518d\u505c\u7528\u7ec4\u7ec7");
                }
            }
            orgBuDO.setBuStatus(param.getBuStatus());
            orgBuDO.setModifyTime(LocalDateTime.now());
            this.orgBuRepo.save(orgBuDO);
        });
    }

    @Override
    public String buTypeConvert(String buType, Map<String, String> buTypeUdcMap) {
        if (StringUtils.isNotBlank((CharSequence)buType)) {
            return Arrays.stream(StringUtils.split((String)buType, (String)",")).map(s -> buTypeUdcMap.getOrDefault(s, (String)s)).collect(Collectors.joining(","));
        }
        return null;
    }

    private String mergeBuType(String newBuType, String oldBuType) {
        Object mergeBuType = null;
        mergeBuType = StringUtils.isBlank((CharSequence)oldBuType) ? newBuType : (oldBuType.equals(newBuType) ? oldBuType : (Arrays.asList(oldBuType.split(",")).contains(newBuType) ? oldBuType : oldBuType + "," + newBuType));
        return mergeBuType;
    }

    @Override
    public Boolean checkByBuCode(String buCode) {
        if (this.orgBuRepo.existsByBuCode(buCode)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ec4\u7ec7\u7f16\u53f7:" + buCode + "\uff0c\u5df2\u5b58\u5728\uff0c\u8bf7\u57fa\u4e8e\u5df2\u6709\u7ec4\u7ec7\u9009\u62e9");
        }
        return true;
    }

    @Override
    public List<OrgBuRelationOuVO> findBuRelationOuList(OrgBuRelationOuParam orgBuRelationOuParam) {
        return this.orgBuRepoProc.findBuRelationOuList(orgBuRelationOuParam);
    }

    @Override
    public List<OrgBuDTO> findBuDtoByParam(OrgBuDtoParam param) {
        return this.orgBuRepoProc.findDtoByParam(param);
    }

    public OrgBuServiceImpl(OrgBuRepoProc orgBuRepoProc, OrgBuRepo orgBuRepo, OrgOuRepo orgOuRepo, OrgAddrService orgAddrService, UdcService sysUdcService) {
        this.orgBuRepoProc = orgBuRepoProc;
        this.orgBuRepo = orgBuRepo;
        this.orgOuRepo = orgOuRepo;
        this.orgAddrService = orgAddrService;
        this.sysUdcService = sysUdcService;
    }
}

