/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.org.convert.OrgBuTreeConvert;
import com.elitesland.yst.supportdomain.org.convert.OrgBuTreeDConvert;
import com.elitesland.yst.supportdomain.org.entity.OrgBuTreeDDO;
import com.elitesland.yst.supportdomain.org.entity.OrgBuTreeDO;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeDSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeVDSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeVListParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeVSaveParam;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeDRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeDRepoProc;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeRepoProc;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import com.elitesland.yst.supportdomain.org.service.OrgBuTreeDService;
import com.elitesland.yst.supportdomain.org.service.OrgBuTreeVersionService;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreeAndTreeDVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreeDDetailVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreeDVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreeVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreedAllVO;
import com.elitesland.yst.supportdomain.org.vo.SystemBuTreeVO;
import com.elitesland.yst.supportdomain.util.SystemSettingNoEnum;
import com.elitesland.yst.supportdomain.util.TreeUtils;
import com.elitesland.yst.supportdomain.util.UserUtil;
import com.elitesland.yst.supportdomain.util.UtilEnum;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgBuTreeDServiceImpl
implements OrgBuTreeDService {
    private static final String ONE = "1";
    private final OrgBuTreeDRepo orgBuTreeDRepo;
    private final OrgBuTreeDRepoProc orgBuTreeDRepoProc;
    private final OrgBuService orgBuService;
    private final OrgBuTreeRepo orgBuTreeRepo;
    private final OrgBuTreeRepoProc orgBuTreeRepoProc;
    private final OrgBuTreeVersionService orgBuTreeVersionService;
    private final UdcService sysUdcService;

    @Override
    @CacheEvict(cacheNames={"ORG_BU_TREE"}, key="'BU_TREE_ID_'+#paramList.get(0).buTreeId")
    @Transactional(rollbackFor={Exception.class})
    public List<OrgBuTreeDDetailVO> orgBuTreeDCreate(List<OrgBuTreeDSaveParam> paramList) {
        boolean isRoot;
        if (CollectionUtils.isEmpty(paramList)) {
            return Collections.emptyList();
        }
        ArrayList<OrgBuTreeDDO> buTreeDDos = new ArrayList<OrgBuTreeDDO>();
        paramList.forEach(s -> {
            if (!this.buIdIsExist((OrgBuTreeDSaveParam)s).booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ec4\u7ec7\u6811\u8282\u70b9\u65b0\u589e\u5931\u8d25\uff0c\u5f53\u524d\u7ec4\u7ec7\u6811\u4e0a\u5df2\u5b58\u5728\u8be5\u7ec4\u7ec7\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            }
            buTreeDDos.add(OrgBuTreeDConvert.INSTANCE.saveParamToDo((OrgBuTreeDSaveParam)s));
        });
        boolean bl = isRoot = ((OrgBuTreeDDO)buTreeDDos.get(0)).getPid() == null || ((OrgBuTreeDDO)buTreeDDos.get(0)).getPid().equals(0L);
        if (isRoot) {
            long pid = 0L;
            int level = 1;
            buTreeDDos.forEach(ddo -> {
                ddo.setPid(pid);
                ddo.setGrade(level);
                ddo.setCodePath(ddo.getBuCode());
            });
        } else {
            Optional pBuNodeOptional = this.orgBuTreeDRepo.findById(((OrgBuTreeDDO)buTreeDDos.get(0)).getPid());
            if (pBuNodeOptional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u7236\u7ea7\u7ec4\u7ec7");
            }
            OrgBuTreeDDO pBuNode = (OrgBuTreeDDO)pBuNodeOptional.get();
            Integer level = pBuNode.getGrade() == null ? null : Integer.valueOf(pBuNode.getGrade() + 1);
            String codePath = pBuNode.getCodePath() == null ? null : pBuNode.getCodePath();
            buTreeDDos.forEach(ddo -> {
                ddo.setGrade(level);
                ddo.setCodePath(codePath == null ? null : codePath + "/" + ddo.getBuCode());
            });
        }
        List resultList = this.orgBuTreeDRepo.saveAll(buTreeDDos);
        if (StringUtils.isNotBlank((CharSequence)paramList.get(0).getBuTreeDId())) {
            List<OrgBuTreeDDO> orgBuTreeDetailList = this.orgBuTreeDUpdate(paramList, resultList);
            buTreeDDos.addAll(orgBuTreeDetailList);
        }
        List<OrgBuTreeDDetailVO> orgBuTreeDDetailVOList = OrgBuTreeDConvert.INSTANCE.doToVo(buTreeDDos);
        return orgBuTreeDDetailVOList;
    }

    private List<OrgBuTreeDDO> orgBuTreeDUpdate(List<OrgBuTreeDSaveParam> paramList, List<OrgBuTreeDDO> resultList) {
        ArrayList<OrgBuTreeDDO> orgBuTreeDetailList = new ArrayList();
        if (paramList.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u9009\u4e00\u4e2a\u7236\u7ea7");
        }
        OrgBuTreeDSaveParam orgBuTreeDSaveParam = paramList.get(0);
        Optional orgBuTreeDOptional = this.orgBuTreeDRepo.findById(Long.valueOf(orgBuTreeDSaveParam.getBuTreeDId()));
        if (!orgBuTreeDOptional.isPresent()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38,\u7ec4\u7ec7\u6811\u8282\u70b9:" + orgBuTreeDSaveParam.getBuTreeDId() + "\uff0c\u4e0d\u5b58\u5728");
        }
        OrgBuTreeDDO orgBuTreeDDO = (OrgBuTreeDDO)orgBuTreeDOptional.get();
        List<OrgBuTreeDDO> orgBuTreeDDOList = this.orgBuTreeDRepo.findAllByBuTreeIdAndCodePathLike(orgBuTreeDDO.getBuTreeId(), orgBuTreeDDO.getCodePath() + "%");
        Long pid = resultList.get(0).getId();
        String oldCodePath = orgBuTreeDDO.getCodePath();
        String newCodePath = resultList.get(0).getCodePath() + "/" + orgBuTreeDDO.getBuCode();
        List saveDos = orgBuTreeDDOList.stream().map(s -> {
            if (String.valueOf(s.getId()).equals(orgBuTreeDSaveParam.getBuTreeDId())) {
                s.setPid(pid);
            }
            s.setCodePath(s.getCodePath().replace(oldCodePath, newCodePath));
            s.setGrade(s.getGrade() + 1);
            return s;
        }).collect(Collectors.toList());
        orgBuTreeDetailList = this.orgBuTreeDRepo.saveAll(saveDos);
        return orgBuTreeDetailList;
    }

    @Override
    @CacheEvict(cacheNames={"ORG_BU_TREE"}, key="'BU_TREE_ID_'+#buTreeId")
    @Transactional(rollbackFor={Exception.class})
    public void deleteTreeDetail(Long id, Long buTreeId) {
        List<OrgBuTreedAllVO> result = this.orgBuTreedAllSearch(id, UtilEnum.CODE_TYPE.getValue(), buTreeId);
        result.stream().map(s -> s.getId()).forEach(arg_0 -> ((OrgBuTreeDRepo)this.orgBuTreeDRepo).deleteById(arg_0));
        this.orgBuTreeDRepo.deleteById(id);
    }

    @Override
    @SysCodeProc
    public List<OrgBuTreedAllVO> orgBuTreedAllSearch(Long id, String searchType, Long buTreeId) {
        if (UtilEnum.CODE_TYPE.getValue().equals(searchType)) {
            ArrayList<OrgBuTreedAllVO> result = new ArrayList<OrgBuTreedAllVO>();
            List<OrgBuTreedAllVO> orgBuTreedVOList = this.orgBuTreeDRepoProc.selectAllBuByBuTreeId(buTreeId);
            if (CollectionUtils.isNotEmpty(orgBuTreedVOList)) {
                Map udcMap = this.sysUdcService.getCodeMap("ORG", "BU_TYPE");
                orgBuTreedVOList.forEach(s -> s.setBuTypeName(this.orgBuService.buTypeConvert(s.getBuType(), udcMap)));
                return this.build(orgBuTreedVOList, id, result);
            }
            return Collections.emptyList();
        }
        return this.orgBuTreeDRepoProc.selectByPid(id);
    }

    @Override
    public List<OrgBuTreeDVO> orgBuTreeDSearchTree(Long buTreeId, String searchType, Long buTreeDId) {
        List<OrgBuTreeDVO> treeVos = this.orgBuTreeDRepoProc.searchByBuTreeId(buTreeId, searchType);
        if (CollectionUtils.isNotEmpty(treeVos)) {
            Map udcMap = this.sysUdcService.getCodeMap("ORG", "BU_TYPE");
            treeVos.forEach(s -> s.setBuTypeName(this.orgBuService.buTypeConvert(s.getBuType(), udcMap)));
            List<OrgBuTreeDVO> orgBuTreeDVOS = TreeUtils.buildTree(buTreeDId, true, treeVos);
            return orgBuTreeDVOS;
        }
        return Collections.emptyList();
    }

    private List<OrgBuTreedAllVO> build(List<OrgBuTreedAllVO> orgBuTreedVOList, Long id, List<OrgBuTreedAllVO> result) {
        List treedList = orgBuTreedVOList.stream().filter(s -> id.equals(s.getPid())).collect(Collectors.toList());
        for (OrgBuTreedAllVO vo : treedList) {
            result.add(vo);
            this.build(orgBuTreedVOList, vo.getId(), result);
        }
        return result;
    }

    public Boolean buIdIsExist(OrgBuTreeDSaveParam param) {
        List buIds;
        Optional<List<OrgBuTreeDDO>> optional = this.orgBuTreeDRepo.findByBuTreeId(Long.valueOf(param.getBuTreeId()));
        if (optional.isPresent() && StringUtils.isNotBlank((CharSequence)param.getBuId()) && (buIds = optional.get().stream().map(s -> s.getBuId()).collect(Collectors.toList())).contains(Long.valueOf(param.getBuId()))) {
            return false;
        }
        return true;
    }

    public List<OrgBuTreedAllVO> buTreedDown(List<OrgBuTreedAllVO> orgBuTreeDDOs, Long pid, List<OrgBuTreedAllVO> result) {
        if (pid == null || pid == 0L) {
            return result;
        }
        Optional<OrgBuTreedAllVO> buOptional = orgBuTreeDDOs.stream().filter(s -> s.getId().equals(pid)).findFirst();
        buOptional.ifPresent(t -> {
            result.add((OrgBuTreedAllVO)t);
            this.buTreedDown(orgBuTreeDDOs, t.getPid(), result);
        });
        return result;
    }

    @Override
    public boolean hshOrgTreeCheck(Long buTreeId) {
        Optional<OrgBuTreeDO> buTreeDOOptional;
        boolean result = false;
        if (buTreeId != null && (buTreeDOOptional = this.orgBuTreeRepo.findByBuTreeCodeAndIsNowVersion(UtilEnum.BU_ORG_HSHORGTREE.getValue(), true)).isPresent() && buTreeId.equals(buTreeDOOptional.get().getId())) {
            result = true;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(cacheNames={"ORG_BU_TREE"}, key="'BU_TREE_ID_' + #param.id", condition="#param.id != null")
    public void saveBuTreeDV(OrgBuTreeVSaveParam param) {
        OrgBuTreeDO orgBuTreeDO = OrgBuTreeConvert.INSTANCE.saveVDParaToDo(param);
        boolean updateFlag = false;
        if (null == param.getId()) {
            if (ONE.equals(param.getBuTreeVersion())) {
                orgBuTreeDO.setNowVersion(ONE);
                if (this.orgBuTreeRepo.existsByBuTreeCode(param.getBuTreeCode())) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ec4\u7ec7\u6811\u7f16\u53f7:" + param.getBuTreeCode() + "\uff0c\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
                }
            } else {
                List<OrgBuTreeVO> buTreeVersion = this.orgBuTreeRepoProc.getBuTreeListByBuTreeCode(OrgBuTreeVListParam.builder().buTreeCode(param.getBuTreeCode()).build());
                Map collect = buTreeVersion.stream().collect(HashMap::new, (m, v) -> m.put(Integer.valueOf(v.getNowVersion()), v.getBuTreeStatus()), HashMap::putAll);
                Optional maxNowVersion = collect.keySet().stream().max(Integer::compareTo);
                if (maxNowVersion.isPresent()) {
                    String status = (String)collect.get(maxNowVersion.get());
                    if (OrgUdcEnum.ORG_BUTREE_STATUS_DRAFT.getUdcVal().equals(status)) {
                        throw new BusinessException("\u5f53\u524d\u5b58\u5728\u5c1a\u672a\u53d1\u5e03\u7684\u7ec4\u7ec7\u6811\uff0c\u65e0\u6cd5\u521b\u5efa\u65b0\u7248\u672c\u7ec4\u7ec7\u6811");
                    }
                }
                Integer maxVersion = null;
                if (maxNowVersion.isPresent()) {
                    maxVersion = (Integer)maxNowVersion.get();
                    String nowVersion = "" + (maxVersion + 1);
                    if (param.getBuTreeVersion().equals(nowVersion)) {
                        orgBuTreeDO.setNowVersion(param.getBuTreeVersion());
                    } else {
                        orgBuTreeDO.setNowVersion(nowVersion);
                    }
                } else {
                    orgBuTreeDO.setNowVersion(param.getBuTreeVersion());
                }
            }
        } else {
            orgBuTreeDO.setNowVersion(param.getBuTreeVersion());
            updateFlag = true;
        }
        orgBuTreeDO.setBuTreeVersion(null);
        Long id = null;
        if (null != param.getId()) {
            Optional byId = this.orgBuTreeRepo.findById(param.getId());
            if (!byId.isPresent()) throw new BusinessException("\u7ec4\u7ec7\u6811\u4e0d\u5b58\u5728");
            OrgBuTreeDO buTreeDO = (OrgBuTreeDO)byId.get();
            OrgBuTreeConvert.INSTANCE.updateDoFromParamV(buTreeDO, param);
            this.orgBuTreeRepo.save(buTreeDO);
            id = buTreeDO.getId();
        } else {
            orgBuTreeDO.setIsNowVersion(false);
            orgBuTreeDO.setBuTreeStatus(OrgUdcEnum.ORG_BUTREE_STATUS_DRAFT.getUdcVal());
            orgBuTreeDO.setDeleteFlag(0);
            OrgBuTreeDO save = (OrgBuTreeDO)this.orgBuTreeRepo.save(orgBuTreeDO);
            id = save.getId();
        }
        List<OrgBuTreeVDSaveParam> buTreeDList = param.getTreeVDSaveParams();
        this.orgBuTreeVersionService.saveBuTreeDV(buTreeDList, id, updateFlag);
    }

    @Override
    public List<String> getBuTreeVersionByBuTreeCode(String buTreeCode) {
        return this.orgBuTreeRepoProc.getBuTreeVersionByBuTreeCode(buTreeCode);
    }

    @Override
    public List<OrgBuTreeVO> getBuTreeListByParam(OrgBuTreeVListParam param) {
        return this.orgBuTreeRepoProc.getBuTreeListByBuTreeCode(param);
    }

    @Override
    @SysCodeProc
    public OrgBuTreeAndTreeDVO getBuTreeDListByBuTreeCode(OrgBuTreeVListParam param) {
        if (StringUtils.isBlank((CharSequence)param.getVersion()) || StringUtils.isBlank((CharSequence)param.getBuTreeCode())) {
            throw new BusinessException("\u7ec4\u7ec7\u6811\u7248\u672c\u548c\u7ec4\u7ec7\u6811\u7f16\u7801\u5fc5\u586b");
        }
        List<OrgBuTreeVO> buTreeListByBuTreeCode = this.orgBuTreeRepoProc.getBuTreeListByBuTreeCode(param);
        if (buTreeListByBuTreeCode.size() == 1) {
            OrgBuTreeVO orgBuTreeVO = buTreeListByBuTreeCode.get(0);
            OrgBuTreeAndTreeDVO orgBuTreeAndTreeDVO = OrgBuTreeConvert.INSTANCE.voToVo(orgBuTreeVO);
            if (orgBuTreeVO != null) {
                orgBuTreeAndTreeDVO.setOrgBuTreeDVOList(this.orgBuTreeVersionService.getOrgBuTreeDByCache(orgBuTreeVO.getId(), UtilEnum.CODE_TYPE.getValue(), null));
            }
            return orgBuTreeAndTreeDVO;
        }
        throw new BusinessException("\u51fa\u73b0\u91cd\u590d\u7248\u672c\u6570\u636e\u8bf7\u68c0\u67e5\u6570\u636e");
    }

    @Override
    public void releaseBuTreeVersion(Long id) {
        Optional nowVersionOptional = this.orgBuTreeRepo.findById(id);
        if (nowVersionOptional.isPresent()) {
            OrgBuTreeDO nowVersion = (OrgBuTreeDO)nowVersionOptional.get();
            List<OrgBuTreeDO> nowActiveBuTreeList = this.orgBuTreeRepoProc.getNowActiveBuTree(nowVersion.getBuTreeCode());
            LocalDateTime now = LocalDateTime.now();
            if (CollectionUtils.isEmpty(nowActiveBuTreeList)) {
                nowVersion.setReleaseTime(now);
                nowVersion.setReleaseUser(Objects.requireNonNull(UserUtil.getNowUser()).getUsername());
                nowVersion.setIsNowVersion(true);
                nowVersion.setBuTreeStatus(OrgUdcEnum.ORG_BUTREE_STATUS_ACTIVE.getUdcVal());
                this.orgBuTreeRepo.save(nowVersion);
            } else {
                int size = nowActiveBuTreeList.size();
                if (size > 1) {
                    throw new BusinessException("\u7ec4\u7ec7\u6811\u5b58\u5728\u591a\u4e2a\u751f\u6548\u7684\u7248\u672c\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
                }
                OrgBuTreeDO oldVersion = nowActiveBuTreeList.get(0);
                oldVersion.setIsNowVersion(false);
                oldVersion.setDisableTime(now);
                oldVersion.setBuTreeStatus(OrgUdcEnum.ORG_BUTREE_STATUS_CLOSED.getUdcVal());
                nowVersion.setReleaseTime(now);
                nowVersion.setReleaseUser(Objects.requireNonNull(UserUtil.getNowUser()).getUsername());
                nowVersion.setIsNowVersion(true);
                nowVersion.setBuTreeStatus(OrgUdcEnum.ORG_BUTREE_STATUS_ACTIVE.getUdcVal());
                this.orgBuTreeRepo.save(oldVersion);
                this.orgBuTreeRepo.save(nowVersion);
            }
        }
    }

    @Override
    public Boolean isSyncJdy() {
        SystemBuTreeVO activeVersionByBuTreeCode = this.orgBuTreeVersionService.findActiveVersionByBuTreeCode(SystemSettingNoEnum.OUTERSYS_ORGSTRUC_TREE.name());
        String systemVersion = activeVersionByBuTreeCode.getVersion();
        String buTreeCode = activeVersionByBuTreeCode.getBuTreeCode();
        List<String> nowVersionList = this.orgBuTreeRepoProc.findActiveVersionByBuTreeCode(buTreeCode);
        if (CollectionUtils.isEmpty(nowVersionList)) {
            throw new BusinessException("\u7ec4\u7ec7\u6811\uff1a" + buTreeCode + ",\u65e0\u751f\u6548\u7248\u672c\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        String nowVersion = nowVersionList.get(0);
        if (nowVersion.equals(systemVersion)) {
            return true;
        }
        return false;
    }

    public OrgBuTreeDServiceImpl(OrgBuTreeDRepo orgBuTreeDRepo, OrgBuTreeDRepoProc orgBuTreeDRepoProc, OrgBuService orgBuService, OrgBuTreeRepo orgBuTreeRepo, OrgBuTreeRepoProc orgBuTreeRepoProc, OrgBuTreeVersionService orgBuTreeVersionService, UdcService sysUdcService) {
        this.orgBuTreeDRepo = orgBuTreeDRepo;
        this.orgBuTreeDRepoProc = orgBuTreeDRepoProc;
        this.orgBuService = orgBuService;
        this.orgBuTreeRepo = orgBuTreeRepo;
        this.orgBuTreeRepoProc = orgBuTreeRepoProc;
        this.orgBuTreeVersionService = orgBuTreeVersionService;
        this.sysUdcService = sysUdcService;
    }
}

