/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.org.convert.OrgBuTreeConvert;
import com.elitesland.yst.supportdomain.org.entity.OrgBuTreeDO;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreePagingParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeStatusParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeVListParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeVOParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeVPagingParam;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeDRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeRepoProc;
import com.elitesland.yst.supportdomain.org.service.OrgBuTreeDService;
import com.elitesland.yst.supportdomain.org.service.OrgBuTreeService;
import com.elitesland.yst.supportdomain.org.service.OrgBuTreeVersionService;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreeDetailVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreePagingVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreeVO;
import com.elitesland.yst.supportdomain.util.UtilEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgBuTreeServiceImpl
implements OrgBuTreeService {
    private final OrgBuTreeRepo orgBuTreeRepo;
    private final OrgBuTreeDRepo orgBuTreeDRepo;
    private final OrgBuTreeRepoProc orgBuTreeRepoProc;
    private final OrgBuTreeDService orgBuTreeDService;
    private final OrgBuTreeVersionService orgBuTreeVersionService;

    @Override
    @CacheEvict(cacheNames={"ORG_BU_TREE"}, key="'BU_TREE_ID_' + #param.id", condition="#param.id != null && !#param.id.isEmpty()")
    @Transactional(rollbackFor={Exception.class})
    public Long orgBuTreeSaveOrUpdate(OrgBuTreeSaveParam param) {
        OrgBuTreeDO orgBuTreeDO;
        if (StringUtils.isNotBlank((CharSequence)param.getId())) {
            Long id = Long.valueOf(param.getId());
            if (this.orgBuTreeRepo.existsByBuTreeCodeAndNowVersionAndIdNot(param.getBuTreeCode(), param.getNowVersion(), id)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ec4\u7ec7\u6811\u7f16\u53f7:" + param.getBuTreeCode() + "\uff0c\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            }
            Optional optional = this.orgBuTreeRepo.findById(id);
            if (optional.isEmpty()) {
                throw new BusinessException("\u7ec4\u7ec7\u6811id\uff1a" + param.getId() + ", \u4e0d\u5b58\u5728");
            }
            orgBuTreeDO = (OrgBuTreeDO)optional.get();
            OrgBuTreeConvert.INSTANCE.updateDoFromSaveParam(param, orgBuTreeDO);
        } else {
            if (this.orgBuTreeRepo.existsByBuTreeCode(param.getBuTreeCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ec4\u7ec7\u6811\u7f16\u53f7:" + param.getBuTreeCode() + "\uff0c\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            }
            orgBuTreeDO = OrgBuTreeConvert.INSTANCE.saveParamToDo(param);
        }
        this.orgBuTreeRepo.save(orgBuTreeDO);
        return orgBuTreeDO.getId();
    }

    @Override
    @SysCodeProc
    public OrgBuTreeDetailVO getOrgBuTreeDetailById(Long id) {
        OrgBuTreeDetailVO orgBuTreeDetailVO = this.orgBuTreeRepoProc.findBuTreeDetailById(id);
        if (orgBuTreeDetailVO != null) {
            orgBuTreeDetailVO.setOrgBuTreeDVOList(this.orgBuTreeVersionService.getOrgBuTreeDByCache(id, UtilEnum.CODE_TYPE.getValue(), null));
        }
        return orgBuTreeDetailVO;
    }

    @Override
    @SysCodeProc
    public PagingVO<OrgBuTreePagingVO> queryOrgBuTreeByParams(OrgBuTreePagingParam param) {
        return this.orgBuTreeRepoProc.searchByParams(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(OrgBuTreeStatusParam param) {
        if (CollectionUtils.isEmpty(param.getIds())) {
            return;
        }
        List<Long> ids = param.getIds().stream().distinct().filter(Objects::nonNull).map(Long::valueOf).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)param.getBuTreeStatus())) {
            return;
        }
        this.orgBuTreeRepoProc.updateStatusByIds(ids, param.getBuTreeStatus());
    }

    @Override
    @SysCodeProc
    public List<OrgBuTreeVO> findOrgBuTreeVoByParam(OrgBuTreeVOParam param) {
        return this.orgBuTreeRepoProc.findOrgBuTreeVoByParam(param);
    }

    @Override
    public PagingVO<OrgBuTreeVO> getBuTreePagingByParam(OrgBuTreeVPagingParam param) {
        return this.orgBuTreeRepoProc.getBuTreePagingByParam(param);
    }

    @Override
    public Boolean getCreateNewVersionFlag(String buTreeCode) {
        List<OrgBuTreeVO> buTreeVersionByBuTreeCode = this.orgBuTreeRepoProc.getBuTreeListByBuTreeCode(OrgBuTreeVListParam.builder().buTreeCode(buTreeCode).build());
        Map collect = buTreeVersionByBuTreeCode.stream().collect(HashMap::new, (m, v) -> m.put(Integer.valueOf(v.getNowVersion()), v.getBuTreeStatus()), HashMap::putAll);
        Optional max = collect.keySet().stream().max(Integer::compareTo);
        if (max.isPresent()) {
            String status = (String)collect.get(max.get());
            return !OrgUdcEnum.ORG_BUTREE_STATUS_DRAFT.getUdcVal().equals(status);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBuTreeById(Long id) {
        Optional byId = this.orgBuTreeRepo.findById(id);
        if (byId.isPresent()) {
            OrgBuTreeDO buTreeDO = (OrgBuTreeDO)byId.get();
            if (!OrgUdcEnum.ORG_BUTREE_STATUS_DRAFT.getUdcVal().equals(buTreeDO.getBuTreeStatus())) {
                throw new BusinessException("\u4ec5\u8349\u7a3f\u72b6\u6001\u7684\u7ec4\u7ec7\u6811\u53ef\u4ee5\u5220\u9664");
            }
        } else {
            throw new BusinessException("\u7ec4\u7ec7\u6811\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        this.orgBuTreeRepo.deleteById(id);
        this.orgBuTreeDRepo.deleteByBuTreeId(id);
    }

    public OrgBuTreeServiceImpl(OrgBuTreeRepo orgBuTreeRepo, OrgBuTreeDRepo orgBuTreeDRepo, OrgBuTreeRepoProc orgBuTreeRepoProc, OrgBuTreeDService orgBuTreeDService, OrgBuTreeVersionService orgBuTreeVersionService) {
        this.orgBuTreeRepo = orgBuTreeRepo;
        this.orgBuTreeDRepo = orgBuTreeDRepo;
        this.orgBuTreeRepoProc = orgBuTreeRepoProc;
        this.orgBuTreeDService = orgBuTreeDService;
        this.orgBuTreeVersionService = orgBuTreeVersionService;
    }
}

