/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.service.impl;

import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.org.convert.OrgBuTreeDConvert;
import com.elitesland.yst.supportdomain.org.dto.OrgBuDTO;
import com.elitesland.yst.supportdomain.org.entity.OrgBuTreeDDO;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.elitesland.yst.supportdomain.org.param.OrgBuDtoParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeVDSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeVListParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeVOParam;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeDRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeDRepoProc;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeRepoProc;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import com.elitesland.yst.supportdomain.org.service.OrgBuTreeVersionService;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreeDVO;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreeVO;
import com.elitesland.yst.supportdomain.org.vo.SystemBuTreeVO;
import com.elitesland.yst.supportdomain.rpc.service.SupportTransferService;
import com.elitesland.yst.supportdomain.util.ConvertUtil;
import com.elitesland.yst.supportdomain.util.TreeUtils;
import com.elitesland.yst.system.vo.SysSettingVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@Service
public class OrgBuTreeVersionServiceImpl
implements OrgBuTreeVersionService {
    private static final Logger log = LoggerFactory.getLogger(OrgBuTreeVersionServiceImpl.class);
    private final SupportTransferService supportTransferService;
    private final OrgBuTreeRepoProc orgBuTreeRepoProc;
    private final OrgBuTreeDRepoProc orgBuTreeDRepoProc;
    private final OrgBuTreeDRepo orgBuTreeDRepo;
    private final OrgBuService orgBuService;
    private final UdcService sysUdcService;
    private final RedissonClient redissonClient;

    @Override
    public SystemBuTreeVO findActiveVersionByBuTreeCode(String systemCode) {
        log.debug("\u83b7\u53d6\u7ec4\u7ec7\u6811\u5f53\u524d\u7248\u672c-\u53c2\u6570\uff1a" + systemCode);
        SysSettingVO sysSettingByNo = this.supportTransferService.findSysSettingByNo(systemCode);
        log.debug("\u83b7\u53d6\u7ec4\u7ec7\u6811\u5f53\u524d\u7248\u672c-\u83b7\u53d6\u7cfb\u7edf\u57df\u914d\u7f6e\uff1a" + sysSettingByNo);
        if (null != sysSettingByNo) {
            String settingVal = sysSettingByNo.getSettingVal();
            List<String> strings = Arrays.asList(settingVal.split("-"));
            String buTreeCode = null;
            String configVersion = null;
            if (strings.size() == 2) {
                buTreeCode = strings.get(0);
                configVersion = strings.get(1);
            } else if (strings.size() == 1) {
                buTreeCode = strings.get(0);
            } else {
                log.debug("\u83b7\u53d6\u7ec4\u7ec7\u6811\u5f53\u524d\u7248\u672c-\u53c2\u6570\u683c\u5f0f\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u7cfb\u7edf\u8bbe\u7f6e\uff1a" + systemCode + ";");
                throw new BusinessException("\u53c2\u6570\u683c\u5f0f\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u7cfb\u7edf\u8bbe\u7f6e\uff1a" + systemCode + ";");
            }
            List<OrgBuTreeVO> buTreeListByParam = this.orgBuTreeRepoProc.getBuTreeListByBuTreeCode(OrgBuTreeVListParam.builder().buTreeCode(buTreeCode).build());
            if (CollectionUtils.isEmpty(buTreeListByParam)) {
                log.debug("\u83b7\u53d6\u7ec4\u7ec7\u6811\u5f53\u524d\u7248\u672c-\u7ec4\u7ec7\u6811\u7f16\u7801\uff1a" + buTreeCode + "\u4e0d\u5b58\u5728");
                throw new BusinessException("\u7ec4\u7ec7\u6811\u7f16\u7801\uff1a" + buTreeCode + "\u4e0d\u5b58\u5728");
            }
            List versionList = buTreeListByParam.stream().filter(param -> {
                String buTreeStatus = param.getBuTreeStatus();
                return OrgUdcEnum.ORG_BUTREE_STATUS_ACTIVE.getUdcVal().equals(buTreeStatus) || OrgUdcEnum.ORG_BUTREE_STATUS_CLOSED.getUdcVal().equals(buTreeStatus);
            }).map(OrgBuTreeVO::getNowVersion).collect(Collectors.toList());
            if (StringUtils.isNotBlank((CharSequence)configVersion) && versionList.contains(configVersion)) {
                SystemBuTreeVO build = SystemBuTreeVO.builder().buTreeCode(buTreeCode).version(configVersion).build();
                log.debug("\u83b7\u53d6\u7ec4\u7ec7\u6811\u5f53\u524d\u7248\u672c-\u7cfb\u7edf\u57df\u914d\u7f6e\u7684\u4fe1\u606f\uff1a" + build);
                this.checkBuTreeVersionStatus(buTreeCode, configVersion, true);
                return build;
            }
            String nowBuTreeVersion = this.getNowBuTreeVersion(buTreeCode);
            SystemBuTreeVO build = SystemBuTreeVO.builder().buTreeCode(buTreeCode).version(nowBuTreeVersion).build();
            log.debug("\u83b7\u53d6\u7ec4\u7ec7\u6811\u5f53\u524d\u7248\u672c-\u652f\u6491\u57df\u5f53\u524d\u751f\u6548\u914d\u7f6e\uff1a" + build);
            this.checkBuTreeVersionStatus(buTreeCode, nowBuTreeVersion, false);
            return build;
        }
        log.debug("\u83b7\u53d6\u7ec4\u7ec7\u6811\u5f53\u524d\u7248\u672c-\u7cfb\u7edf\u53c2\u6570\u4e2d\u5e76\u672a\u914d\u7f6e\u53c2\u6570\uff1a" + systemCode);
        throw new BusinessException("\u83b7\u53d6\u7ec4\u7ec7\u6811\u5f53\u524d\u7248\u672c-\u7cfb\u7edf\u53c2\u6570\u4e2d\u5e76\u672a\u914d\u7f6e\u53c2\u6570\uff1a" + systemCode);
    }

    @Override
    @CacheEvict(cacheNames={"ORG_BU_TREE"}, key="'BU_TREE_ID_' + #buTreeId", condition="#buTreeId != null")
    public void saveBuTreeDV(List<OrgBuTreeVDSaveParam> buTreeDList, Long buTreeId, Boolean updateFlag) {
        List<OrgBuDTO> buDtoByParam;
        if (updateFlag.booleanValue()) {
            this.orgBuTreeDRepo.deleteByBuTreeId(buTreeId);
        }
        if (CollectionUtils.isEmpty(buTreeDList)) {
            return;
        }
        ArrayList<OrgBuTreeVDSaveParam> treeToList = new ArrayList<OrgBuTreeVDSaveParam>();
        TreeUtils.treeToList(buTreeDList, treeToList, 0L);
        List<OrgBuTreeDDO> orgBuTreeDDOS = OrgBuTreeDConvert.INSTANCE.saveListToDoList(treeToList);
        Set collect = orgBuTreeDDOS.stream().collect(Collectors.collectingAndThen(Collectors.groupingBy(OrgBuTreeDDO::getBuCode, Collectors.counting()), map -> map.entrySet().stream().filter(maps -> (Long)maps.getValue() > 1L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).keySet()));
        if (CollectionUtils.isNotEmpty((Collection)collect) && CollectionUtils.isNotEmpty(buDtoByParam = this.orgBuService.findBuDtoByParam(OrgBuDtoParam.builder().buCodes(new ArrayList<String>(collect)).build()))) {
            String repeatStr = buDtoByParam.stream().map(dto -> dto.getBuName() + "-" + dto.getBuCode()).collect(Collectors.joining(","));
            throw new BusinessException("\u7ec4\u7ec7\u8282\u70b9\u91cd\u590d\uff1a" + repeatStr);
        }
        Map<Long, OrgBuTreeDDO> idMap = orgBuTreeDDOS.stream().collect(Collectors.toMap(BaseModel::getId, t -> t));
        orgBuTreeDDOS.forEach(treeD -> {
            treeD.setBuTreeId(buTreeId);
            ArrayList<String> codePaths = new ArrayList<String>();
            this.recursionStart(idMap, treeD.getPid(), codePaths);
            Collections.reverse(codePaths);
            String join = String.join((CharSequence)"/", codePaths);
            if (StringUtils.isBlank((CharSequence)join)) {
                treeD.setCodePath(String.valueOf(treeD.getBuCode()));
                treeD.setGrade(1);
            } else {
                treeD.setCodePath(join + "/" + treeD.getBuCode());
                treeD.setGrade(treeD.getCodePath().split("/").length);
            }
        });
        ArrayList<OrgBuTreeDDO> tempList = new ArrayList<OrgBuTreeDDO>();
        try {
            for (OrgBuTreeDDO orgBuTreeDDO : orgBuTreeDDOS) {
                tempList.add(orgBuTreeDDO.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new BusinessException("\u6df1\u514b\u9686\u5bf9\u8c61\u5931\u8d25");
        }
        List saveDOs = orgBuTreeDDOS.stream().peek(dos -> dos.setId(null)).collect(Collectors.toList());
        List newTreeDDOs = this.orgBuTreeDRepo.saveAll(saveDOs);
        Map<Long, Long> connectMap = this.connect(tempList, newTreeDDOs);
        newTreeDDOs.forEach(b -> {
            Long pid = (Long)connectMap.get(b.getPid());
            if (null != pid) {
                b.setPid(pid);
            }
        });
        this.orgBuTreeDRepo.saveAll(newTreeDDOs);
    }

    @Override
    public List<OrgBuTreeDVO> getOrgBuTreeDByCache(Long buTreeId, String searchType, Long buTreeDId) {
        RBucket bucket = this.redissonClient.getBucket("ORG_BU_TREE::BU_TREE_ID_" + buTreeId);
        Object result = bucket.get();
        if (null != result) {
            List<OrgBuTreeDVO> orgBuTreeDVOS = ConvertUtil.castList(result, OrgBuTreeDVO.class);
            return orgBuTreeDVOS;
        }
        List<OrgBuTreeDVO> treeVos = this.orgBuTreeDRepoProc.searchByBuTreeId(buTreeId, searchType);
        if (CollectionUtils.isNotEmpty(treeVos)) {
            Map udcMap = this.sysUdcService.getCodeMap("ORG", "BU_TYPE");
            treeVos.forEach(s -> s.setBuTypeName(this.orgBuService.buTypeConvert(s.getBuType(), udcMap)));
            List<OrgBuTreeDVO> orgBuTreeDVOS = TreeUtils.buildTree(buTreeDId, true, treeVos);
            bucket.set(orgBuTreeDVOS, 1L, TimeUnit.DAYS);
            return orgBuTreeDVOS;
        }
        return Collections.emptyList();
    }

    private Map<Long, Long> connect(List<OrgBuTreeDDO> from, List<OrgBuTreeDDO> to) {
        HashMap<Long, Long> map = new HashMap<Long, Long>(16);
        int size = from.size();
        for (int i = 0; i < size; ++i) {
            map.put(from.get(i).getId(), to.get(i).getId());
        }
        return map;
    }

    private void recursionStart(Map<Long, OrgBuTreeDDO> collect, Long pid, List<String> codePaths) {
        OrgBuTreeDDO treeClass = collect.get(pid);
        if (null != treeClass) {
            codePaths.add(String.valueOf(treeClass.getBuCode()));
            this.recursionStart(collect, treeClass.getPid(), codePaths);
        }
    }

    private String getNowBuTreeVersion(String buTreeCode) {
        List<String> activeVersionByBuTreeCode = this.orgBuTreeRepoProc.findActiveVersionByBuTreeCode(buTreeCode);
        if (CollectionUtils.isNotEmpty(activeVersionByBuTreeCode)) {
            if (activeVersionByBuTreeCode.size() > 1) {
                throw new BusinessException("\u7ec4\u7ec7\u6811:" + buTreeCode + ",\u5b58\u5728\u591a\u4e2a\u751f\u6548\u7248\u672c");
            }
            return activeVersionByBuTreeCode.get(0);
        }
        throw new BusinessException("\u7ec4\u7ec7\u4e2d\u5fc3\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u6811" + buTreeCode + "\u65e0\u751f\u6548\u7248\u672c\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u6811\u72b6\u6001\u3002");
    }

    public void checkBuTreeVersionStatus(String buTreeCode, String version, boolean isSystem) {
        OrgBuTreeVOParam build = OrgBuTreeVOParam.builder().buTreeCode(buTreeCode).nowVersion(version).build();
        List<OrgBuTreeVO> orgBuTreeVoByParam = this.orgBuTreeRepoProc.findOrgBuTreeVoByParam(build);
        if (CollectionUtils.isNotEmpty(orgBuTreeVoByParam)) {
            if (orgBuTreeVoByParam.size() > 1) {
                throw new BusinessException("\u7ec4\u7ec7\u6811:" + buTreeCode + ",\u5b58\u5728\u591a\u4e2a\u7248\u672c\uff1aV" + version);
            }
            OrgBuTreeVO orgBuTreeVO = orgBuTreeVoByParam.get(0);
            if (!OrgUdcEnum.ORG_BUTREE_STATUS_ACTIVE.getUdcVal().equals(orgBuTreeVO.getBuTreeStatus()) || !orgBuTreeVO.getIsNowVersion().booleanValue()) {
                if (isSystem) {
                    throw new BusinessException("\u7cfb\u7edf\u914d\u7f6e\u53c2\u6570\u4e3a:\u7ec4\u7ec7\u6811" + buTreeCode + "\u7248\u672cV" + version + "\uff0c\u8be5\u7248\u672c\u4e3a\u5df2\u505c\u7528\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5\u7cfb\u7edf\u914d\u7f6e\u53c2\u6570\u3002");
                }
                throw new BusinessException("\u7ec4\u7ec7\u4e2d\u5fc3\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u6811" + buTreeCode + "\u65e0\u751f\u6548\u7248\u672c\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u6811\u72b6\u6001\u3002");
            }
        } else {
            throw new BusinessException("\u7ec4\u7ec7\u6811\uff1a" + buTreeCode + "\u7248\u672cV" + version + ",\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
    }

    public OrgBuTreeVersionServiceImpl(SupportTransferService supportTransferService, OrgBuTreeRepoProc orgBuTreeRepoProc, OrgBuTreeDRepoProc orgBuTreeDRepoProc, OrgBuTreeDRepo orgBuTreeDRepo, OrgBuService orgBuService, UdcService sysUdcService, RedissonClient redissonClient) {
        this.supportTransferService = supportTransferService;
        this.orgBuTreeRepoProc = orgBuTreeRepoProc;
        this.orgBuTreeDRepoProc = orgBuTreeDRepoProc;
        this.orgBuTreeDRepo = orgBuTreeDRepo;
        this.orgBuService = orgBuService;
        this.sysUdcService = sysUdcService;
        this.redissonClient = redissonClient;
    }
}

