/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.service.impl;

import com.elitesland.yst.supportdomain.org.convert.OrgEmpBuConvert;
import com.elitesland.yst.supportdomain.org.entity.OrgEmpBuDO;
import com.elitesland.yst.supportdomain.org.param.OrgEmpBuSaveParam;
import com.elitesland.yst.supportdomain.org.repo.OrgEmpBuRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgEmpBuRepoProc;
import com.elitesland.yst.supportdomain.org.service.OrgEmpBuService;
import com.elitesland.yst.supportdomain.org.vo.OrgEmpBuVO;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgEmpBuServiceImpl
implements OrgEmpBuService {
    private final OrgEmpBuRepo orgEmpBuRepo;
    private final OrgEmpBuRepoProc orgEmpBuRepoProc;

    @Override
    public List<OrgEmpBuVO> findEmpBuVoByEmpIds(List<Long> empIds) {
        return this.orgEmpBuRepoProc.findEmpBuVoByEmpIds(empIds);
    }

    @Override
    public List<OrgEmpBuVO> findEmpBuVoByEmpIdsAndVersion(List<Long> empId, String version) {
        return this.orgEmpBuRepoProc.findEmpBuVoByEmpIdsAndVersion(empId, version);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void orgEmpBuHardSave(Long empId, List<OrgEmpBuSaveParam> params) {
        if (empId == null) {
            return;
        }
        this.orgEmpBuRepo.deleteByEmpId(empId);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List orgEmpDos = params.stream().map(param -> {
            OrgEmpBuDO orgEmpDo = OrgEmpBuConvert.INSTANCE.saveParamToDo((OrgEmpBuSaveParam)param);
            orgEmpDo.setEmpId(empId);
            return orgEmpDo;
        }).collect(Collectors.toList());
        this.orgEmpBuRepo.saveAll(orgEmpDos);
    }

    public OrgEmpBuServiceImpl(OrgEmpBuRepo orgEmpBuRepo, OrgEmpBuRepoProc orgEmpBuRepoProc) {
        this.orgEmpBuRepo = orgEmpBuRepo;
        this.orgEmpBuRepoProc = orgEmpBuRepoProc;
    }
}

