/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.service.impl;

import com.elitesland.supp.outPermission.TmUserPermissionsProvider;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.org.convert.OrgEmpConvert;
import com.elitesland.yst.supportdomain.org.entity.OrgBuDO;
import com.elitesland.yst.supportdomain.org.entity.OrgEmpDO;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.elitesland.yst.supportdomain.org.param.OrgAddrSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgEmpBuSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgEmpPagingParam;
import com.elitesland.yst.supportdomain.org.param.OrgEmpSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgEmpSwitchStsParam;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgEmpRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgEmpRepoProc;
import com.elitesland.yst.supportdomain.org.service.OrgAddrService;
import com.elitesland.yst.supportdomain.org.service.OrgEmpBuService;
import com.elitesland.yst.supportdomain.org.service.OrgEmpService;
import com.elitesland.yst.supportdomain.org.vo.OrgEmpBuInfo;
import com.elitesland.yst.supportdomain.org.vo.OrgEmpBuVO;
import com.elitesland.yst.supportdomain.org.vo.OrgEmpDetailVO;
import com.elitesland.yst.supportdomain.org.vo.OrgEmpPagingVO;
import com.elitesland.yst.supportdomain.org.vo.OrgUserEmpInfoVO;
import com.elitesland.yst.system.param.SysUserBatchSwitchParam;
import com.elitesland.yst.system.service.SysUserService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgEmpServiceImpl
implements OrgEmpService {
    private static final Integer ZERO = 0;
    private final UdcService sysUdcService;
    private final OrgAddrService orgAddrService;
    private final OrgEmpBuService orgEmpBuService;
    private final OrgBuRepo orgBuRepo;
    private final OrgEmpRepo orgEmpRepo;
    private final OrgEmpRepoProc orgEmpRepoProc;
    @DubboReference(version="${provider.service.version}")
    private SysUserService sysUserService;
    @DubboReference
    private TmUserPermissionsProvider tmUserPermissionsProvider;

    @Override
    @SysCodeProc
    public PagingVO<OrgEmpPagingVO> searchPagingByParam(OrgEmpPagingParam param) {
        PagingVO<OrgEmpPagingVO> result = this.orgEmpRepoProc.searchPaging(param);
        if (CollectionUtils.isNotEmpty((Collection)result.getRecords())) {
            Map udcMap = this.sysUdcService.getCodeMap("ORG", "EMP_TYPE");
            List<Long> empIds = result.getRecords().stream().map(OrgEmpPagingVO::getId).collect(Collectors.toList());
            List<OrgEmpBuVO> empBuVos = this.orgEmpBuService.findEmpBuVoByEmpIds(empIds);
            Map<Long, List<OrgEmpBuVO>> empBuMap = empBuVos.stream().collect(Collectors.groupingBy(OrgEmpBuVO::getEmpId));
            result.getRecords().forEach(vo -> {
                String empTypeStr = vo.getEmpType();
                if (StringUtils.isNotBlank((CharSequence)empTypeStr)) {
                    String empTypeNameStr = Arrays.stream(empTypeStr.split(",")).map(empType -> udcMap.getOrDefault(empType, "")).collect(Collectors.joining(","));
                    vo.setEmpTypeName(empTypeNameStr);
                }
                if (MapUtils.isNotEmpty((Map)empBuMap) && empBuMap.containsKey(vo.getId())) {
                    String empBuNameStr = ((List)empBuMap.get(vo.getId())).stream().map(OrgEmpBuVO::getEmpBuName).collect(Collectors.joining(","));
                    vo.setEmpBuName(empBuNameStr);
                }
            });
        }
        return result;
    }

    @Override
    public OrgEmpDetailVO searchDetailById(Long id) {
        OrgEmpDetailVO result = this.orgEmpRepoProc.getDetailById(id);
        if (result != null) {
            Map udcMap = this.sysUdcService.getCodeMap("ORG", "EMP_TYPE");
            String buTypeStr = result.getEmpType();
            if (StringUtils.isNotBlank((CharSequence)buTypeStr)) {
                String buTypeNameStr = Arrays.stream(buTypeStr.split(",")).map(buType -> udcMap.getOrDefault(buType, "")).collect(Collectors.joining(","));
                result.setEmpTypeName(buTypeNameStr);
            }
            if (result.getAddrNo() != null) {
                result.setOrgAddrDetailVO(this.orgAddrService.searchDetailsByAddrNo(result.getAddrNo()));
            }
            result.setEmpBuList(this.orgEmpBuService.findEmpBuVoByEmpIds(Collections.singletonList(id)));
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateEmp(OrgEmpSaveParam param) {
        OrgEmpDO orgEmpDO = null;
        orgEmpDO = param.getId() == null ? this.empInsert(param) : this.empUpdate(param);
        this.orgEmpBuService.orgEmpBuHardSave(orgEmpDO.getId(), param.getEmpBuList());
        return orgEmpDO.getId();
    }

    private OrgEmpDO empInsert(OrgEmpSaveParam param) {
        if (this.orgEmpRepo.existsByEmpCode(param.getEmpCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5458\u5de5\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        if (param.getUserId() != null && this.orgEmpRepo.existsByUserId(param.getUserId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7528\u6237\uff1a" + param.getUserName() + " \u5df2\u88ab\u5176\u5b83\u5458\u5de5\u7ed1\u5b9a");
        }
        OrgAddrSaveParam addrSaveParam = param.getOrgAddrSaveParam() != null ? param.getOrgAddrSaveParam() : new OrgAddrSaveParam();
        addrSaveParam.setAddrType(OrgUdcEnum.ADDR_TYPE_EMP.getUdcVal());
        addrSaveParam.setAddrName(param.getEmpName());
        addrSaveParam.setOrgAddrBankAccSaveParams(null);
        addrSaveParam.setOrgAddrQualifySaveParams(null);
        Long addrNo = this.orgAddrService.orgAddrSaveOrUpdateReturnAddrNo(param.getOrgAddrSaveParam());
        OrgEmpDO orgEmpDO = OrgEmpConvert.INSTANCE.saveParamToDo(param);
        orgEmpDO.setAddrNo(addrNo);
        orgEmpDO.setEmpStatus(OrgUdcEnum.EMP_STATUS_ENABLE.getUdcVal());
        this.treeStructureInfoUpdate(orgEmpDO);
        this.secBuIdSet(orgEmpDO, param.getEmpBuList());
        this.secOuIdSet(orgEmpDO, param.getEmpBuList());
        this.orgEmpRepo.save(orgEmpDO);
        return orgEmpDO;
    }

    private OrgEmpDO empUpdate(OrgEmpSaveParam param) {
        if (this.orgEmpRepo.existsByEmpCodeAndIdNot(param.getEmpCode(), param.getId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5458\u5de5\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        if (param.getUserId() != null && this.orgEmpRepo.existsByUserIdAndIdNot(param.getUserId(), param.getId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7528\u6237\uff1a" + param.getUserName() + " \u5df2\u88ab\u5176\u5b83\u5458\u5de5\u7ed1\u5b9a");
        }
        if (param.getOrgAddrSaveParam() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u9519\u8bef\uff0c\u5730\u5740\u8584\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.orgAddrService.orgAddrSaveOrUpdateReturnAddrNo(param.getOrgAddrSaveParam());
        Optional optional = this.orgEmpRepo.findById(param.getId());
        if (optional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6307\u5b9a\u5458\u5de5");
        }
        OrgEmpDO orgEmpDO = (OrgEmpDO)optional.get();
        boolean isPathChange = !param.getPid().equals(orgEmpDO.getPid());
        OrgEmpConvert.INSTANCE.updateDoFromSaveParam(param, orgEmpDO);
        String oldCodePath = null;
        Integer oldLevel = null;
        if (isPathChange) {
            oldCodePath = orgEmpDO.getCodePath();
            oldLevel = orgEmpDO.getGrade();
            this.treeStructureInfoUpdate(orgEmpDO);
        }
        this.secBuIdSet(orgEmpDO, param.getEmpBuList());
        this.secOuIdSet(orgEmpDO, param.getEmpBuList());
        this.orgEmpRepo.save(orgEmpDO);
        if (isPathChange) {
            this.childNodesPathInfoUpdate(orgEmpDO, oldCodePath, oldLevel);
        }
        return orgEmpDO;
    }

    private void treeStructureInfoUpdate(OrgEmpDO orgEmpDO) {
        if (orgEmpDO.getPid() == null || orgEmpDO.getPid() == 0L) {
            orgEmpDO.setPid(0L);
            orgEmpDO.setGrade(1);
            orgEmpDO.setCodePath(orgEmpDO.getEmpCode());
        } else {
            Optional pEmpOptional = this.orgEmpRepo.findById(orgEmpDO.getPid());
            if (pEmpOptional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6307\u5b9a\u4e0a\u7ea7\u5458\u5de5");
            }
            OrgEmpDO pEmp = (OrgEmpDO)pEmpOptional.get();
            if (pEmp.getCodePath().contains(orgEmpDO.getCodePath())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e0d\u80fd\u6307\u5b9a\u81ea\u5df1\u7684\u4e0b\u7ea7\u4e3a\u4e0a\u7ea7");
            }
            orgEmpDO.setGrade(pEmp.getGrade() + 1);
            orgEmpDO.setCodePath(pEmp.getCodePath() + "/" + orgEmpDO.getEmpCode());
        }
    }

    private void childNodesPathInfoUpdate(OrgEmpDO orgEmpDO, String oldCodePath, Integer oldLevel) {
        List<OrgEmpDO> childNodes = this.orgEmpRepo.findAllByCodePathLike(oldCodePath + "/%");
        if (CollectionUtils.isNotEmpty(childNodes)) {
            String newCodePath = orgEmpDO.getCodePath();
            int levelChange = orgEmpDO.getGrade() - oldLevel;
            childNodes.forEach(emp -> {
                emp.setCodePath(emp.getCodePath().replace(oldCodePath, newCodePath));
                emp.setGrade(emp.getGrade() + levelChange);
            });
            this.orgEmpRepo.saveAll(childNodes);
        }
    }

    @Override
    public OrgUserEmpInfoVO userEmpInfo(Long userId) {
        List<OrgEmpBuInfo> empBuInfos;
        OrgUserEmpInfoVO result = this.orgEmpRepoProc.userEmpInfo(userId);
        if (result != null && result.getEmpId() != null && CollectionUtils.isNotEmpty(empBuInfos = this.orgEmpRepoProc.findUserEmpBuInfoByEmpId(result.getEmpId()))) {
            OrgEmpConvert.INSTANCE.updateEmpBuInfoToEmpInfo(empBuInfos.get(0), result);
        }
        return result;
    }

    @Override
    public void switchEmpSts(OrgEmpSwitchStsParam param) {
        List allById = this.orgEmpRepo.findAllById(param.getEmpIds());
        Set stsSet = allById.stream().map(OrgEmpDO::getEmpStatus).collect(Collectors.toSet());
        if (stsSet.size() > 1) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u672c\u6b21\u6279\u91cf\u64cd\u4f5c\u5458\u5de5\u7684\u72b6\u6001\u4e0d\u4e00\u81f4");
        }
        allById.forEach(emp -> emp.setEmpStatus(param.getSwitchStsValue()));
        this.orgEmpRepo.saveAll(allById);
        if (param.isSwitchUserFlag()) {
            this.updateUserSts(param, allById);
        }
    }

    private void updateUserSts(OrgEmpSwitchStsParam param, List<OrgEmpDO> allById) {
        if (param.isSwitchUserFlag()) {
            List collect = allById.stream().map(OrgEmpDO::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                return;
            }
            SysUserBatchSwitchParam request = new SysUserBatchSwitchParam();
            request.setUserIds(collect);
            if (OrgUdcEnum.EMP_STATUS_ENABLE.getUdcVal().equals(param.getSwitchStsValue())) {
                request.setEnable(true);
                this.sysUserService.batchSwitchUserStatus(request);
            } else if (OrgUdcEnum.EMP_STATUS_DISABLE.getUdcVal().equals(param.getSwitchStsValue())) {
                request.setEnable(false);
                this.sysUserService.batchSwitchUserStatus(request);
            }
        }
    }

    private void secBuIdSet(OrgEmpDO orgEmpDO, List<OrgEmpBuSaveParam> empBuList) {
        OrgEmpBuSaveParam orgEmpBuSaveParam = empBuList.get(0);
        Optional buOptional = this.orgBuRepo.findById(orgEmpBuSaveParam.getEmpBuId());
        if (buOptional.isPresent()) {
            orgEmpDO.setSecBuId(((OrgBuDO)buOptional.get()).getId());
        }
    }

    private void secOuIdSet(OrgEmpDO orgEmpDO, List<OrgEmpBuSaveParam> empBuList) {
        OrgEmpBuSaveParam orgEmpBuSaveParam = empBuList.get(0);
        Optional buOptional = this.orgBuRepo.findById(orgEmpBuSaveParam.getEmpBuId());
        if (buOptional.isPresent() && ((OrgBuDO)buOptional.get()).getOuId() != null) {
            orgEmpDO.setSecOuId(((OrgBuDO)buOptional.get()).getOuId());
        }
    }

    private void secUserIdSet(OrgEmpDO orgEmpDO) {
        GeneralUserDetails user = SecurityUtil.getUser();
        if (user != null && user.getSecurityOrgUserEmpBuDTO() != null && user.getSecurityOrgUserEmpBuDTO().getEmpId() != null) {
            orgEmpDO.setSecUserId(user.getSecurityOrgUserEmpBuDTO().getEmpId());
        }
    }

    public OrgEmpServiceImpl(UdcService sysUdcService, OrgAddrService orgAddrService, OrgEmpBuService orgEmpBuService, OrgBuRepo orgBuRepo, OrgEmpRepo orgEmpRepo, OrgEmpRepoProc orgEmpRepoProc) {
        this.sysUdcService = sysUdcService;
        this.orgAddrService = orgAddrService;
        this.orgEmpBuService = orgEmpBuService;
        this.orgBuRepo = orgBuRepo;
        this.orgEmpRepo = orgEmpRepo;
        this.orgEmpRepoProc = orgEmpRepoProc;
    }
}

