/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.org.convert.OrgOuConvert;
import com.elitesland.yst.supportdomain.org.dto.OrgOuDTO;
import com.elitesland.yst.supportdomain.org.entity.OrgBuDO;
import com.elitesland.yst.supportdomain.org.entity.OrgOuDO;
import com.elitesland.yst.supportdomain.org.entity.QOrgOuDO;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.elitesland.yst.supportdomain.org.param.OrgBuSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgOuPagingParam;
import com.elitesland.yst.supportdomain.org.param.OrgOuSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgOuStatusParam;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgOuRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgOuRepoProc;
import com.elitesland.yst.supportdomain.org.service.OrgAddrService;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import com.elitesland.yst.supportdomain.org.service.OrgOuService;
import com.elitesland.yst.supportdomain.org.vo.OrgOuDetailsVO;
import com.elitesland.yst.supportdomain.org.vo.OrgOuVO;
import com.elitesland.yst.supportdomain.util.BeanCopyUtil;
import com.querydsl.core.types.Predicate;
import java.util.List;
import java.util.Optional;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgOuServiceImpl
implements OrgOuService {
    private final OrgOuRepo orgOuRepo;
    private final OrgBuRepo orgBuRepo;
    private final OrgOuRepoProc orgOuRepoProc;
    private final OrgAddrService orgAddrService;
    private final OrgBuService orgBuService;

    @Override
    @CacheEvict(cacheNames={"ORG_BU_TREE"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public Long create(OrgOuSaveParam param) {
        Optional<OrgOuDO> optional = this.getOrgOuByCode(param.getOuCode());
        if (optional.isPresent()) {
            throw new BusinessException("\u516c\u53f8\u7f16\u53f7\uff1a" + param.getOuCode() + ", \u5df2\u7ecf\u5b58\u5728");
        }
        OrgOuDO orgOuDO = OrgOuConvert.INSTANCE.saveToDo(param);
        OrgOuDO ouResult = (OrgOuDO)this.orgOuRepo.save(orgOuDO);
        OrgBuSaveParam orgBuSaveParam = new OrgBuSaveParam();
        orgBuSaveParam = this.ouToBu(param, ouResult.getId(), param.getBuId());
        OrgBuDO buResult = this.orgBuService.saveOrUpdate(orgBuSaveParam);
        buResult.setSecBuId(buResult.getId());
        buResult.setSecOuId(buResult.getOuId());
        this.orgBuRepo.save(buResult);
        ouResult.setAddrNo(buResult.getAddrNo());
        ouResult.setBuId(buResult.getId());
        ouResult.setSecBuId(buResult.getId());
        ouResult.setSecOuId(buResult.getOuId());
        this.orgOuRepo.save(ouResult);
        return ouResult.getId();
    }

    @Override
    @CacheEvict(cacheNames={"ORG_BU_TREE"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public void update(OrgOuSaveParam param) {
        OrgOuDO orgOuDO = this.getOrgOuById(param.getId());
        BeanCopyUtil.beanCopyWithIngore(param, orgOuDO, BeanCopyUtil.getNullPropertyNames(param));
        OrgBuSaveParam orgBuSaveParam = new OrgBuSaveParam();
        orgBuSaveParam = this.ouToBu(param, Long.valueOf(param.getId()), orgOuDO.getBuId());
        OrgBuDO buResult = this.orgBuService.saveOrUpdate(orgBuSaveParam);
        orgOuDO.setBuId(buResult.getId());
        OrgOuDO ouResult = (OrgOuDO)this.orgOuRepo.save(orgOuDO);
    }

    @Override
    @CacheEvict(cacheNames={"ORG_BU_TREE"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public void updateOrgOuStatus(OrgOuStatusParam param) {
        param.getIds().forEach(s -> {
            OrgOuDO orgOuDO = this.getOrgOuById((String)s);
            if (OrgUdcEnum.OU_STATUS_ACTIVE.getUdcVal().equals(param.getOuStatus())) {
                OrgBuDO orgBuDO = (OrgBuDO)this.orgBuRepo.findById(orgOuDO.getBuId()).get();
                if (OrgUdcEnum.BU_STATUS_DRAFT.getUdcVal().equals(orgBuDO.getBuStatus())) {
                    orgBuDO.setBuStatus(OrgUdcEnum.OU_STATUS_ACTIVE.getUdcVal());
                }
                this.orgBuRepo.save(orgBuDO);
            }
            BeanCopyUtil.beanCopyWithIngore(param, orgOuDO, BeanCopyUtil.getNullPropertyNames(param));
            this.orgOuRepo.save(orgOuDO);
        });
    }

    @Override
    @SysCodeProc
    public PagingVO<OrgOuVO> queryOrgOuByParams(OrgOuPagingParam param) {
        PagingVO<OrgOuVO> result = this.orgOuRepoProc.searchByParams(param);
        return result;
    }

    private OrgOuDO getOrgOuById(String id) {
        Optional optional = this.orgOuRepo.findById(Long.valueOf(id));
        if (optional.isEmpty()) {
            throw new BusinessException("\u7ec4\u7ec7id\uff1a" + id + ", \u4e0d\u5b58\u5728");
        }
        return (OrgOuDO)optional.get();
    }

    @Override
    @SysCodeProc
    public OrgOuDetailsVO getOrgOuDetailsVOById(String id) {
        OrgOuDO orgOuDO = this.getOrgOuById(id);
        OrgOuDetailsVO orgOuDetailsVO = OrgOuConvert.INSTANCE.doToDetailsVO(orgOuDO);
        orgOuDetailsVO.setOrgAddrDetailVO(this.orgAddrService.searchDetailsByAddrNo(orgOuDO.getAddrNo()));
        if (orgOuDO.getLegalOuId() != null && orgOuDO.getLegalOuId() != 0L) {
            Optional optional = this.orgOuRepo.findById(orgOuDO.getLegalOuId());
            optional.ifPresent(ouDO -> orgOuDetailsVO.setLegalName(ouDO.getOuName()));
        }
        return orgOuDetailsVO;
    }

    @Override
    public List<OrgOuDTO> findAllOuDto() {
        return this.orgOuRepoProc.findAllOuDto();
    }

    public Optional<OrgOuDO> getOrgOuByCode(String ouCode) {
        QOrgOuDO orgOuDO = QOrgOuDO.orgOuDO;
        Optional result = this.orgOuRepo.findOne((Predicate)orgOuDO.ouCode.eq((Object)ouCode));
        return result;
    }

    public OrgBuSaveParam ouToBu(OrgOuSaveParam param, Long ouId, Long buId) {
        OrgBuSaveParam orgBuSaveParam = new OrgBuSaveParam();
        orgBuSaveParam.setId(buId);
        orgBuSaveParam.setBuType("OU");
        orgBuSaveParam.setBuStatus(param.getOuStatus());
        orgBuSaveParam.setOrgAddrSaveParam(param.getOrgAddrSaveParam());
        if (buId == null) {
            orgBuSaveParam.setBuCode(param.getOuCode());
            orgBuSaveParam.setBuName(param.getOuName());
            orgBuSaveParam.setBuAbbr(param.getOuAbbr());
            orgBuSaveParam.setOuId(ouId);
            orgBuSaveParam.setSortNo(param.getSortNo());
        }
        return orgBuSaveParam;
    }

    public OrgBuDO ouDOToBuDO(OrgOuDO orgOuDO) {
        OrgBuDO orgBuDO = new OrgBuDO();
        orgBuDO.setBuCode(orgOuDO.getOuCode());
        orgBuDO.setBuName(orgOuDO.getOuName());
        orgBuDO.setBuAbbr(orgOuDO.getOuAbbr());
        orgBuDO.setBuType("OU");
        orgBuDO.setBuStatus(OrgUdcEnum.BU_STATUS_ACTIVE.getUdcVal());
        orgBuDO.setOuId(orgOuDO.getId());
        orgBuDO.setSortNo(orgOuDO.getSortNo());
        return orgBuDO;
    }

    public OrgOuServiceImpl(OrgOuRepo orgOuRepo, OrgBuRepo orgBuRepo, OrgOuRepoProc orgOuRepoProc, OrgAddrService orgAddrService, OrgBuService orgBuService) {
        this.orgOuRepo = orgOuRepo;
        this.orgBuRepo = orgBuRepo;
        this.orgOuRepoProc = orgOuRepoProc;
        this.orgAddrService = orgAddrService;
        this.orgBuService = orgBuService;
    }
}

