/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.org.convert.OrgStoreConvert;
import com.elitesland.yst.supportdomain.org.entity.OrgBuDO;
import com.elitesland.yst.supportdomain.org.entity.OrgStoreDO;
import com.elitesland.yst.supportdomain.org.enums.OrgUdcEnum;
import com.elitesland.yst.supportdomain.org.param.OrgBuSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgBuTreeDSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgStorePagingParam;
import com.elitesland.yst.supportdomain.org.param.OrgStoreSaveParam;
import com.elitesland.yst.supportdomain.org.param.OrgStoreStatusParam;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeDRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgOuRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgStoreRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgStoreRepoProc;
import com.elitesland.yst.supportdomain.org.service.OrgAddrService;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import com.elitesland.yst.supportdomain.org.service.OrgBuTreeDService;
import com.elitesland.yst.supportdomain.org.service.OrgStoreService;
import com.elitesland.yst.supportdomain.org.vo.OrgStoreDetailVO;
import com.elitesland.yst.supportdomain.org.vo.OrgStorePagingVO;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgStoreServiceImpl
implements OrgStoreService {
    private final OrgStoreRepo orgStoreRepo;
    private final OrgBuRepo orgBuRepo;
    private final OrgOuRepo orgOuRepo;
    private final OrgAddrService orgAddrService;
    private final OrgBuTreeDService orgBuTreeDService;
    private final OrgStoreRepoProc orgStoreRepoProc;
    private final OrgBuService orgBuService;
    private final OrgBuTreeRepo orgBuTreeRepo;
    private final OrgBuTreeDRepo orgBuTreeDRepo;

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(cacheNames={"ORG_BU_TREE"}, allEntries=true)
    public String saveOrUpdate(OrgStoreSaveParam param) {
        if ((param.getId() == null || param.getId() == 0L) && this.orgStoreRepo.existsByStoreCode(param.getStoreCode())) {
            throw new BusinessException("\u95e8\u5e97\u7f16\u53f7\uff1a" + param.getStoreCode() + ", \u5df2\u7ecf\u5b58\u5728");
        }
        Optional buOptional = this.orgBuRepo.findById(param.getPid());
        OrgStoreDO storeResult = new OrgStoreDO();
        if (buOptional.isPresent()) {
            param.setOuId(((OrgBuDO)buOptional.get()).getOuId());
            OrgBuSaveParam orgBuSaveParam = this.storeToBu(param);
            OrgBuDO buResult = this.orgBuService.saveOrUpdate(orgBuSaveParam);
            param.setBuId(buResult.getId());
            OrgStoreDO orgStoreDO = OrgStoreConvert.INSTANCE.saveParamToDO(param);
            orgStoreDO.setAddrNo(buResult.getAddrNo());
            orgStoreDO.setSecBuId(((OrgBuDO)buOptional.get()).getId());
            orgStoreDO.setSecOuId(((OrgBuDO)buOptional.get()).getOuId());
            storeResult = (OrgStoreDO)this.orgStoreRepo.save(orgStoreDO);
            if (param.getId() == null || param.getId() == 0L) {
                ArrayList<OrgBuTreeDSaveParam> orgBuTreeDSaveParamList = new ArrayList<OrgBuTreeDSaveParam>();
                OrgBuTreeDSaveParam orgBuTreeDSaveParam = new OrgBuTreeDSaveParam();
                orgBuTreeDSaveParam.setBuId(String.valueOf(buResult.getId()));
                orgBuTreeDSaveParam.setBuCode(buResult.getBuCode());
                orgBuTreeDSaveParam.setBuTreeId(String.valueOf(param.getBuTreeId()));
                orgBuTreeDSaveParam.setPid(String.valueOf(param.getBuTreeDId()));
                orgBuTreeDSaveParamList.add(orgBuTreeDSaveParam);
                this.orgBuTreeDService.orgBuTreeDCreate(orgBuTreeDSaveParamList);
            }
        } else {
            throw new BusinessException("\u6240\u5c5e\u7ec4\u7ec7\uff1a" + param.getBuId() + ", \u4e0d\u5b58\u5728");
        }
        return String.valueOf(storeResult.getId());
    }

    private OrgBuSaveParam storeToBu(OrgStoreSaveParam param) {
        OrgBuSaveParam orgBuSaveParam = new OrgBuSaveParam();
        orgBuSaveParam.setId(param.getBuId());
        orgBuSaveParam.setBuType(OrgUdcEnum.BU_TYPE_STORE.getUdcVal() + "," + OrgUdcEnum.BU_TYPE_SALE_BU.getUdcVal());
        orgBuSaveParam.setBuStatus(param.getStoreStatus());
        orgBuSaveParam.setOrgAddrSaveParam(param.getOrgAddrSaveParam());
        if (param.getBuId() == null) {
            orgBuSaveParam.setBuCode(param.getStoreCode());
            orgBuSaveParam.setBuName(param.getStoreName());
            orgBuSaveParam.setBuAbbr(param.getStoreAbbr());
            orgBuSaveParam.setOuId(param.getOuId());
        }
        return orgBuSaveParam;
    }

    @Override
    @SysCodeProc
    public OrgStoreDetailVO getOrgStoreDetail(Long id) {
        Optional storeOptional = this.orgStoreRepo.findById(id);
        OrgStoreDetailVO orgStoreDetailVO = new OrgStoreDetailVO();
        if (storeOptional.isPresent()) {
            orgStoreDetailVO = OrgStoreConvert.INSTANCE.doToDetailVO((OrgStoreDO)storeOptional.get());
            orgStoreDetailVO.setOrgAddrDetailVO(this.orgAddrService.searchDetailsByAddrNo(orgStoreDetailVO.getAddrNo()));
            Optional buOptional = this.orgBuRepo.findById(orgStoreDetailVO.getPid());
            if (buOptional.isPresent()) {
                orgStoreDetailVO.setPidName(((OrgBuDO)buOptional.get()).getBuName());
            }
        }
        return orgStoreDetailVO;
    }

    @Override
    @SysCodeProc
    public PagingVO<OrgStorePagingVO> searchByParams(OrgStorePagingParam param) {
        return this.orgStoreRepoProc.searchByParams(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void statusUpdate(OrgStoreStatusParam param) {
        this.orgStoreRepoProc.statusUpdate(param);
    }

    public OrgStoreServiceImpl(OrgStoreRepo orgStoreRepo, OrgBuRepo orgBuRepo, OrgOuRepo orgOuRepo, OrgAddrService orgAddrService, OrgBuTreeDService orgBuTreeDService, OrgStoreRepoProc orgStoreRepoProc, OrgBuService orgBuService, OrgBuTreeRepo orgBuTreeRepo, OrgBuTreeDRepo orgBuTreeDRepo) {
        this.orgStoreRepo = orgStoreRepo;
        this.orgBuRepo = orgBuRepo;
        this.orgOuRepo = orgOuRepo;
        this.orgAddrService = orgAddrService;
        this.orgBuTreeDService = orgBuTreeDService;
        this.orgStoreRepoProc = orgStoreRepoProc;
        this.orgBuService = orgBuService;
        this.orgBuTreeRepo = orgBuTreeRepo;
        this.orgBuTreeDRepo = orgBuTreeDRepo;
    }
}

