/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.org.service.impl;

import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.org.convert.SysDpRolePowerConvert;
import com.elitesland.yst.supportdomain.org.entity.SysDpRolePowerDO;
import com.elitesland.yst.supportdomain.org.param.SysDpRolePowerSaveParam;
import com.elitesland.yst.supportdomain.org.repo.SysDpRolePowerRepo;
import com.elitesland.yst.supportdomain.org.repo.SysDpRolePowerRepoProc;
import com.elitesland.yst.supportdomain.org.service.OrgBuTreeDService;
import com.elitesland.yst.supportdomain.org.service.SysDpRolePowerService;
import com.elitesland.yst.supportdomain.org.vo.OrgBuTreedAllVO;
import com.elitesland.yst.supportdomain.org.vo.SysDpRolePowerVO;
import com.elitesland.yst.supportdomain.util.UtilEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDpRolePowerServiceImpl
implements SysDpRolePowerService {
    private final SysDpRolePowerRepo sysDpRolePowerRepo;
    private final OrgBuTreeDService orgBuTreeDService;
    private final SysDpRolePowerRepoProc sysDpRolePowerRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(SysDpRolePowerSaveParam param) {
        if (param.getId() == null || param.getId() == 0L) {
            if (UtilEnum.CODE_TYPE.getValue().equals(param.getCreateType())) {
                ArrayList<SysDpRolePowerDO> sysDpRolePowerDOList = new ArrayList<SysDpRolePowerDO>();
                List<OrgBuTreedAllVO> orgBuTreedAllVOList = this.orgBuTreeDService.orgBuTreedAllSearch(param.getBuTreeDId(), UtilEnum.CODE_TYPE.getValue(), param.getBuTreeId());
                orgBuTreedAllVOList.forEach(s -> {
                    SysDpRolePowerDO sysDpRolePowerDO = SysDpRolePowerConvert.INSTANCE.paramToDo(param);
                    sysDpRolePowerDO.setBuId(s.getBuId());
                    sysDpRolePowerDO.setBuTreeDId(s.getId());
                    sysDpRolePowerDOList.add(sysDpRolePowerDO);
                });
                SysDpRolePowerDO sysDpRolePowerDO = SysDpRolePowerConvert.INSTANCE.paramToDo(param);
                sysDpRolePowerDOList.add(sysDpRolePowerDO);
                this.sysDpRolePowerRepo.saveAll(sysDpRolePowerDOList);
            } else {
                this.sysDpRolePowerRepo.save(SysDpRolePowerConvert.INSTANCE.paramToDo(param));
            }
        } else {
            List<Long> buTreeDIds = new ArrayList<Long>();
            if (UtilEnum.CODE_TYPE.getValue().equals(param.getCreateType())) {
                List<OrgBuTreedAllVO> orgBuTreedAllVOList = this.orgBuTreeDService.orgBuTreedAllSearch(param.getBuTreeDId(), UtilEnum.CODE_TYPE.getValue(), param.getBuTreeId());
                buTreeDIds = orgBuTreedAllVOList.stream().map(s -> s.getId()).collect(Collectors.toList());
            }
            buTreeDIds.add(param.getId());
            this.sysDpRolePowerRepoProc.update(buTreeDIds, param.getAcType());
        }
    }

    @Override
    public SysDpRolePowerVO getDetailsByBuTreeDId(Long buTreeDId) {
        Optional optional = this.sysDpRolePowerRepo.findOne(this.sysDpRolePowerRepoProc.where(buTreeDId));
        if (!optional.isPresent()) {
            throw new BusinessException("\u7ec4\u7ec7\u6811id\uff1a" + buTreeDId + ", \u4e0d\u5b58\u5728");
        }
        return SysDpRolePowerConvert.INSTANCE.doToVo((SysDpRolePowerDO)optional.get());
    }

    public SysDpRolePowerServiceImpl(SysDpRolePowerRepo sysDpRolePowerRepo, OrgBuTreeDService orgBuTreeDService, SysDpRolePowerRepoProc sysDpRolePowerRepoProc) {
        this.sysDpRolePowerRepo = sysDpRolePowerRepo;
        this.orgBuTreeDService = orgBuTreeDService;
        this.sysDpRolePowerRepoProc = sysDpRolePowerRepoProc;
    }
}

