/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.picture.repo;

import com.elitesland.yst.supportdomain.picture.entity.QPictureDO;
import com.elitesland.yst.supportdomain.picture.vo.param.PicturePageParam;
import com.elitesland.yst.supportdomain.picture.vo.resp.PictureResp;
import com.elitesland.yst.supportdomain.util.ComUdcEnum;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class PictureRepoProc {
    private final JPAQueryFactory factory;
    private final QPictureDO pictureDO = QPictureDO.pictureDO;

    public long count(PicturePageParam param) {
        return (Long)((JPAQuery)((JPAQuery)this.factory.select((Expression)this.pictureDO.count()).from((EntityPath)this.pictureDO)).where(this.where(param))).fetchOne();
    }

    public List<PictureResp> findPage(PicturePageParam param) {
        JPAQuery query = (JPAQuery)this.factory.select((Expression)Projections.bean(PictureResp.class, (Expression[])new Expression[]{this.pictureDO.id, this.pictureDO.picName, this.pictureDO.position, this.pictureDO.picSort, this.pictureDO.linkType, this.pictureDO.linkUrl, this.pictureDO.backPicAddr, this.pictureDO.backPicName, this.pictureDO.picUrl, this.pictureDO.picStatus, this.pictureDO.touristStatus, this.pictureDO.annBegintime, this.pictureDO.annEndtime})).from((EntityPath)this.pictureDO);
        param.setPaging(query);
        param.fillOrders(query, this.pictureDO);
        query.where(this.where(param));
        return query.fetch();
    }

    private Predicate where(PicturePageParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getPicName())) {
            predicates.add(this.pictureDO.picName.contains(param.getPicName()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getPosition())) {
            predicates.add(this.pictureDO.position.eq((Object)param.getPosition()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getPicStatus())) {
            predicates.add(this.pictureDO.picStatus.eq((Object)param.getPicStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getShowTimeFlag())) {
            LocalDateTime now = LocalDateTime.now();
            if (ComUdcEnum.COM_FALSE.getUdcVal().equals(param.getShowTimeFlag())) {
                predicates.add(this.pictureDO.annBegintime.isNotNull().and((Predicate)this.pictureDO.annBegintime.gt((Comparable)now)).or((Predicate)this.pictureDO.annEndtime.isNotNull().and((Predicate)this.pictureDO.annEndtime.lt((Comparable)now))));
            } else if (ComUdcEnum.COM_TRUE.getUdcVal().equals(param.getShowTimeFlag())) {
                predicates.add(this.pictureDO.annBegintime.isNull().or((Predicate)this.pictureDO.annBegintime.loe((Comparable)now)).and((Predicate)this.pictureDO.annEndtime.isNull().or((Predicate)this.pictureDO.annEndtime.goe((Comparable)now))));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)param.getRegion())) {
            predicates.add(this.pictureDO.region.eq((Object)param.getRegion()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBranchCompany())) {
            predicates.add(this.pictureDO.branchCompany.eq((Object)param.getBranchCompany()));
        }
        if (param.getAnnEndtimeFrom() != null) {
            predicates.add(this.pictureDO.annEndtime.goe((Comparable)param.getAnnEndtimeFrom()));
        }
        if (param.getAnnEndtimeTo() != null) {
            predicates.add(this.pictureDO.annEndtime.lt((Comparable)param.getAnnEndtimeTo()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public PictureRepoProc(JPAQueryFactory factory) {
        this.factory = factory;
    }
}

