/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.picture.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.picture.convert.HomePictureConvert;
import com.elitesland.yst.supportdomain.picture.entity.HomePictureDO;
import com.elitesland.yst.supportdomain.picture.entity.QHomePictureDO;
import com.elitesland.yst.supportdomain.picture.repo.HomePictureRepo;
import com.elitesland.yst.supportdomain.picture.repo.HomePictureRepoProc;
import com.elitesland.yst.supportdomain.picture.service.HomePictureService;
import com.elitesland.yst.supportdomain.picture.vo.param.HomePicturePageParam;
import com.elitesland.yst.supportdomain.picture.vo.resp.HomePictureResp;
import com.elitesland.yst.supportdomain.picture.vo.save.HomePictureSaveVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HomePictureServiceImpl
implements HomePictureService {
    private static final Logger log = LoggerFactory.getLogger(HomePictureServiceImpl.class);
    private final HomePictureRepo homePictureRepo;
    private final HomePictureRepoProc homePictureRepoProc;
    private final JPAQueryFactory jpaQueryFactory;

    @Override
    @SysCodeProc
    public PagingVO<HomePictureResp> findPageBy(HomePicturePageParam param) {
        long total = this.homePictureRepoProc.count(param);
        List<HomePictureResp> list = null;
        if (total > 0L) {
            list = this.homePictureRepoProc.findPage(param);
        }
        return new PagingVO(total, list);
    }

    @Override
    public void save(List<HomePictureSaveVO> saveListVO) {
        if (!CollectionUtils.isEmpty(saveListVO)) {
            for (HomePictureSaveVO saveVO : saveListVO) {
                if (saveVO.getId() == null) {
                    this.homePictureRepo.save(HomePictureConvert.INSTANCE.saveVOToDO(saveVO));
                    continue;
                }
                HomePictureDO homePictureDO = (HomePictureDO)this.homePictureRepo.findById(saveVO.getId()).orElseThrow(new BusinessException("\u6839\u636eid" + saveVO.getId() + "\u672a\u67e5\u8be2\u5230\u56fe\u7247\u6570\u636e"));
                HomePictureConvert.INSTANCE.copySaveVOToDo(saveVO, homePictureDO);
                this.homePictureRepo.save(homePictureDO);
            }
        }
    }

    @Override
    public void delete(Long id) {
        this.homePictureRepo.deleteById(id);
    }

    @Override
    public void batchDelete(List<Long> ids) {
        this.homePictureRepo.deleteAllById(ids);
    }

    @Override
    public HomePictureResp get(long id) {
        return HomePictureConvert.INSTANCE.doToRespVO((HomePictureDO)this.homePictureRepo.findById(id).orElseThrow(new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e")));
    }

    @Override
    @Transactional
    public void updateStatus(HomePictureSaveVO saveVO) {
        if (saveVO.getCarouselStytleStatus() != null) {
            this.jpaQueryFactory.update((EntityPath)QHomePictureDO.homePictureDO).set((Path)QHomePictureDO.homePictureDO.carouselStytleStatus, (Object)saveVO.getCarouselStytleStatus()).where(new Predicate[]{QHomePictureDO.homePictureDO.carouselStytle.eq((Object)saveVO.getCarouselStytle())}).execute();
        }
    }

    @Override
    public PagingVO<HomePictureResp> findPageMall(HomePicturePageParam param) {
        param.setCarouselStytleStatus("1");
        param.setPicStatus("1");
        long total = this.homePictureRepoProc.count(param);
        List<HomePictureResp> list = null;
        if (total > 0L) {
            list = this.homePictureRepoProc.findPage(param);
        }
        return new PagingVO(total, list);
    }

    public HomePictureServiceImpl(HomePictureRepo homePictureRepo, HomePictureRepoProc homePictureRepoProc, JPAQueryFactory jpaQueryFactory) {
        this.homePictureRepo = homePictureRepo;
        this.homePictureRepoProc = homePictureRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

