/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.picture.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.picture.convert.PictureCarouselStytleConvert;
import com.elitesland.yst.supportdomain.picture.entity.PictureCarouselStytleDO;
import com.elitesland.yst.supportdomain.picture.entity.QHomePictureDO;
import com.elitesland.yst.supportdomain.picture.entity.QPictureCarouselStytleDO;
import com.elitesland.yst.supportdomain.picture.repo.PictureCarouselStytleRepo;
import com.elitesland.yst.supportdomain.picture.repo.PictureCarouselStytleRepoProc;
import com.elitesland.yst.supportdomain.picture.service.PictureCarouselStytleService;
import com.elitesland.yst.supportdomain.picture.vo.param.PictureCarouselStytlePageParam;
import com.elitesland.yst.supportdomain.picture.vo.resp.PictureCarouselStytleResp;
import com.elitesland.yst.supportdomain.picture.vo.save.PictureCarouselStytleSaveVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PictureCarouselStytleServiceImpl
implements PictureCarouselStytleService {
    private static final Logger log = LoggerFactory.getLogger(PictureCarouselStytleServiceImpl.class);
    private final PictureCarouselStytleRepo pictureCarouselStytleRepo;
    private final PictureCarouselStytleRepoProc pictureCarouselStytleRepoProc;
    private final JPAQueryFactory jpaQueryFactory;

    @Override
    @SysCodeProc
    public PagingVO<PictureCarouselStytleResp> findPageBy(PictureCarouselStytlePageParam param) {
        long total = this.pictureCarouselStytleRepoProc.count(param);
        List<PictureCarouselStytleResp> list = null;
        if (total > 0L) {
            list = this.pictureCarouselStytleRepoProc.findPage(param);
        }
        return new PagingVO(total, list);
    }

    @Override
    public void save(PictureCarouselStytleSaveVO saveVO) {
        if (saveVO.getId() == null) {
            this.pictureCarouselStytleRepo.save(PictureCarouselStytleConvert.INSTANCE.saveVOToDO(saveVO));
        } else {
            PictureCarouselStytleDO pictureCarouselStytleDO = (PictureCarouselStytleDO)this.pictureCarouselStytleRepo.findById(saveVO.getId()).orElseThrow(new BusinessException("\u6839\u636eid" + saveVO.getId() + "\u672a\u67e5\u8be2\u5230\u56fe\u7247\u6570\u636e"));
            PictureCarouselStytleConvert.INSTANCE.copySaveVOToDo(saveVO, pictureCarouselStytleDO);
            this.pictureCarouselStytleRepo.save(pictureCarouselStytleDO);
        }
    }

    @Override
    public void delete(Long id) {
        this.pictureCarouselStytleRepo.deleteById(id);
    }

    @Override
    public void batchDelete(List<Long> ids) {
        this.pictureCarouselStytleRepo.deleteAllById(ids);
    }

    @Override
    public PictureCarouselStytleResp get(Long id) {
        return PictureCarouselStytleConvert.INSTANCE.doToRespVO((PictureCarouselStytleDO)this.pictureCarouselStytleRepo.findById(id).orElseThrow(new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e")));
    }

    @Override
    @Transactional
    public void updateStatus(PictureCarouselStytleSaveVO saveVO) {
        if (saveVO.getCarouselStytleStatus() != null) {
            this.jpaQueryFactory.update((EntityPath)QHomePictureDO.homePictureDO).set((Path)QHomePictureDO.homePictureDO.carouselStytleStatus, (Object)saveVO.getCarouselStytleStatus()).set((Path)QHomePictureDO.homePictureDO.picStatus, (Object)saveVO.getCarouselStytleStatus()).where(new Predicate[]{QHomePictureDO.homePictureDO.parentId.eq((Object)saveVO.getId())}).execute();
            this.jpaQueryFactory.update((EntityPath)QPictureCarouselStytleDO.pictureCarouselStytleDO).set((Path)QPictureCarouselStytleDO.pictureCarouselStytleDO.carouselStytleStatus, (Object)saveVO.getCarouselStytleStatus()).where(new Predicate[]{QPictureCarouselStytleDO.pictureCarouselStytleDO.id.eq((Object)saveVO.getId())}).execute();
            if (saveVO.getCarouselStytleStatus().equals("1")) {
                this.jpaQueryFactory.update((EntityPath)QHomePictureDO.homePictureDO).set((Path)QHomePictureDO.homePictureDO.carouselStytleStatus, (Object)"0").set((Path)QHomePictureDO.homePictureDO.picStatus, (Object)"0").where(new Predicate[]{QHomePictureDO.homePictureDO.parentId.ne((Object)saveVO.getId())}).execute();
                this.jpaQueryFactory.update((EntityPath)QPictureCarouselStytleDO.pictureCarouselStytleDO).set((Path)QPictureCarouselStytleDO.pictureCarouselStytleDO.carouselStytleStatus, (Object)"0").where(new Predicate[]{QPictureCarouselStytleDO.pictureCarouselStytleDO.id.ne((Object)saveVO.getId())}).execute();
            }
        }
    }

    public PictureCarouselStytleServiceImpl(PictureCarouselStytleRepo pictureCarouselStytleRepo, PictureCarouselStytleRepoProc pictureCarouselStytleRepoProc, JPAQueryFactory jpaQueryFactory) {
        this.pictureCarouselStytleRepo = pictureCarouselStytleRepo;
        this.pictureCarouselStytleRepoProc = pictureCarouselStytleRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

