/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.picture.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.picture.convert.PictureConvert;
import com.elitesland.yst.supportdomain.picture.entity.PictureDO;
import com.elitesland.yst.supportdomain.picture.repo.PictureRepo;
import com.elitesland.yst.supportdomain.picture.repo.PictureRepoProc;
import com.elitesland.yst.supportdomain.picture.service.PictureService;
import com.elitesland.yst.supportdomain.picture.vo.param.PicturePageParam;
import com.elitesland.yst.supportdomain.picture.vo.resp.PictureResp;
import com.elitesland.yst.supportdomain.picture.vo.save.PictureSaveVO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PictureServiceImpl
implements PictureService {
    private static final Logger log = LoggerFactory.getLogger(PictureServiceImpl.class);
    private final PictureRepo repo;
    private final PictureRepoProc proc;

    @Override
    @SysCodeProc
    public PagingVO<PictureResp> findPageBy(PicturePageParam param) {
        long total = this.proc.count(param);
        if (total > 0L) {
            List<PictureResp> list = this.proc.findPage(param);
            return new PagingVO(total, list);
        }
        return new PagingVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(PictureSaveVO saveVO) {
        if (saveVO.getId() == null) {
            this.repo.save(PictureConvert.INSTANCE.saveVOToDO(saveVO));
        } else {
            PictureDO pictureDO = (PictureDO)this.repo.findById(saveVO.getId()).orElseThrow(new BusinessException("\u6839\u636eid" + saveVO.getId() + "\u672a\u67e5\u8be2\u5230\u56fe\u7247\u6570\u636e"));
            PictureConvert.INSTANCE.copySaveVOToDo(saveVO, pictureDO);
            this.repo.save(pictureDO);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(Long id) {
        this.repo.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(List<Long> ids) {
        this.repo.deleteAllById(ids);
    }

    @Override
    @SysCodeProc
    public PictureResp get(long id) {
        return PictureConvert.INSTANCE.doToRespVO((PictureDO)this.repo.findById(id).orElseThrow(new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e")));
    }

    public PictureServiceImpl(PictureRepo repo, PictureRepoProc proc) {
        this.repo = repo;
        this.proc = proc;
    }
}

