/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.pri.component.service.impl;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.pri.component.param.PriMainPriceComPagingParam;
import com.elitesland.yst.supportdomain.pri.component.repo.PriMainPriceComRepoProc;
import com.elitesland.yst.supportdomain.pri.component.service.PriMainPriceComService;
import com.elitesland.yst.supportdomain.pri.component.vo.PriCatePriceComPagingVO;
import com.elitesland.yst.supportdomain.pri.component.vo.PriItemPriceComPagingVO;
import com.elitesland.yst.supportdomain.pri.enums.PriMainPriceUdcEnum;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PriMainPriceComServiceImpl
implements PriMainPriceComService {
    private final PriMainPriceComRepoProc priMainPriceComRepoProc;
    private final ItmItemCateService itmItemCateService;

    @Override
    public PagingVO<PriItemPriceComPagingVO> queryPriItemPriceComByParams(PriMainPriceComPagingParam param) {
        param.setPriceType(PriMainPriceUdcEnum.PRI_PRICE_TYPE_ITEM_PRICE.getUdcVal());
        return this.priMainPriceComRepoProc.searchItemPriceByParams(param);
    }

    @Override
    public PagingVO<PriCatePriceComPagingVO> queryPriCatePriceComByParams(PriMainPriceComPagingParam param) {
        param.setPriceType(PriMainPriceUdcEnum.PRI_PRICE_TYPE_ITEM_CAT_PRICE.getUdcVal());
        PagingVO<PriCatePriceComPagingVO> result = this.priMainPriceComRepoProc.searchCatePriceByParams(param);
        for (PriCatePriceComPagingVO record : result.getRecords()) {
            if (!StringUtils.isNotBlank((CharSequence)record.getItemCateCode())) continue;
            record.setItemCatePath(this.itmItemCateService.findItemCatePath(record.getItemCateCode()));
        }
        return result;
    }

    public PriMainPriceComServiceImpl(PriMainPriceComRepoProc priMainPriceComRepoProc, ItmItemCateService itmItemCateService) {
        this.priMainPriceComRepoProc = priMainPriceComRepoProc;
        this.itmItemCateService = itmItemCateService;
    }
}

