/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.pri.excel.convert;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class PriceLocalDateTimeConverter
implements Converter<LocalDateTime> {
    public Class supportJavaTypeKey() {
        return null;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }

    public LocalDateTime convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        if (StringUtils.isBlank((CharSequence)cellData.getStringValue())) {
            throw new ExcelDataConvertException(cellData.getRowIndex(), cellData.getColumnIndex(), cellData, contentProperty, "\u4ef7\u683c\u751f\u3001\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LocalDateTime result = LocalDateTime.parse(cellData.getStringValue() + " 00:00:00", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        return result;
    }

    public WriteCellData<String> convertToExcelData(LocalDateTime value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return new WriteCellData(value.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
    }
}

