/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.pri.excel.listener;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.item.excel.entity.ErrorInfo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepoProc;
import com.elitesland.yst.supportdomain.pri.excel.entity.ItemPriceUpLoadEntity;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemPriceUpLoadListener
extends AnalysisEventListener<ItemPriceUpLoadEntity> {
    private static final Logger log = LoggerFactory.getLogger(ItemPriceUpLoadListener.class);
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private List<ItemPriceUpLoadEntity> datas = new ArrayList<ItemPriceUpLoadEntity>();
    private List<String> spuCodes;
    private final ErrorInfo errorInfo = new ErrorInfo();
    private final Map<String, String> uomUdc;

    public ItemPriceUpLoadListener(UdcService sysUdcService, ItmItemRepoProc itmItemRepoProc) {
        this.spuCodes = itmItemRepoProc.searchItemCodes();
        this.uomUdc = sysUdcService.getCodeMap("COM", "UOM").entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public void invoke(ItemPriceUpLoadEntity data, AnalysisContext context) {
        BigDecimal price5;
        BigDecimal price4;
        BigDecimal price3;
        BigDecimal price2;
        BigDecimal price1;
        int rowId = context.readSheetHolder().getRowIndex() + 1;
        if (StringUtils.isNotBlank((CharSequence)data.getItemCode())) {
            if (!this.spuCodes.contains(data.getItemCode())) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5546\u54c1\u7f16\u7801", "\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728"));
            }
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5546\u54c1\u7f16\u7801", "\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        LocalDateTime sysTime = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
        if (data.getValidFrom() != null && data.getValidTo() != null) {
            if (data.getValidFrom().isBefore(sysTime)) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f"));
            }
            if (data.getValidTo().isBefore(data.getValidFrom())) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65f6\u95f4"));
            }
        } else {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u751f\u6548\u65f6\u95f4", "\u751f\u6548\u3001\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        boolean price1flag = false;
        if (StringUtils.isNotBlank((CharSequence)data.getPrice1()) && null != (price1 = this.convertType(data.getPrice1(), "\u5e02\u573a\u4ef7", rowId))) {
            price1flag = true;
            if (BigDecimal.ZERO.compareTo(price1) > 0) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5e02\u573a\u4ef7", "\u5e02\u573a\u4ef7\u5fc5\u987b\u5927\u4e8e0"));
            }
        }
        boolean price2flag = false;
        if (StringUtils.isNotBlank((CharSequence)data.getPrice2()) && null != (price2 = this.convertType(data.getPrice2(), "B\u7aef\u6307\u5bfc\u4ef7", rowId))) {
            price2flag = true;
            if (BigDecimal.ZERO.compareTo(price2) > 0) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "B\u7aef\u6307\u5bfc\u4ef7", "B\u7aef\u6307\u5bfc\u4ef7\u5fc5\u987b\u5927\u4e8e0"));
            }
        }
        boolean price3flag = false;
        if (StringUtils.isNotBlank((CharSequence)data.getPrice3()) && null != (price3 = this.convertType(data.getPrice3(), "C\u7aef\u96f6\u552e\u4ef7", rowId))) {
            price3flag = true;
            if (BigDecimal.ZERO.compareTo(price3) > 0) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "C\u7aef\u96f6\u552e\u4ef7", "C\u7aef\u96f6\u552e\u4ef7\u5fc5\u987b\u5927\u4e8e0"));
            }
        }
        boolean price4flag = false;
        BigDecimal DIVISOR = NumberUtil.add((String[])new String[]{"1"});
        if (StringUtils.isNotBlank((CharSequence)data.getPrice4()) && null != (price4 = this.convertType(data.getPrice4(), "B\u7aef\u6bdb\u5229\u63a7\u5236\u7387", rowId))) {
            price4flag = true;
            if (BigDecimal.ZERO.compareTo(price4) > 0 || DIVISOR.compareTo(price4) < 0) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "B\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "\u63a7\u5236\u7387\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\uff0c\u5c0f\u4e8e1"));
            }
        }
        boolean price5flag = false;
        if (StringUtils.isNotBlank((CharSequence)data.getPrice5()) && null != (price5 = this.convertType(data.getPrice5(), "C\u7aef\u6bdb\u5229\u63a7\u5236\u7387", rowId))) {
            price5flag = true;
            if (BigDecimal.ZERO.compareTo(price5) > 0 || DIVISOR.compareTo(price5) < 0) {
                this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "C\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "\u63a7\u5236\u7387\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\uff0c\u5c0f\u4e8e1"));
            }
        }
        if (!(price1flag || price2flag || price3flag || price4flag || price5flag)) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5e02\u573a\u4ef7\u3001B\u7aef\u6307\u5bfc\u4ef7\u3001C\u7aef\u96f6\u552e\u4ef7\u3001B\u7aef\u6bdb\u5229\u63a7\u5236\u7387\u3001C\u7aef\u6bdb\u5229\u63a7\u5236\u7387", "\u4e0d\u80fd\u90fd\u4e3a\u7a7a"));
        }
        this.datas.add(data);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.info("\u89e3\u6790\u5b8c\u6210");
        if (this.errorInfo.hasError()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, this.errorInfo.getLogs().toString());
        }
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        if (!(exception instanceof ExcelDataConvertException)) {
            if (exception instanceof BusinessException) {
                throw exception;
            }
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "Excel\u89e3\u6790\u5f02\u5e38: " + exception.getCause().getMessage());
        }
        log.error("\u89e3\u6790\u5931\u8d25\uff0c\u4f46\u662f\u7ee7\u7eed\u89e3\u6790\u4e0b\u4e00\u884c:{}", (Object)exception.getMessage());
        ExcelDataConvertException excelDataConvertException = (ExcelDataConvertException)exception;
        String logStr = MessageFormat.format(ERROR_TEMPLATE, excelDataConvertException.getRowIndex() + 1, excelDataConvertException.getColumnIndex() + 1 + "\u5217", excelDataConvertException.getCause().getMessage());
        log.error(logStr);
        this.errorInfo.log(logStr);
    }

    public List<ItemPriceUpLoadEntity> getDatas() {
        return this.datas;
    }

    private BigDecimal convertType(String stringNum, String column, int rowId) {
        try {
            return new BigDecimal(stringNum);
        }
        catch (Exception e) {
            this.errorInfo.log(MessageFormat.format(ERROR_TEMPLATE, rowId, column, stringNum + "\u6570\u636e\u8f6c\u6362\u5931\u8d25\u8bf7\u68c0\u67e5\u6570\u636e\u51c6\u786e\u6027"));
            return null;
        }
    }
}

